/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.main.sub;

import com.github.grossopa.hamster.selenium.component.mat.AbstractMatComponent;
import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.hamster.selenium.component.mat.exception.MenuItemNotExpandableException;
import com.github.grossopa.hamster.selenium.component.mat.finder.MatMenuItemFinder;
import com.github.grossopa.hamster.selenium.component.mat.main.MatMenu;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import org.openqa.selenium.WebElement;

public class MatMenuItem
extends AbstractMatComponent {
    public static final String COMPONENT_NAME = "MenuItem";

    public MatMenuItem(WebElement element, ComponentWebDriver driver, MatConfig config) {
        super(element, driver, config);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public boolean validate() {
        return this.attributeContains("class", this.config.getCssPrefix() + "menu-item");
    }

    public boolean isExpandable() {
        return this.attributeContains("class", this.config.getCssPrefix() + "menu-item-submenu-trigger");
    }

    public boolean isExpanded() {
        return this.attributeContains("aria-expanded", "true");
    }

    public MatMenu expand(long animationInMillis, long topMenuDelayInMillis) {
        if (!this.isExpandable()) {
            throw new MenuItemNotExpandableException("the menu item is not expandable.");
        }
        this.driver.moveTo((WebElement)this);
        if (animationInMillis > 0L) {
            this.driver.threadSleep(animationInMillis);
        }
        return new MatMenuItemFinder(this.driver, this.config).findTopMenu(topMenuDelayInMillis);
    }
}

