/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.InteractivePage;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.util.WebClientUtils;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.shell.HostedModePluginObject;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.Platform;
import com.google.gwt.junit.RunStyle;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunStyleHtmlUnit
extends RunStyle {
    private static final Map<String, BrowserVersion> BROWSER_MAP = Maps.newHashMap();
    private static final Map<BrowserVersion, String> USER_AGENT_MAP = Maps.newHashMap();
    private static final int DEFAULT_TRIES = 1;
    private static final Set<Platform> PLATFORMS;
    private Set<BrowserVersion> browsers = new HashSet<BrowserVersion>();
    private boolean developmentMode;
    private final List<Thread> threads = new ArrayList<Thread>();

    private static void addBrowser(BrowserVersion browser, String userAgent) {
        BROWSER_MAP.put(browser.getNickname(), browser);
        USER_AGENT_MAP.put(browser, userAgent);
    }

    public RunStyleHtmlUnit(JUnitShell shell) {
        super(shell);
    }

    @Override
    public Set<Platform> getPlatforms() {
        return PLATFORMS;
    }

    @Override
    public int initialize(String args) {
        if (args == null || args.length() == 0) {
            args = "FF38";
        }
        HashSet<BrowserVersion> browserSet = new HashSet<BrowserVersion>();
        HashSet<String> userAgentSet = new HashSet<String>();
        for (String browserName : args.split(",")) {
            BrowserVersion browser = BROWSER_MAP.get(browserName);
            if (browser == null) {
                this.getLogger().log(TreeLogger.ERROR, "RunStyleHtmlUnit: Unknown browser name " + browserName + ", expected browser name: one of " + BROWSER_MAP.keySet());
                return -1;
            }
            browserSet.add(browser);
            userAgentSet.add(USER_AGENT_MAP.get(browser));
        }
        this.browsers = Collections.unmodifiableSet(browserSet);
        this.setUserAgents(Collections.unmodifiableSet(userAgentSet));
        this.setTries(1);
        return this.browsers.size();
    }

    @Override
    public void launchModule(String moduleName) {
        for (BrowserVersion browser : this.browsers) {
            String url = this.shell.getModuleUrl(moduleName);
            HtmlUnitThread hut = this.createHtmlUnitThread(browser, url);
            TreeLogger logger = this.shell.getTopLogger();
            if (logger.isLoggable(TreeLogger.INFO)) {
                logger.log(TreeLogger.INFO, "Starting " + url + " on browser " + browser.getNickname());
            }
            hut.start();
            this.threads.add(hut);
        }
    }

    public int numBrowsers() {
        return this.browsers.size();
    }

    @Override
    public boolean setupMode(TreeLogger logger, boolean developmentMode) {
        this.developmentMode = developmentMode;
        return true;
    }

    protected HtmlUnitThread createHtmlUnitThread(BrowserVersion browser, String url) {
        return new HtmlUnitThread(browser, url, this.shell.getTopLogger().branch(TreeLogger.SPAM, "logging for HtmlUnit thread"), this.developmentMode);
    }

    static {
        RunStyleHtmlUnit.addBrowser(BrowserVersion.EDGE, "safari");
        RunStyleHtmlUnit.addBrowser(BrowserVersion.FIREFOX_38, "gecko1_8");
        RunStyleHtmlUnit.addBrowser(BrowserVersion.CHROME, "safari");
        RunStyleHtmlUnit.addBrowser(BrowserVersion.INTERNET_EXPLORER_11, "gecko1_8");
        PLATFORMS = ImmutableSet.of((Object)Platform.HtmlUnitBug, (Object)Platform.HtmlUnitLayout, (Object)Platform.HtmlUnitUnknown);
    }

    protected static class HtmlUnitThread
    extends Thread
    implements AlertHandler,
    IncorrectnessListener,
    OnbeforeunloadHandler {
        private final BrowserVersion browser;
        private final boolean developmentMode;
        private final TreeLogger treeLogger;
        private final String url;
        private Object waitForUnload = new Object();

        public HtmlUnitThread(BrowserVersion browser, String url, TreeLogger treeLogger, boolean developmentMode) {
            this.browser = browser;
            this.url = url;
            this.treeLogger = treeLogger;
            this.setName("htmlUnit client thread");
            this.developmentMode = developmentMode;
        }

        public void handleAlert(Page page, String message) {
            this.treeLogger.log(TreeLogger.ERROR, "Alert: " + message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleEvent(Page page, String returnValue) {
            Object object = this.waitForUnload;
            synchronized (object) {
                this.waitForUnload.notifyAll();
                return true;
            }
        }

        public void notify(String message, Object origin) {
            if (!"Obsolete content type encountered: 'text/javascript'.".equals(message) && !"Obsolete content type encountered: 'application/x-javascript'.".equals(message)) {
                this.treeLogger.log(TreeLogger.WARN, message);
            }
        }

        @Override
        public void run() {
            WebClient webClient = new WebClient(this.browser);
            webClient.setAlertHandler((AlertHandler)this);
            webClient.setIncorrectnessListener((IncorrectnessListener)this);
            webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
            webClient.getOptions().setThrowExceptionOnScriptError(this.developmentMode);
            webClient.setOnbeforeunloadHandler((OnbeforeunloadHandler)this);
            webClient.setJavaScriptErrorListener(new JavaScriptErrorListener(){

                public void loadScriptError(InteractivePage htmlPage, URL scriptUrl, Exception exception) {
                    treeLogger.log(TreeLogger.ERROR, "Load Script Error: " + exception, (Throwable)exception);
                }

                public void malformedScriptURL(InteractivePage htmlPage, String url, MalformedURLException malformedURLException) {
                    treeLogger.log(TreeLogger.ERROR, "Malformed Script URL: " + malformedURLException.getLocalizedMessage());
                }

                public void scriptException(InteractivePage htmlPage, ScriptException scriptException) {
                    treeLogger.log(TreeLogger.DEBUG, "Script Exception: " + scriptException.getLocalizedMessage() + ", line " + scriptException.getFailingLine());
                }

                public void timeoutError(InteractivePage htmlPage, long allowedTime, long executionTime) {
                    treeLogger.log(TreeLogger.ERROR, "Script Timeout Error " + executionTime + " > " + allowedTime);
                }
            });
            this.setupWebClient(webClient);
            try {
                Page page = webClient.getPage(this.url);
                webClient.waitForBackgroundJavaScriptStartingBefore(2000L);
                if (this.treeLogger.isLoggable(TreeLogger.SPAM)) {
                    this.treeLogger.log(TreeLogger.SPAM, "getPage returned " + ((HtmlPage)page).asXml());
                }
            }
            catch (FailingHttpStatusCodeException var3) {
                this.treeLogger.log(TreeLogger.ERROR, "HTTP request failed", (Throwable)var3);
            }
            catch (MalformedURLException var4) {
                this.treeLogger.log(TreeLogger.ERROR, "Bad URL", (Throwable)var4);
            }
            catch (IOException var5) {
                this.treeLogger.log(TreeLogger.ERROR, "I/O error on HTTP request", (Throwable)var5);
            }
        }

        protected void setupWebClient(WebClient webClient) {
            if (this.developmentMode) {
                HostedJavaScriptEngine hostedEngine = new HostedJavaScriptEngine(webClient, this.treeLogger);
                webClient.setJavaScriptEngine((JavaScriptEngine)hostedEngine);
            } else {
                WebJavaScriptEngine webEngine = new WebJavaScriptEngine(webClient);
                webClient.setJavaScriptEngine((JavaScriptEngine)webEngine);
            }
            if (System.getProperty("gwt.htmlunit.debug") != null) {
                WebClientUtils.attachVisualDebugger((WebClient)webClient);
            }
        }
    }

    private static class HostedJavaScriptEngine
    extends JavaScriptEngine {
        private static final long serialVersionUID = 3594816610842448691L;
        private final TreeLogger logger;

        public HostedJavaScriptEngine(WebClient webClient, TreeLogger logger) {
            super(webClient);
            this.logger = logger;
        }

        public void initialize(WebWindow webWindow) {
            super.initialize(webWindow);
            Window window = (Window)webWindow.getScriptableObject();
            window.defineProperty("__gwt_HostedModePlugin", (Object)new HostedModePluginObject((JavaScriptEngine)this, this.logger), 1);
        }
    }

    private static class WebJavaScriptEngine
    extends JavaScriptEngine {
        private static final Log LOG = LogFactory.getLog(JavaScriptEngine.class);

        public WebJavaScriptEngine(WebClient webClient) {
            super(webClient);
        }

        protected void handleJavaScriptException(ScriptException scriptException, boolean triggerOnError) {
            JavaScriptErrorListener javaScriptErrorListener;
            Window w;
            WebWindow window;
            InteractivePage page = scriptException.getPage();
            if (triggerOnError && page != null && (window = page.getEnclosingWindow()) != null && (w = (Window)window.getScriptableObject()) != null) {
                try {
                    this.triggerOnError(w, scriptException);
                }
                catch (Exception var7) {
                    this.handleJavaScriptException(new ScriptException(page, (Throwable)var7, (String)null), false);
                }
            }
            if ((javaScriptErrorListener = this.getWebClient().getJavaScriptErrorListener()) != null) {
                javaScriptErrorListener.scriptException(page, scriptException);
            }
            if (this.getWebClient().getOptions().isThrowExceptionOnScriptError()) {
                throw scriptException;
            }
            LOG.info((Object)"Caught script exception", (Throwable)scriptException);
        }

        private void triggerOnError(Window w, ScriptException e) {
            Object o = w.getOnerror();
            if (o instanceof Function) {
                Function f = (Function)o;
                String msg = e.getMessage();
                String url = e.getPage().getUrl().toExternalForm();
                int line = e.getFailingLineNumber();
                Object[] args = new Object[]{msg, url, line};
                f.call(Context.getCurrentContext(), (Scriptable)w, (Scriptable)w, args);
            }
        }
    }
}

