/*
 * Decompiled with CFR 0.152.
 */
package gwt.material.design.client.data;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import gwt.material.design.client.base.MaterialWidget;
import gwt.material.design.client.constants.IconSize;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.data.AbstractDataView;
import gwt.material.design.client.data.BaseRenderer;
import gwt.material.design.client.data.DataView;
import gwt.material.design.client.data.Renderer;
import gwt.material.design.client.data.SelectionType;
import gwt.material.design.client.data.SortContext;
import gwt.material.design.client.data.SortDir;
import gwt.material.design.client.data.component.CategoryComponent;
import gwt.material.design.client.data.component.Component;
import gwt.material.design.client.data.component.Components;
import gwt.material.design.client.data.component.RowComponent;
import gwt.material.design.client.data.events.RowSelectEvent;
import gwt.material.design.client.model.Person;
import gwt.material.design.client.renderer.CustomRenderer;
import gwt.material.design.client.ui.table.DataTableTestCase;
import gwt.material.design.client.ui.table.MaterialDataTable;
import gwt.material.design.client.ui.table.SortHelper;
import gwt.material.design.client.ui.table.TableData;
import gwt.material.design.client.ui.table.TableHeader;
import gwt.material.design.client.ui.table.TableRow;
import gwt.material.design.client.ui.table.TableSubHeader;
import gwt.material.design.client.ui.table.cell.Column;
import gwt.material.design.client.ui.table.cell.TextColumn;
import gwt.material.design.jquery.client.api.Event;
import gwt.material.design.jquery.client.api.JQuery;
import gwt.material.design.jquery.client.api.JQueryElement;
import gwt.material.design.jquery.client.api.KeyEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AbstractDataViewTest<T extends MaterialDataTable<Person>>
extends DataTableTestCase<T> {
    private static final Logger logger = Logger.getLogger(AbstractDataViewTest.class.getName());

    public void testSetup() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        table.setSelectionType(SelectionType.SINGLE);
        table.setUseRowExpansion(true);
        boolean[] setup = new boolean[]{false};
        table.addSetupHandler(event -> {
            setup[0] = true;
        });
        RootPanel.get().add((Widget)table);
        AbstractDataViewTest.assertTrue((boolean)setup[0]);
        AbstractDataViewTest.assertTrue((boolean)dataView.isSetup());
        AbstractDataViewTest.assertNotNull((Object)dataView.table);
        AbstractDataViewTest.assertNotNull((Object)dataView.getContainer());
        AbstractDataViewTest.assertNotNull((Object)dataView.tbody);
        AbstractDataViewTest.assertNotNull((Object)dataView.thead);
        AbstractDataViewTest.assertNotNull((Object)dataView.headerRow);
        AbstractDataViewTest.assertNotNull((Object)dataView.progressWidget);
        AbstractDataViewTest.assertValidJQueryElement(dataView.container);
        AbstractDataViewTest.assertValidJQueryElement(dataView.tableBody);
        AbstractDataViewTest.assertValidJQueryElement(dataView.topPanel);
        AbstractDataViewTest.assertValidJQueryElement((JQueryElement)dataView.$table);
        AbstractDataViewTest.assertEquals((int)2, (int)dataView.getHeaders().size());
    }

    public void testSetupPendingRows() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        table.setRowData(0, people);
        table.addRenderedHandler(e -> AbstractDataViewTest.assertFalse((boolean)dataView.isRendering()));
        RootPanel.get().add((Widget)table);
        this.checkRowComponents(table, people.size());
    }

    public void testDestroy() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor(false);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        boolean[] destroyed = new boolean[]{false};
        table.addDestroyHandler(event -> {
            destroyed[0] = true;
        });
        dataView.destroy();
        AbstractDataViewTest.assertTrue((boolean)destroyed[0]);
        AbstractDataViewTest.assertTrue((boolean)dataView.getRows().isEmpty());
        AbstractDataViewTest.assertTrue((boolean)dataView.getCategories().isEmpty());
        AbstractDataViewTest.assertTrue((boolean)dataView.getColumns().isEmpty());
        AbstractDataViewTest.assertTrue((boolean)dataView.getHeaders().isEmpty());
        AbstractDataViewTest.assertTrue((dataView.headerRow.getWidgetCount() < 1 ? 1 : 0) != 0);
        AbstractDataViewTest.assertFalse((boolean)dataView.isRendering());
        AbstractDataViewTest.assertFalse((boolean)dataView.isSetup());
    }

    public void testRenderRowComponents() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor(false);
        DataView dataView = table.getView();
        Components<Component<?>> components = this.generateRowComponents((DataView<Person>)dataView);
        table.addComponentsRenderedHandler(event -> this.checkNonIndexRowComponents(table, people.size()));
        dataView.render(components);
        AbstractDataViewTest.assertFalse((boolean)dataView.isRedraw());
    }

    public void testRenderCategoryComponents() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor(false);
        table.setUseCategories(true);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        table.addComponentsRenderedHandler(event -> {
            AbstractDataViewTest.assertFalse((boolean)dataView.isRendering());
            AbstractDataViewTest.assertEquals((int)0, (int)dataView.getRowCount());
            AbstractDataViewTest.assertEquals((int)0, (int)dataView.getVisibleItemCount());
            AbstractDataViewTest.assertEquals((int)2, (int)dataView.tbody.getWidgetCount());
        });
        for (CategoryComponent component : this.generateCategoryComponents((AbstractDataView<Person>)dataView)) {
            dataView.addCategory(component);
        }
        AbstractDataViewTest.assertFalse((boolean)dataView.isRedraw());
    }

    public void testSetRowData() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor(false);
        DataView dataView = table.getView();
        HandlerRegistration[] registration = new HandlerRegistration[]{null};
        registration[0] = table.addRenderedHandler(event -> {
            if (registration[0] != null) {
                this.checkRowComponents(table, people.size());
                registration[0].removeHandler();
                registration[0] = null;
                table.addRenderedHandler(event1 -> this.checkRowComponents(table, 9));
                table.setRowData(3, people);
            }
        });
        table.setRowData(0, people);
        AbstractDataViewTest.assertFalse((boolean)dataView.isRedraw());
        AbstractDataViewTest.assertFalse((boolean)dataView.isRendering());
    }

    public void testRenderColumn() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setSelectionType(SelectionType.NONE);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        RootPanel.get().add((Widget)table);
        TextColumn<Person> column = new TextColumn<Person>(){

            public String getValue(Person object) {
                return object.getFirstName();
            }
        };
        dataView.getColumns().add(column);
        dataView.renderColumn((Column)column);
        List header = dataView.getHeaders();
        AbstractDataViewTest.assertTrue((!header.isEmpty() ? 1 : 0) != 0);
    }

    public void testRenderColumnWithRows() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setSelectionType(SelectionType.NONE);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        RootPanel.get().add((Widget)table);
        table.setRowData(0, people);
        TextColumn<Person> column = new TextColumn<Person>(){

            public String getValue(Person object) {
                return object.getFirstName();
            }
        };
        dataView.getColumns().add(column);
        dataView.renderColumn((Column)column);
        List header = dataView.getHeaders();
        AbstractDataViewTest.assertTrue((!header.isEmpty() ? 1 : 0) != 0);
        try {
            for (RowComponent rowComponent : dataView.getRows()) {
                AbstractDataViewTest.assertTrue((boolean)((TableRow)rowComponent.getWidget()).getColumn(0).isAttached());
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException ex) {
            throw new AssertionError("Problem adding row column to rows.", ex);
        }
    }

    public void testRemoveColumnByIndex() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        DataView dataView = table.getView();
        Column column = (Column)dataView.getColumns().get(0);
        dataView.removeColumn(0);
        AbstractDataViewTest.assertFalse((boolean)dataView.getColumns().contains(column));
    }

    public void testRemoveAllColumns() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        DataView dataView = table.getView();
        dataView.removeColumns();
        AbstractDataViewTest.assertTrue((boolean)dataView.getColumns().isEmpty());
    }

    public void testUpdateSortContext() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        Column column = (Column)dataView.getColumns().get(1);
        TableHeader th = (TableHeader)dataView.getHeaders().get(1);
        dataView.updateSortContext(th, column);
        SortContext sortContext = dataView.getSortContext();
        AbstractDataViewTest.assertNotNull((Object)sortContext);
        AbstractDataViewTest.assertEquals((Object)column, (Object)sortContext.getSortColumn());
        AbstractDataViewTest.assertEquals((Object)th, (Object)sortContext.getTableHeader());
        AbstractDataViewTest.assertEquals((Object)SortDir.ASC, (Object)sortContext.getSortDir());
    }

    public void testUpdateSortContextOnAutoSortColumn() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        Column column = (Column)dataView.getColumns().get(0);
        TableHeader th = (TableHeader)dataView.getHeaders().get(0);
        dataView.updateSortContext(th, column);
        SortContext sortContext = dataView.getSortContext();
        AbstractDataViewTest.assertNotNull((Object)sortContext);
        AbstractDataViewTest.assertEquals((Object)column, (Object)sortContext.getSortColumn());
        AbstractDataViewTest.assertEquals((Object)th, (Object)sortContext.getTableHeader());
        AbstractDataViewTest.assertEquals((Object)SortDir.DESC, (Object)sortContext.getSortDir());
    }

    public void testUpdateSortContextWithDir() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        Column column = (Column)dataView.getColumns().get(0);
        TableHeader th = (TableHeader)dataView.getHeaders().get(0);
        dataView.updateSortContext(th, column, SortDir.DESC);
        SortContext sortContext = dataView.getSortContext();
        AbstractDataViewTest.assertNotNull((Object)sortContext);
        AbstractDataViewTest.assertEquals((Object)column, (Object)sortContext.getSortColumn());
        AbstractDataViewTest.assertEquals((Object)th, (Object)sortContext.getTableHeader());
        AbstractDataViewTest.assertEquals((Object)SortDir.DESC, (Object)sortContext.getSortDir());
    }

    public void testSortColumnByIndex() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        DataView dataView = table.getView();
        Components beforeRows = new Components((Collection)dataView.getRows(), RowComponent::new);
        boolean[] sorted = new boolean[]{false};
        table.addColumnSortHandler(event -> {
            sorted[0] = true;
        });
        table.sort(1, SortDir.DESC);
        SortContext sortContext = dataView.getSortContext();
        AbstractDataViewTest.assertTrue((boolean)sorted[0]);
        sorted[0] = false;
        AbstractDataViewTest.assertEquals((Object)SortDir.DESC, (Object)sortContext.getSortDir());
        Components descRows = new Components((Collection)dataView.getRows(), RowComponent::new);
        table.sort(1, SortDir.ASC);
        sortContext = dataView.getSortContext();
        AbstractDataViewTest.assertTrue((boolean)sorted[0]);
        AbstractDataViewTest.assertEquals((Object)SortDir.ASC, (Object)sortContext.getSortDir());
        Components ascRows = new Components((Collection)dataView.getRows(), RowComponent::new);
        AbstractDataViewTest.assertTrue((boolean)SortHelper.isNotSame((List<RowComponent<Person>>)beforeRows, (List<RowComponent<Person>>)descRows));
        AbstractDataViewTest.assertTrue((boolean)SortHelper.isNotSame((List<RowComponent<Person>>)descRows, (List<RowComponent<Person>>)ascRows));
    }

    public void testSortColumnByColumn() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        DataView dataView = table.getView();
        Components beforeRows = new Components((Collection)dataView.getRows(), RowComponent::new);
        boolean[] sorted = new boolean[]{false};
        table.addColumnSortHandler(event -> {
            sorted[0] = true;
        });
        Column column = (Column)table.getColumns().get(0);
        table.sort(column, SortDir.DESC);
        SortContext sortContext = dataView.getSortContext();
        AbstractDataViewTest.assertTrue((boolean)sorted[0]);
        sorted[0] = false;
        AbstractDataViewTest.assertEquals((Object)SortDir.DESC, (Object)sortContext.getSortDir());
        Components descRows = new Components((Collection)dataView.getRows(), RowComponent::new);
        table.sort(column, SortDir.ASC);
        sortContext = dataView.getSortContext();
        AbstractDataViewTest.assertTrue((boolean)sorted[0]);
        AbstractDataViewTest.assertEquals((Object)SortDir.ASC, (Object)sortContext.getSortDir());
        Components ascRows = new Components((Collection)dataView.getRows(), RowComponent::new);
        AbstractDataViewTest.assertTrue((boolean)SortHelper.isNotSame((List<RowComponent<Person>>)beforeRows, (List<RowComponent<Person>>)descRows));
        AbstractDataViewTest.assertTrue((boolean)SortHelper.isNotSame((List<RowComponent<Person>>)descRows, (List<RowComponent<Person>>)ascRows));
    }

    public void testAutoSortColumnBeforeAttached() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        DataView dataView = table.getView();
        this.addSampleColumns(table);
        table.setRowData(0, people);
        table.addRenderedHandler(event -> this.checkColumnSort((DataView<Person>)dataView, 0));
        RootPanel.get().add((Widget)table);
        AbstractDataViewTest.assertFalse((boolean)dataView.isRedraw());
        AbstractDataViewTest.assertFalse((boolean)dataView.isRendering());
    }

    public void testAutoSortColumnAfterAttached() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        DataView dataView = table.getView();
        this.addSampleColumns(table);
        RootPanel.get().add((Widget)table);
        table.addRenderedHandler(event -> this.checkColumnSort((DataView<Person>)dataView, 0));
        table.setRowData(0, people);
        AbstractDataViewTest.assertFalse((boolean)dataView.isRedraw());
        AbstractDataViewTest.assertFalse((boolean)dataView.isRendering());
    }

    public void testSetRendererBeforeAttached() {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        BaseRenderer renderer = new BaseRenderer();
        dataView.setRenderer((Renderer)renderer);
        RootPanel.get().add((Widget)table);
        AbstractDataViewTest.assertEquals((Object)renderer, (Object)dataView.getRenderer());
    }

    public void testSetRendererAfterAttached() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        BaseRenderer renderer = new BaseRenderer();
        dataView.setRenderer((Renderer)renderer);
        AbstractDataViewTest.assertEquals((Object)renderer, (Object)dataView.getRenderer());
    }

    public void testSetRendererCopyProperties() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        Renderer oldRenderer = dataView.getRenderer();
        BaseRenderer renderer = new BaseRenderer();
        oldRenderer.setExpectedRowHeight(80);
        oldRenderer.setSortAscIcon(IconType.FULLSCREEN);
        oldRenderer.setSortDescIcon(IconType.KEYBOARD);
        oldRenderer.setSortIconSize(IconSize.LARGE);
        dataView.setRenderer((Renderer)renderer);
        AbstractDataViewTest.assertEquals((Object)renderer, (Object)dataView.getRenderer());
        AbstractDataViewTest.assertEquals((int)renderer.getExpectedRowHeight(), (int)oldRenderer.getExpectedRowHeight());
        AbstractDataViewTest.assertEquals((int)renderer.getCalculatedRowHeight(), (int)oldRenderer.getCalculatedRowHeight());
        AbstractDataViewTest.assertNotSame((Object)renderer.getSortIconSize(), (Object)oldRenderer.getSortIconSize());
        AbstractDataViewTest.assertNotSame((Object)renderer.getSortAscIcon(), (Object)oldRenderer.getSortAscIcon());
        AbstractDataViewTest.assertNotSame((Object)renderer.getSortDescIcon(), (Object)oldRenderer.getSortDescIcon());
    }

    public void testColumnOffset() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        table.setSelectionType(SelectionType.SINGLE);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        int colOffset = dataView.getColumnOffset();
        AbstractDataViewTest.assertEquals((int)1, (int)colOffset);
    }

    public void testSetSelectionTypeSingleAfterAttached() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        table.setSelectionType(SelectionType.SINGLE);
        AbstractDataViewTest.assertEquals((Object)SelectionType.SINGLE, (Object)dataView.getSelectionType());
        TableHeader th = (TableHeader)dataView.getHeaders().get(0);
        this.checkSelectionRow(dataView.getRows());
    }

    public void testSetSelectionTypeMultipleAfterAttached() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        table.setSelectionType(SelectionType.MULTIPLE);
        AbstractDataViewTest.assertEquals((Object)SelectionType.MULTIPLE, (Object)dataView.getSelectionType());
        TableHeader th = (TableHeader)dataView.getHeaders().get(0);
        AbstractDataViewTest.assertTrue((boolean)th.getStyleName().contains("selection"));
        this.checkSelectionRow(dataView.getRows());
    }

    public void testSetSelectionTypeNoneAfterAttached() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setSelectionType(SelectionType.SINGLE);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        this.addSampleColumns(table);
        table.setRowData(0, people);
        RootPanel.get().add((Widget)table);
        int colMod = dataView.getColumnOffset();
        int totalColumns = dataView.getColumns().size() + colMod;
        table.setSelectionType(SelectionType.NONE);
        AbstractDataViewTest.assertEquals((Object)SelectionType.NONE, (Object)dataView.getSelectionType());
        TableHeader th = (TableHeader)dataView.getHeaders().get(0);
        AbstractDataViewTest.assertFalse((boolean)th.getStyleName().contains("selection"));
        for (RowComponent row : dataView.getRows()) {
            TableRow tableRow = (TableRow)row.getWidget();
            int count = tableRow.getWidgetCount();
            AbstractDataViewTest.assertEquals((int)totalColumns, (int)count);
            for (int i = 0; i < count; ++i) {
                TableData td = tableRow.getColumn(i);
                AbstractDataViewTest.assertEquals((String)("col" + i), (String)td.getId());
            }
        }
        for (int i = 0; i < dataView.headerRow.getWidgetCount(); ++i) {
            TableData td = dataView.headerRow.getColumn(i);
            AbstractDataViewTest.assertEquals((String)("col" + i), (String)td.getId());
        }
    }

    public void testCustomRenderer() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setRenderer(new CustomRenderer());
        AbstractDataView dataView = (AbstractDataView)table.getView();
        RootPanel.get().add((Widget)table);
        for (RowComponent row : dataView.getRows()) {
            try {
                TableData td = (TableData)((TableRow)row.getWidget()).getWidget(0);
                AbstractDataViewTest.assertTrue((boolean)td.getId().equals("col0"));
                AbstractDataViewTest.assertEquals((String)"filled-in", (String)td.getElement().getAttribute("class"));
            }
            catch (ClassCastException | IndexOutOfBoundsException ex) {
                throw new AssertionError("Issue testing selection column.", ex);
            }
        }
    }

    public void testShiftDetection() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        table.setSelectionType(SelectionType.MULTIPLE);
        AbstractDataViewTest.assertEquals((Object)"0", (Object)dataView.tableBody.attr("tabindex"));
        KeyEvent keyEvent = new KeyEvent("keydown");
        keyEvent.shiftKey = true;
        dataView.tableBody.trigger((Event)keyEvent, new Object[0]);
        AbstractDataViewTest.assertTrue((boolean)dataView.isShiftDown());
        keyEvent = new KeyEvent("keydown");
        keyEvent.shiftKey = false;
        dataView.tableBody.trigger((Event)keyEvent, new Object[0]);
        AbstractDataViewTest.assertFalse((boolean)dataView.isShiftDown());
    }

    public void testSelectAllRows() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        table.setSelectionType(SelectionType.MULTIPLE);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        int rowCount = table.getRowCount();
        boolean[] selectAll = new boolean[]{false};
        table.addSelectAllHandler(event -> {
            selectAll[0] = true;
            AbstractDataViewTest.assertEquals((int)rowCount, (int)event.getModels().size());
            AbstractDataViewTest.assertEquals((int)rowCount, (int)event.getRows().size());
            AbstractDataViewTest.assertTrue((boolean)event.isSelected());
        });
        dataView.selectAllRows(true);
        AbstractDataViewTest.assertTrue((boolean)selectAll[0]);
        dataView.$table.find("tr.data-row").each((i, e) -> {
            JQueryElement row = JQuery.$((Element)e);
            JQueryElement input = JQuery.$((String)"td#col0 input", (JQueryElement)row);
            AbstractDataViewTest.assertTrue((boolean)((Boolean)input.prop("checked")));
            AbstractDataViewTest.assertTrue((boolean)row.hasClass("selected"));
        });
    }

    public void testDeselectAllRows() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        table.setSelectionType(SelectionType.MULTIPLE);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        dataView.selectAllRows(true, false);
        int rowCount = table.getRowCount();
        boolean[] deselectAll = new boolean[]{false};
        table.addSelectAllHandler(event -> {
            deselectAll[0] = true;
            AbstractDataViewTest.assertEquals((int)rowCount, (int)event.getModels().size());
            AbstractDataViewTest.assertEquals((int)rowCount, (int)event.getRows().size());
            AbstractDataViewTest.assertFalse((boolean)event.isSelected());
        });
        dataView.selectAllRows(false);
        AbstractDataViewTest.assertTrue((boolean)deselectAll[0]);
        dataView.$table.find("tr.data-row").each((i, e) -> {
            JQueryElement row = JQuery.$((Element)e);
            JQueryElement input = JQuery.$((String)"td#col0 input", (JQueryElement)row);
            Boolean checked = (Boolean)input.prop("checked");
            if (checked != null) {
                AbstractDataViewTest.assertFalse((boolean)checked);
            }
            AbstractDataViewTest.assertFalse((boolean)row.hasClass("selected"));
        });
    }

    public void testSelectRow() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        table.setSelectionType(SelectionType.SINGLE);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        RowComponent rowComponent = table.getRow(3);
        com.google.gwt.user.client.Element element = ((TableRow)rowComponent.getWidget()).getElement();
        boolean[] rowSelect = new boolean[]{false};
        table.addRowSelectHandler(arg_0 -> AbstractDataViewTest.lambda$testSelectRow$15(rowSelect, rowComponent, (Element)element, arg_0));
        dataView.selectRow((Element)element, true);
        AbstractDataViewTest.assertTrue((boolean)rowSelect[0]);
        AbstractDataViewTest.assertTrue((boolean)element.getClassName().contains("selected"));
        Boolean checked = (Boolean)JQuery.$((String)"td#col0 input", (Element)element).prop("checked");
        AbstractDataViewTest.assertNotNull((Object)checked);
        AbstractDataViewTest.assertTrue((boolean)checked);
    }

    public void testDeselectRow() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        RowComponent rowComponent = table.getRow(3);
        com.google.gwt.user.client.Element element = ((TableRow)rowComponent.getWidget()).getElement();
        dataView.selectRow((Element)element, false);
        boolean[] rowDeselect = new boolean[]{false};
        table.addRowSelectHandler(arg_0 -> AbstractDataViewTest.lambda$testDeselectRow$16(rowDeselect, rowComponent, (Element)element, arg_0));
        dataView.deselectRow((Element)element, true);
        AbstractDataViewTest.assertTrue((boolean)rowDeselect[0]);
        AbstractDataViewTest.assertFalse((boolean)element.getClassName().contains("selected"));
        String checked = (String)JQuery.$((String)"td#col0 input", (Element)element).prop("checked");
        if (checked != null) {
            AbstractDataViewTest.assertEquals((String)"false", (String)checked);
        }
    }

    public void testHasSelectedRows() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        table.setSelectionType(SelectionType.SINGLE);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        RowComponent rowComponent = table.getRow(3);
        com.google.gwt.user.client.Element element = ((TableRow)rowComponent.getWidget()).getElement();
        AbstractDataViewTest.assertFalse((boolean)dataView.hasSelectedRows(true));
        dataView.selectRow((Element)element, false);
        boolean hasSelectedRows = dataView.hasSelectedRows(true);
        AbstractDataViewTest.assertTrue((boolean)hasSelectedRows);
    }

    public void testHasDeselectedRows() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        table.setSelectionType(SelectionType.SINGLE);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        RowComponent rowComponent = table.getRow(3);
        com.google.gwt.user.client.Element element = ((TableRow)rowComponent.getWidget()).getElement();
        dataView.selectRow((Element)element, false);
        boolean hasDeselectedRows = dataView.hasDeselectedRows(true);
        dataView.selectAllRows(true);
        AbstractDataViewTest.assertTrue((boolean)hasDeselectedRows);
        AbstractDataViewTest.assertFalse((boolean)dataView.hasDeselectedRows(true));
    }

    public void testAddCategory() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setUseCategories(true);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        this.addSampleColumns(table);
        RootPanel.get().add((Widget)table);
        String categoryName = "Test Category";
        AbstractDataViewTest.assertFalse((boolean)dataView.hasCategory(categoryName));
        dataView.addCategory(categoryName);
        AbstractDataViewTest.assertTrue((boolean)dataView.hasCategory(categoryName));
        CategoryComponent category = dataView.getCategory(categoryName);
        AbstractDataViewTest.assertNotNull((Object)category);
        AbstractDataViewTest.assertTrue((boolean)category.isRendered());
        AbstractDataViewTest.assertTrue((boolean)category.getWidget().isAttached());
    }

    public void testAddCategoryBeforeAttached() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setUseCategories(true);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        this.addSampleColumns(table);
        String categoryName = "Test Category";
        dataView.addCategory(categoryName);
        RootPanel.get().add((Widget)table);
        AbstractDataViewTest.assertTrue((boolean)dataView.hasCategory(categoryName));
        CategoryComponent category = dataView.getCategory(categoryName);
        AbstractDataViewTest.assertNotNull((Object)category);
        AbstractDataViewTest.assertTrue((boolean)category.isRendered());
        AbstractDataViewTest.assertTrue((boolean)category.getWidget().isAttached());
    }

    public void testDisableCategory() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setUseCategories(true);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        this.addSampleColumns(table);
        String categoryName = "Test Category";
        dataView.addCategory(categoryName);
        RootPanel.get().add((Widget)table);
        CategoryComponent category = dataView.getCategory(categoryName);
        dataView.disableCategory(categoryName);
        AbstractDataViewTest.assertFalse((boolean)((TableSubHeader)category.getWidget()).isEnabled());
    }

    public void testEnableCategory() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setUseCategories(true);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        this.addSampleColumns(table);
        String categoryName = "Test Category";
        dataView.addCategory(categoryName);
        RootPanel.get().add((Widget)table);
        CategoryComponent category = dataView.getCategory(categoryName);
        dataView.disableCategory(categoryName);
        AbstractDataViewTest.assertFalse((boolean)((TableSubHeader)category.getWidget()).isEnabled());
        dataView.enableCategory(categoryName);
        AbstractDataViewTest.assertTrue((boolean)((TableSubHeader)category.getWidget()).isEnabled());
    }

    public void testUpdateRow() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        AbstractDataView dataView = (AbstractDataView)table.getView();
        dataView.setRowData(0, people);
        RowComponent row = dataView.getRow(3);
        int index = row.getIndex();
        Person person = (Person)row.getData();
        person.setFirstName("Updated First Name");
        person.setLastName("Updated Last Name");
        dataView.updateRow((Object)person);
        row = dataView.getRow(3);
        AbstractDataViewTest.assertEquals((int)index, (int)row.getIndex());
        AbstractDataViewTest.assertEquals((String)person.getFirstName(), (String)((Person)row.getData()).getFirstName());
        AbstractDataViewTest.assertEquals((String)person.getLastName(), (String)((Person)row.getData()).getLastName());
        AbstractDataViewTest.assertEquals((String)person.getFirstName(), (String)((MaterialWidget)((TableRow)row.getWidget()).getWidget(0)).getWidget(0).getElement().getInnerText());
        AbstractDataViewTest.assertEquals((String)person.getLastName(), (String)((MaterialWidget)((TableRow)row.getWidget()).getWidget(1)).getWidget(0).getElement().getInnerText());
    }

    public Components<Component<?>> generateRowComponents(DataView<Person> dataView) {
        Components components = new Components();
        for (Person person : people) {
            components.add((Component)new RowComponent((Object)person, dataView, person.getDataCategory()));
        }
        return components;
    }

    public Components<CategoryComponent<T>> generateCategoryComponents(AbstractDataView<Person> dataView) {
        Components components = new Components();
        for (Person person : people) {
            CategoryComponent category = (CategoryComponent)dataView.getCategoryFactory().generate(dataView, (Object)person.getDataCategory());
            if (components.contains((Object)category)) continue;
            components.add((Component)category);
        }
        return components;
    }

    public void checkRowComponents(T table, int size) {
        AbstractDataView dataView = (AbstractDataView)table.getView();
        AbstractDataViewTest.assertFalse((boolean)dataView.isRendering());
        AbstractDataViewTest.assertEquals((int)size, (int)dataView.getRowCount());
        AbstractDataViewTest.assertEquals((int)size, (int)dataView.getVisibleItemCount());
        AbstractDataViewTest.assertEquals((int)size, (int)dataView.tbody.$this().find("tr").length());
        int index = 0;
        for (RowComponent rowComponent : dataView.getRows()) {
            AbstractDataViewTest.assertTrue((boolean)((TableRow)rowComponent.getWidget()).isVisible());
            AbstractDataViewTest.assertEquals((int)index, (int)rowComponent.getIndex());
            ++index;
        }
    }

    public void checkNonIndexRowComponents(T table, int size) {
        AbstractDataView dataView = (AbstractDataView)table.getView();
        AbstractDataViewTest.assertFalse((boolean)dataView.isRendering());
        AbstractDataViewTest.assertEquals((int)size, (int)dataView.getRowCount());
        AbstractDataViewTest.assertEquals((int)size, (int)dataView.getVisibleItemCount());
        AbstractDataViewTest.assertEquals((int)size, (int)dataView.tbody.$this().find("tr").length());
        for (RowComponent rowComponent : dataView.getRows()) {
            AbstractDataViewTest.assertTrue((boolean)((TableRow)rowComponent.getWidget()).isVisible());
        }
    }

    public void checkSelectionRow(List<RowComponent<Person>> rows) {
        for (RowComponent<Person> row : rows) {
            try {
                TableData td = (TableData)((TableRow)row.getWidget()).getWidget(0);
                AbstractDataViewTest.assertTrue((boolean)td.getId().equals("col0"));
                AbstractDataViewTest.assertTrue((boolean)td.getElement().hasClassName("selection"));
            }
            catch (ClassCastException | IndexOutOfBoundsException ex) {
                throw new AssertionError("Issue testing selection column.", ex);
            }
        }
    }

    public void checkColumnSort(DataView<Person> dataView, int index) {
        TableHeader th = (TableHeader)dataView.getHeaders().get(index);
        SortContext sortContext = dataView.getSortContext();
        AbstractDataViewTest.assertNotNull((Object)sortContext);
        AbstractDataViewTest.assertEquals((Object)SortDir.ASC, (Object)sortContext.getSortDir());
        AbstractDataViewTest.assertEquals((Object)th, (Object)sortContext.getTableHeader());
    }

    public Map<Column<Person, ?>, Integer> getColumnIndexes(List<Column<Person, ?>> columns) {
        HashMap indexes = new HashMap();
        int i = 0;
        for (Column<Person, ?> column : columns) {
            indexes.put(column, i++);
        }
        return indexes;
    }

    private static /* synthetic */ void lambda$testDeselectRow$16(boolean[] rowDeselect, RowComponent rowComponent, Element element, RowSelectEvent event) {
        rowDeselect[0] = true;
        AbstractDataViewTest.assertEquals((Object)rowComponent.getData(), (Object)event.getModel());
        AbstractDataViewTest.assertEquals((Object)element, (Object)event.getRow());
        AbstractDataViewTest.assertFalse((boolean)event.isSelected());
    }

    private static /* synthetic */ void lambda$testSelectRow$15(boolean[] rowSelect, RowComponent rowComponent, Element element, RowSelectEvent event) {
        rowSelect[0] = true;
        AbstractDataViewTest.assertEquals((Object)rowComponent.getData(), (Object)event.getModel());
        AbstractDataViewTest.assertEquals((Object)element, (Object)event.getRow());
        AbstractDataViewTest.assertTrue((boolean)event.isSelected());
    }
}

