/*
 * Decompiled with CFR 0.152.
 */
package gwt.material.design.client.data;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Style;
import gwt.material.design.client.base.constants.StyleName;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.constants.WavesType;
import gwt.material.design.client.data.AbstractDataView;
import gwt.material.design.client.data.BaseRenderer;
import gwt.material.design.client.data.ColumnContext;
import gwt.material.design.client.data.DataView;
import gwt.material.design.client.data.Renderer;
import gwt.material.design.client.data.SelectionType;
import gwt.material.design.client.data.component.CategoryComponent;
import gwt.material.design.client.data.component.RowComponent;
import gwt.material.design.client.model.Person;
import gwt.material.design.client.ui.MaterialBadge;
import gwt.material.design.client.ui.MaterialIcon;
import gwt.material.design.client.ui.html.Div;
import gwt.material.design.client.ui.table.DataTableTestCase;
import gwt.material.design.client.ui.table.MaterialDataTable;
import gwt.material.design.client.ui.table.TableData;
import gwt.material.design.client.ui.table.TableHeader;
import gwt.material.design.client.ui.table.TableRow;
import gwt.material.design.client.ui.table.TableSubHeader;
import gwt.material.design.client.ui.table.cell.Column;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class BaseRendererTest
extends DataTableTestCase<MaterialDataTable<Person>> {
    private static final Logger logger = Logger.getLogger(BaseRendererTest.class.getName());

    public void testDrawRow() throws Exception {
        BaseRenderer renderer = new BaseRenderer();
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setUseRowExpansion(true);
        this.addSampleColumns(table);
        table.setSelectionType(SelectionType.SINGLE);
        table.setRenderer((Renderer)renderer);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        List columns = dataView.getColumns();
        Person person = new Person(1, "John", "Doe", "123456", "Catergory");
        RowComponent rowComponent = dataView.getRowFactory().generate((DataView)dataView, (Object)person);
        TableRow tableRow = renderer.drawRow((DataView)dataView, rowComponent, dataView.getValueKey((Object)person), columns, true);
        BaseRendererTest.assertNotNull((String)"TableRow should not be null.", (Object)tableRow);
        Style style = tableRow.getElement().getStyle();
        BaseRendererTest.assertEquals((String)Style.Display.NONE.getCssName(), (String)style.getDisplay());
        BaseRendererTest.assertEquals((String)(renderer.getExpectedRowHeight() + "px"), (String)style.getProperty("height"));
        BaseRendererTest.assertEquals((String)(renderer.getExpectedRowHeight() + "px"), (String)style.getProperty("maxHeight"));
        BaseRendererTest.assertEquals((String)(renderer.getExpectedRowHeight() + "px"), (String)style.getProperty("minHeight"));
        BaseRendererTest.assertTrue((boolean)tableRow.getStyleName().contains("data-row"));
        BaseRendererTest.assertEquals((String)"RowComponent widget is not the rendered TableRow", (Object)tableRow, (Object)rowComponent.getWidget());
        try {
            TableData selectionCell = (TableData)tableRow.getWidget(0);
            BaseRendererTest.assertEquals((String)"col0", (String)selectionCell.getId());
            BaseRendererTest.assertTrue((boolean)selectionCell.getStyleName().contains("selection"));
        }
        catch (ClassCastException ex) {
            throw new AssertionError((Object)"Could not cast selection cell to TableData");
        }
        int colOffset = dataView.getColumnOffset();
        BaseRendererTest.assertEquals((int)(4 + colOffset), (int)tableRow.getWidgetCount());
        BaseRendererTest.assertTrue((boolean)tableRow.hasExpansionColumn());
        TableData expandRow = tableRow.getExpansionColumn();
        BaseRendererTest.assertEquals((String)"colex", (String)expandRow.getId());
        MaterialIcon expandIcon = (MaterialIcon)expandRow.getWidget(0);
        BaseRendererTest.assertEquals((String)"expand", (String)expandIcon.getId());
        BaseRendererTest.assertEquals((String)"100%", (String)expandIcon.getElement().getStyle().getWidth());
        BaseRendererTest.assertEquals((Object)IconType.KEYBOARD_ARROW_DOWN, (Object)expandIcon.getIconType());
        BaseRendererTest.assertEquals((Object)WavesType.LIGHT, (Object)expandIcon.getWaves());
        BaseRendererTest.assertEquals((String)Style.Cursor.POINTER.getCssName(), (String)expandIcon.getElement().getStyle().getCursor());
    }

    public void testDrawColumn() throws Exception {
        Div wrapper;
        BaseRenderer renderer = new BaseRenderer();
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        this.addSampleColumns(table);
        table.setSelectionType(SelectionType.SINGLE);
        table.setRenderer((Renderer)renderer);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        List columns = dataView.getColumns();
        Person person = new Person(1, "John", "Doe", "123456", "Catergory");
        TableRow row = new TableRow();
        ColumnContext columnText = renderer.drawColumn(row, new Cell.Context(1, 0, dataView.getValueKey((Object)person)), (Object)person, (Column)columns.get(0), 0, true);
        ColumnContext columnWidget = renderer.drawColumn(row, new Cell.Context(1, 1, dataView.getValueKey((Object)person)), (Object)person, (Column)columns.get(2), 1, true);
        try {
            wrapper = (Div)columnText.getTableData().getWidget(0);
            BaseRendererTest.assertEquals((String)"John", (String)wrapper.getElement().getInnerHTML());
            BaseRendererTest.assertTrue((boolean)wrapper.getStyleName().contains("cell"));
        }
        catch (ClassCastException ex) {
            throw new AssertionError("There was an issue casting Text cell.", ex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new AssertionError("There was an issue indexing.", ex);
        }
        try {
            wrapper = (Div)columnWidget.getTableData().getWidget(0);
            BaseRendererTest.assertTrue((boolean)wrapper.getStyleName().contains("widget-cell"));
            MaterialBadge widget = (MaterialBadge)wrapper.getWidget(0);
            BaseRendererTest.assertEquals((String)"badge 1", (String)widget.getText());
            BaseRendererTest.assertEquals((Object)Color.BLUE, (Object)widget.getBackgroundColor());
            BaseRendererTest.assertEquals((String)Style.Position.RELATIVE.getCssName(), (String)widget.getElement().getStyle().getPosition());
        }
        catch (ClassCastException ex) {
            throw new AssertionError("There was an issue casting Widget cell.", ex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new AssertionError("There was an issue indexing.", ex);
        }
    }

    public void testDrawColumnHeader() {
        BaseRenderer renderer = new BaseRenderer();
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        this.addSampleColumns(table);
        table.setRenderer((Renderer)renderer);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        Column column = (Column)dataView.getColumns().get(0);
        TableHeader th = renderer.drawColumnHeader(dataView.getContainer(), column, column.name(), 0);
        BaseRendererTest.assertEquals((String)"col0", (String)th.getId());
        BaseRendererTest.assertEquals((String)column.name(), (String)th.getHeader());
        BaseRendererTest.assertEquals((Object)column.hideOn(), (Object)th.getHideOn());
        BaseRendererTest.assertEquals((Object)column.textAlign(), (Object)th.getTextAlign());
        BaseRendererTest.assertEquals((boolean)column.numeric(), (boolean)th.getStyleName().contains("numeric"));
        BaseRendererTest.assertEquals((String)column.width(), (String)th.getElement().getStyle().getWidth());
        for (Map.Entry entry : column.getStyleProperties().entrySet()) {
            BaseRendererTest.assertEquals((String)((String)entry.getValue()), (String)th.getElement().getStyle().getProperty(((StyleName)entry.getKey()).styleName()));
        }
        BaseRendererTest.assertEquals((Object)renderer.getSortIconSize(), (Object)th.getSortIcon().getIconSize());
    }

    public void testCalculateRowHeight() throws Exception {
        BaseRenderer renderer = new BaseRenderer();
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        table.setRenderer((Renderer)renderer);
        BaseRendererTest.assertEquals((int)table.getRowHeight(), (int)renderer.getCalculatedRowHeight());
    }

    public void testDrawCategory() throws Exception {
        BaseRenderer renderer = new BaseRenderer();
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        table.setUseRowExpansion(true);
        this.addSampleColumns(table);
        table.setSelectionType(SelectionType.SINGLE);
        table.setRenderer((Renderer)renderer);
        AbstractDataView dataView = (AbstractDataView)table.getView();
        List columns = dataView.getColumns();
        Person person = new Person(1, "John", "Doe", "123456", "Catergory");
        CategoryComponent category = (CategoryComponent)dataView.getCategoryFactory().generate((DataView)dataView, (Object)person.getDataCategory());
        TableSubHeader subheader = renderer.drawCategory(category, table.getColumns().size(), (DataView)dataView);
        BaseRendererTest.assertNotNull((Object)subheader);
    }
}

