/*
 * Decompiled with CFR 0.152.
 */
package gwt.material.design.client.data.infinite;

import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.view.client.Range;
import gwt.material.design.client.data.AbstractDataViewTest;
import gwt.material.design.client.data.DataSource;
import gwt.material.design.client.data.MapDataSource;
import gwt.material.design.client.data.infinite.InfiniteDataView;
import gwt.material.design.client.data.infinite.InfiniteRenderer;
import gwt.material.design.client.model.Person;
import gwt.material.design.client.ui.table.MaterialInfiniteDataTable;
import gwt.material.design.jquery.client.api.JQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class InfiniteDataViewTest
extends AbstractDataViewTest<MaterialInfiniteDataTable<Person>> {
    private static final Logger logger = Logger.getLogger(InfiniteDataViewTest.class.getName());
    public static List<String> categories = new ArrayList<String>();
    public static Map<String, List<Person>> peopleMap = new HashMap<String, List<Person>>();

    @Override
    protected MaterialInfiniteDataTable<Person> constructTable() {
        return new MaterialInfiniteDataTable(20, 20, (DataSource)new MapDataSource());
    }

    @Override
    protected MaterialInfiniteDataTable<Person> createTable() {
        MaterialInfiniteDataTable table = (MaterialInfiniteDataTable)super.createTable();
        table.setLoaderDelay(0);
        table.setUseCategories(false);
        return table;
    }

    @Override
    protected MaterialInfiniteDataTable<Person> attachTableWithConstructor(boolean includeData) throws Exception {
        MaterialInfiniteDataTable table = (MaterialInfiniteDataTable)super.attachTableWithConstructor(includeData);
        table.getView().refresh();
        return table;
    }

    @Override
    protected MaterialInfiniteDataTable<Person> attachTableWithOnLoad(boolean includeData) throws Exception {
        MaterialInfiniteDataTable table = (MaterialInfiniteDataTable)super.attachTableWithOnLoad(includeData);
        table.getView().refresh();
        return table;
    }

    @Override
    protected void addSampleRows(MaterialInfiniteDataTable<Person> table) {
        ArrayList flatData = new ArrayList();
        for (Map.Entry<String, List<Person>> entry : peopleMap.entrySet()) {
            flatData.addAll(entry.getValue());
        }
        ((MapDataSource)table.getDataSource()).add(flatData);
    }

    public void testConstructed() throws Exception {
        MaterialInfiniteDataTable<Person> table = this.createTable();
        InfiniteDataViewTest.assertTrue((boolean)(((InfiniteDataView)table.getView()).getRenderer() instanceof InfiniteRenderer));
    }

    @Override
    public void testSetup() throws Exception {
        super.testSetup();
        InfiniteDataView dataView = (InfiniteDataView)((MaterialInfiniteDataTable)this.table).getView();
        InfiniteDataViewTest.assertFalse((boolean)dataView.isDynamicView());
        InfiniteDataViewTest.assertEquals((Object)new Range(0, 100), (Object)dataView.getVisibleRange());
        InfiniteDataViewTest.assertEquals((int)1, (int)JQuery.$((UIObject)dataView.getContainer()).find(".bufferTop").length());
        InfiniteDataViewTest.assertEquals((int)1, (int)JQuery.$((UIObject)dataView.getContainer()).find(".bufferBottom").length());
    }

    @Override
    public void testSortColumnByColumn() throws Exception {
        super.testSortColumnByColumn();
        InfiniteDataView dataView = (InfiniteDataView)((MaterialInfiniteDataTable)this.table).getView();
        InfiniteDataViewTest.assertTrue((boolean)dataView.dataCache.isEmpty());
    }

    static {
        categories.add("People");
        categories.add("Animal");
        categories.add("Plant");
        categories.add("Other");
        categories.add("Next");
        int index = 0;
        for (String category : categories) {
            int i = 0;
            while (i < 100) {
                List data = peopleMap.computeIfAbsent(category, k -> new ArrayList());
                data.add(new Person(index, "http://joashpereira.com/templates/material_one_pager/img/avatar1.png", category + index, "Last" + index, "Phone" + index, category));
                ++i;
                ++index;
            }
        }
    }
}

