/*
 * Decompiled with CFR 0.152.
 */
package gwt.material.design.client.ui.table;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.resources.client.TextResource;
import com.google.gwt.user.client.ui.RootPanel;
import gwt.material.design.client.MaterialDesign;
import gwt.material.design.client.base.constants.StyleName;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.constants.HideOn;
import gwt.material.design.client.constants.TextAlign;
import gwt.material.design.client.data.component.ComponentFactory;
import gwt.material.design.client.data.component.Components;
import gwt.material.design.client.data.component.RowComponent;
import gwt.material.design.client.data.factory.RowComponentFactory;
import gwt.material.design.client.factory.CustomCategoryFactory;
import gwt.material.design.client.factory.PersonRowFactory;
import gwt.material.design.client.model.Person;
import gwt.material.design.client.resources.MaterialResources;
import gwt.material.design.client.resources.MaterialTableBundle;
import gwt.material.design.client.resources.WithJQueryResources;
import gwt.material.design.client.ui.MaterialBadge;
import gwt.material.design.client.ui.table.AbstractDataTable;
import gwt.material.design.client.ui.table.MaterialDataTable;
import gwt.material.design.client.ui.table.cell.Column;
import gwt.material.design.client.ui.table.cell.TextColumn;
import gwt.material.design.client.ui.table.cell.WidgetColumn;
import gwt.material.design.jquery.client.api.JQuery;
import gwt.material.design.jquery.client.api.JQueryElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.junit.Ignore;

@Ignore
public class DataTableTestCase<T extends AbstractDataTable<Person>>
extends GWTTestCase {
    private static final Logger logger = Logger.getLogger(DataTableTestCase.class.getName());
    protected T table;
    protected static final List<Person> people = new ArrayList<Person>();

    public String getModuleName() {
        return "gwt.material.design.GwtMaterialTable";
    }

    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
        if (!MaterialDesign.isjQueryLoaded()) {
            WithJQueryResources jQueryResources = (WithJQueryResources)GWT.create(WithJQueryResources.class);
            MaterialDesign.injectJs((TextResource)jQueryResources.jQuery());
            DataTableTestCase.assertTrue((boolean)MaterialDesign.isjQueryLoaded());
            MaterialDesign.injectJs((TextResource)MaterialResources.INSTANCE.materializeJs());
            DataTableTestCase.assertTrue((boolean)MaterialDesign.isMaterializeLoaded());
            MaterialDesign.injectJs((TextResource)MaterialTableBundle.INSTANCE.jQueryExt());
            MaterialDesign.injectJs((TextResource)MaterialTableBundle.INSTANCE.stickyth());
            MaterialDesign.injectJs((TextResource)MaterialTableBundle.INSTANCE.tableSubHeaders());
            MaterialDesign.injectJs((TextResource)MaterialTableBundle.INSTANCE.greedyScroll());
            MaterialDesign.injectJs((TextResource)MaterialTableBundle.INSTANCE.mutateEvents());
            MaterialDesign.injectJs((TextResource)MaterialTableBundle.INSTANCE.mutate());
            DataTableTestCase.assertNotNull((Object)JQuery.$((String)"body"));
        }
    }

    protected void gwtTearDown() throws Exception {
        super.gwtTearDown();
        this.table = null;
        RootPanel.get().clear();
    }

    protected T attachTableWithConstructor() throws Exception {
        return this.attachTableWithConstructor(true);
    }

    protected T attachTableWithConstructor(boolean includeData) throws Exception {
        T table = this.createTable();
        try {
            this.addSampleColumns(table);
            if (includeData) {
                this.addSampleRows(table);
            }
        }
        catch (AssertionError ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new AssertionError("Could not load table in constructor.", t);
        }
        RootPanel.get().add(table);
        return table;
    }

    protected T attachTableWithOnLoad() throws Exception {
        return this.attachTableWithOnLoad(true);
    }

    protected T attachTableWithOnLoad(boolean includeData) throws Exception {
        T table = this.createTable();
        table.addAttachHandler(event -> {
            try {
                this.addSampleColumns(table);
                if (includeData) {
                    this.addSampleRows(table);
                }
            }
            catch (AssertionError ae) {
                throw ae;
            }
            catch (Throwable t) {
                throw new AssertionError("Could not load table in onLoad.", t);
            }
        });
        RootPanel.get().add(table);
        return table;
    }

    protected T constructTable() {
        return (T)new MaterialDataTable();
    }

    protected T createTable() {
        this.table = this.constructTable();
        this.table.setVisibleRange(0, 100);
        this.table.getView().setRowFactory((RowComponentFactory)new PersonRowFactory());
        this.table.getView().setCategoryFactory((ComponentFactory)new CustomCategoryFactory());
        return this.table;
    }

    protected void addSampleRows(T table) {
        table.setRowData(0, people);
    }

    protected void addSampleColumns(T table) {
        HashMap<StyleName, String> styleProps = new HashMap<StyleName, String>();
        styleProps.put(StyleName.COLOR, "white");
        table.addColumn("First Name", new TextColumn<Person>(){

            public String getValue(Person object) {
                return object.getFirstName();
            }
        }.textAlign(TextAlign.CENTER).numeric(true).width("200px").hideOn(HideOn.HIDE_ON_MED).autoSort(true).styleProperties(styleProps));
        table.addColumn("Last Name", (Column)new TextColumn<Person>(){

            public String getValue(Person object) {
                return object.getLastName();
            }
        });
        table.addColumn(new WidgetColumn<Person, MaterialBadge>(){

            public MaterialBadge getValue(Person object) {
                MaterialBadge badge = new MaterialBadge();
                badge.setText("badge " + object.getId());
                badge.setBackgroundColor(Color.BLUE);
                badge.setLayoutPosition(Style.Position.RELATIVE);
                return badge;
            }
        }.textAlign(TextAlign.CENTER));
    }

    public static void assertValidJQueryElement(JQueryElement element) {
        DataTableTestCase.assertNotNull((Object)element);
        DataTableTestCase.assertTrue((element.get().length > 0 ? 1 : 0) != 0);
    }

    public static <T> void printRows(Components<RowComponent<T>> rowComponents) {
        StringBuilder msg = new StringBuilder("[");
        for (RowComponent row : rowComponents) {
            msg.append(row.getData().toString()).append(", ");
        }
        logger.severe(msg + "]");
    }

    static {
        people.add(new Person(1, "Bill", "Jones", "123456", "Male"));
        people.add(new Person(2, "John", "Doe", "123456", "Male"));
        people.add(new Person(3, "Jim", "Smith", "123456", "Male"));
        people.add(new Person(4, "Beth", "Smith", "123456", "Female"));
        people.add(new Person(5, "Laura", "Doe", "123456", "Female"));
        people.add(new Person(6, "Anna", "Jones", "123456", "Female"));
    }
}

