/*
 * Decompiled with CFR 0.152.
 */
package gwt.material.design.client.ui.table;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.Range;
import gwt.material.design.client.base.density.Density;
import gwt.material.design.client.base.density.DisplayDensity;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.constants.HideOn;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.constants.TextAlign;
import gwt.material.design.client.data.DataSource;
import gwt.material.design.client.data.ListDataSource;
import gwt.material.design.client.data.SelectionType;
import gwt.material.design.client.data.events.CategoryClosedEvent;
import gwt.material.design.client.data.events.CategoryOpenedEvent;
import gwt.material.design.client.data.events.ColumnSortEvent;
import gwt.material.design.client.data.events.ComponentsRenderedEvent;
import gwt.material.design.client.data.events.DestroyEvent;
import gwt.material.design.client.data.events.DestroyHandler;
import gwt.material.design.client.data.events.InsertColumnEvent;
import gwt.material.design.client.data.events.InsertColumnHandler;
import gwt.material.design.client.data.events.RemoveColumnEvent;
import gwt.material.design.client.data.events.RemoveColumnHandler;
import gwt.material.design.client.data.events.RenderedEvent;
import gwt.material.design.client.data.events.RowContextMenuEvent;
import gwt.material.design.client.data.events.RowDoubleClickEvent;
import gwt.material.design.client.data.events.RowExpandedEvent;
import gwt.material.design.client.data.events.RowExpandingEvent;
import gwt.material.design.client.data.events.RowLongPressEvent;
import gwt.material.design.client.data.events.RowSelectEvent;
import gwt.material.design.client.data.events.RowShortPressEvent;
import gwt.material.design.client.data.events.SelectAllEvent;
import gwt.material.design.client.model.Person;
import gwt.material.design.client.ui.MaterialBadge;
import gwt.material.design.client.ui.MaterialCheckBox;
import gwt.material.design.client.ui.MaterialDropDown;
import gwt.material.design.client.ui.MaterialIcon;
import gwt.material.design.client.ui.MaterialImage;
import gwt.material.design.client.ui.pager.MaterialDataPager;
import gwt.material.design.client.ui.pager.actions.PageListBox;
import gwt.material.design.client.ui.pager.actions.PageNumberBox;
import gwt.material.design.client.ui.pager.actions.PageSelection;
import gwt.material.design.client.ui.table.DataTableTestCase;
import gwt.material.design.client.ui.table.MaterialDataTable;
import gwt.material.design.client.ui.table.TableScaffolding;
import gwt.material.design.client.ui.table.cell.Column;
import gwt.material.design.client.ui.table.cell.TextColumn;
import gwt.material.design.client.ui.table.cell.WidgetColumn;
import gwt.material.design.client.ui.table.events.StretchEvent;
import java.util.ArrayList;
import java.util.logging.Logger;

public class MaterialDataTableTest<T extends MaterialDataTable<Person>>
extends DataTableTestCase<T> {
    private static final Logger logger = Logger.getLogger(MaterialDataTableTest.class.getName());

    public void testLoadingInConstructor() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        table.removeFromParent();
        RootPanel.get().add((Widget)table);
    }

    public void testLoadingOnAttach() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithOnLoad();
        table.removeFromParent();
        RootPanel.get().add((Widget)table);
    }

    public void testProperties() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithOnLoad();
        table.setUseStickyHeader(true);
        MaterialDataTableTest.assertTrue((boolean)table.isUseStickyHeader());
        table.setUseStickyHeader(false);
        MaterialDataTableTest.assertFalse((boolean)table.isUseStickyHeader());
        table.setUseCategories(true);
        MaterialDataTableTest.assertTrue((boolean)table.isUseCategories());
        table.setUseCategories(false);
        MaterialDataTableTest.assertFalse((boolean)table.isUseCategories());
        table.setUseRowExpansion(true);
        MaterialDataTableTest.assertTrue((boolean)table.isUseRowExpansion());
        table.setUseRowExpansion(false);
        MaterialDataTableTest.assertFalse((boolean)table.isUseRowExpansion());
        table.setSelectionType(SelectionType.SINGLE);
        MaterialDataTableTest.assertEquals((Object)SelectionType.SINGLE, (Object)table.getSelectionType());
        table.setSelectionType(SelectionType.MULTIPLE);
        MaterialDataTableTest.assertEquals((Object)SelectionType.MULTIPLE, (Object)table.getSelectionType());
        table.setSelectionType(SelectionType.NONE);
        MaterialDataTableTest.assertEquals((Object)SelectionType.NONE, (Object)table.getSelectionType());
    }

    public void testStructure() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithOnLoad();
        table.setTitle("table title");
        MaterialDataTableTest.assertEquals((String)"table title", (String)table.getTitle());
        TableScaffolding scaffolding = table.getScaffolding();
        MaterialIcon tableIcon = table.getTableIcon();
        MaterialDataTableTest.assertEquals((Object)IconType.VIEW_LIST, (Object)tableIcon.getIconType());
        MaterialDataTableTest.assertTrue((boolean)scaffolding.getInfoPanel().getElement().hasClassName("info-panel"));
        MaterialDataTableTest.assertTrue((boolean)scaffolding.getTable().getElement().hasClassName("table"));
        MaterialDataTableTest.assertTrue((boolean)scaffolding.getTableBody().getElement().hasClassName("table-body"));
        MaterialDataTableTest.assertTrue((boolean)scaffolding.getToolPanel().getElement().hasClassName("tool-panel"));
        MaterialIcon stretchIcon = table.getStretchIcon();
        MaterialDataTableTest.assertEquals((Object)IconType.FULLSCREEN, (Object)stretchIcon.getIconType());
        MaterialDataTableTest.assertEquals((String)"stretch", (String)stretchIcon.getId());
        MaterialIcon columnMenuIcon = table.getColumnMenuIcon();
        MaterialDataTableTest.assertEquals((Object)IconType.MORE_VERT, (Object)columnMenuIcon.getIconType());
        MaterialDataTableTest.assertEquals((String)"columnToggle", (String)columnMenuIcon.getId());
        MaterialDataTableTest.assertTrue((boolean)scaffolding.getTopPanel().getElement().hasClassName("top-panel"));
        MaterialDropDown dropDown = table.getMenu();
        MaterialDataTableTest.assertEquals((int)2, (int)dropDown.getWidgetCount());
        int index = 0;
        for (Widget w : dropDown.getChildren()) {
            MaterialDataTableTest.assertTrue((boolean)(w instanceof MaterialCheckBox));
            MaterialCheckBox checkBox = (MaterialCheckBox)w;
            MaterialDataTableTest.assertEquals((String)checkBox.getText(), (String)((Column)table.getColumns().get(index)).name());
            ++index;
        }
    }

    public void testEvents() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.createTable();
        boolean[] isSetupFired = new boolean[]{false};
        table.addSetupHandler(event -> {
            isSetupFired[0] = true;
        });
        RootPanel.get().add((Widget)table);
        MaterialDataTableTest.assertTrue((boolean)isSetupFired[0]);
        table.removeFromParent();
        isSetupFired[0] = false;
        RootPanel.get().add((Widget)table);
        MaterialDataTableTest.assertFalse((boolean)isSetupFired[0]);
        boolean[] isInsertedColumnFired = new boolean[]{false};
        table.addHandler((EventHandler)((InsertColumnHandler)event -> {
            isInsertedColumnFired[0] = true;
        }), InsertColumnEvent.TYPE);
        table.addColumn("Last Name", (Column)new TextColumn<Person>(){

            public String getValue(Person object) {
                return object.getLastName();
            }
        });
        MaterialDataTableTest.assertTrue((boolean)isInsertedColumnFired[0]);
        boolean[] isRemoveColumnFired = new boolean[]{false};
        table.addHandler((EventHandler)((RemoveColumnHandler)event -> {
            isRemoveColumnFired[0] = true;
        }), RemoveColumnEvent.TYPE);
        table.removeColumn(0);
        MaterialDataTableTest.assertTrue((boolean)isRemoveColumnFired[0]);
        boolean[] isDestroyFired = new boolean[]{false};
        table.addHandler((EventHandler)((DestroyHandler)event -> {
            isDestroyFired[0] = true;
        }), DestroyEvent.TYPE);
        table.setDestroyOnUnload(true);
        table.removeFromParent();
        MaterialDataTableTest.assertTrue((boolean)isDestroyFired[0]);
        boolean[] isCategoryClosedFired = new boolean[]{false};
        table.addCategoryClosedHandler(event -> {
            isCategoryClosedFired[0] = true;
        });
        table.fireEvent((GwtEvent)new CategoryClosedEvent(null, null));
        MaterialDataTableTest.assertTrue((boolean)isCategoryClosedFired[0]);
        boolean[] isCategoryOpenedFired = new boolean[]{false};
        table.addCategoryOpenedHandler(event -> {
            isCategoryOpenedFired[0] = true;
        });
        table.fireEvent((GwtEvent)new CategoryOpenedEvent(null, null));
        MaterialDataTableTest.assertTrue((boolean)isCategoryOpenedFired[0]);
        boolean[] isRowContextMenuFired = new boolean[]{false};
        table.addRowContextMenuHandler(event -> {
            isRowContextMenuFired[0] = true;
        });
        table.fireEvent((GwtEvent)new RowContextMenuEvent(null, null, null));
        MaterialDataTableTest.assertTrue((boolean)isRowContextMenuFired[0]);
        boolean[] isRowDoubleClickFired = new boolean[]{false};
        table.addRowDoubleClickHandler(event -> {
            isRowDoubleClickFired[0] = true;
        });
        table.fireEvent((GwtEvent)new RowDoubleClickEvent(null, null, null));
        MaterialDataTableTest.assertTrue((boolean)isRowDoubleClickFired[0]);
        boolean[] isRowExpandFired = new boolean[]{false};
        table.addRowExpandingHandler(event -> {
            isRowExpandFired[0] = true;
        });
        table.fireEvent((GwtEvent)new RowExpandingEvent(null));
        MaterialDataTableTest.assertTrue((boolean)isRowExpandFired[0]);
        boolean[] isRowExpandedFired = new boolean[]{false};
        table.addRowExpandedHandler(event -> {
            isRowExpandedFired[0] = true;
        });
        table.fireEvent((GwtEvent)new RowExpandedEvent(null));
        MaterialDataTableTest.assertTrue((boolean)isRowExpandedFired[0]);
        boolean[] isRowLongPressFired = new boolean[]{false};
        table.addRowLongPressHandler(event -> {
            isRowLongPressFired[0] = true;
        });
        table.fireEvent((GwtEvent)new RowLongPressEvent(null, null, null));
        MaterialDataTableTest.assertTrue((boolean)isRowLongPressFired[0]);
        boolean[] isRowSelectFired = new boolean[]{false};
        table.addRowSelectHandler(event -> {
            isRowSelectFired[0] = true;
        });
        table.fireEvent((GwtEvent)new RowSelectEvent(null, null, null, true));
        MaterialDataTableTest.assertTrue((boolean)isRowSelectFired[0]);
        boolean[] isRowShortPressFired = new boolean[]{false};
        table.addRowShortPressHandler(event -> {
            isRowShortPressFired[0] = true;
        });
        table.fireEvent((GwtEvent)new RowShortPressEvent(null, null, null));
        MaterialDataTableTest.assertTrue((boolean)isRowShortPressFired[0]);
        boolean[] isSelectAllFired = new boolean[]{false};
        table.addSelectAllHandler(event -> {
            isSelectAllFired[0] = true;
        });
        table.fireEvent((GwtEvent)new SelectAllEvent(new ArrayList(), new ArrayList(), true));
        MaterialDataTableTest.assertTrue((boolean)isSelectAllFired[0]);
        boolean[] isSortColumnFired = new boolean[]{false};
        table.addColumnSortHandler(event -> {
            isSortColumnFired[0] = true;
        });
        table.fireEvent((GwtEvent)new ColumnSortEvent(null, 0));
        MaterialDataTableTest.assertTrue((boolean)isSortColumnFired[0]);
        boolean[] isStretchFired = new boolean[]{false};
        table.addStretchHandler(event -> {
            isStretchFired[0] = true;
        });
        table.fireEvent((GwtEvent)new StretchEvent(true));
        MaterialDataTableTest.assertTrue((boolean)isStretchFired[0]);
        boolean[] isCompRendered = new boolean[]{false};
        table.addComponentsRenderedHandler(e -> {
            isCompRendered[0] = true;
        });
        table.fireEvent((GwtEvent)new ComponentsRenderedEvent());
        MaterialDataTableTest.assertTrue((boolean)isCompRendered[0]);
        boolean[] isRendered = new boolean[]{false};
        table.addRenderedHandler(e -> {
            isRendered[0] = true;
        });
        table.fireEvent((GwtEvent)new RenderedEvent());
        MaterialDataTableTest.assertTrue((boolean)isRendered[0]);
    }

    public void testColumnsRows() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithConstructor();
        table.clearRows(true);
        table.removeColumns();
        WidgetColumn<Person, MaterialImage> col1 = new WidgetColumn<Person, MaterialImage>(){

            public MaterialImage getValue(Person object) {
                MaterialImage profile = new MaterialImage();
                profile.setUrl(object.getPicture());
                profile.setWidth("40px");
                profile.setHeight("40px");
                profile.setPadding(4.0);
                profile.setMarginTop(8.0);
                profile.setBackgroundColor(Color.GREY_LIGHTEN_2);
                profile.setCircle(true);
                return profile;
            }
        };
        table.addColumn((Column)col1);
        MaterialDataTableTest.assertEquals((Object)col1, table.getColumns().get(0));
        Column col2 = new TextColumn<Person>(){

            public String getValue(Person object) {
                return object.getFirstName();
            }
        }.sortable(true).sortComparator((o1, o2) -> ((Person)o1.getData()).getFirstName().compareToIgnoreCase(((Person)o2.getData()).getFirstName()));
        table.addColumn("First Name", col2);
        MaterialDataTableTest.assertEquals((Object)col2, table.getColumns().get(1));
        MaterialDataTableTest.assertEquals((String)"First Name", (String)col2.name());
        MaterialDataTableTest.assertTrue((boolean)col2.sortable());
        Column col3 = new TextColumn<Person>(){

            public String getValue(Person object) {
                return object.getLastName();
            }
        }.sortable(true).sortComparator((o1, o2) -> ((Person)o1.getData()).getLastName().compareToIgnoreCase(((Person)o2.getData()).getLastName()));
        table.addColumn("Last Name", col3);
        MaterialDataTableTest.assertEquals((Object)col3, table.getColumns().get(2));
        MaterialDataTableTest.assertEquals((String)"Last Name", (String)col3.name());
        MaterialDataTableTest.assertTrue((boolean)col2.sortable());
        Column col4 = new TextColumn<Person>(){

            public String getValue(Person object) {
                return object.getPhone();
            }
        }.numeric(true).hideOn(HideOn.HIDE_ON_MED_DOWN).sortable(true).sortComparator((o1, o2) -> ((Person)o1.getData()).getPhone().compareToIgnoreCase(((Person)o2.getData()).getPhone()));
        table.addColumn("Phone", col4);
        MaterialDataTableTest.assertEquals((Object)col4, table.getColumns().get(3));
        MaterialDataTableTest.assertEquals((String)"Phone", (String)col4.name());
        MaterialDataTableTest.assertTrue((boolean)col4.numeric());
        for (int i = 0; i < 4; ++i) {
            final int index = i;
            Column col = new TextColumn<Person>(){

                public String getValue(Person object) {
                    return object.getPhone() + " " + index;
                }
            }.sortable(true).sortComparator((o1, o2) -> ((Person)o1.getData()).getPhone().compareToIgnoreCase(((Person)o2.getData()).getPhone()));
            table.addColumn("Column " + index, col);
            MaterialDataTableTest.assertEquals((Object)col, table.getColumns().get(3 + (i + 1)));
            MaterialDataTableTest.assertEquals((String)("Column " + index), (String)col.name());
            MaterialDataTableTest.assertTrue((boolean)col.sortable());
        }
        Column lastCol = new WidgetColumn<Person, MaterialBadge>(){

            public MaterialBadge getValue(Person object) {
                MaterialBadge badge = new MaterialBadge();
                badge.setText("badge " + object.getId());
                badge.setBackgroundColor(Color.BLUE);
                return badge;
            }
        }.textAlign(TextAlign.CENTER);
        table.addColumn(lastCol);
        MaterialDataTableTest.assertEquals((Object)lastCol, table.getColumns().get(8));
        MaterialDataTableTest.assertEquals((int)9, (int)table.getColumns().size());
        table.setVisibleRange(0, 1000);
        Range range = table.getVisibleRange();
        MaterialDataTableTest.assertEquals((int)0, (int)range.getStart());
        MaterialDataTableTest.assertEquals((int)1000, (int)range.getLength());
        table.setRowData(0, people);
    }

    public void testStretch() throws Exception {
    }

    public void testDynamicColumn() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithOnLoad();
        table.removeColumn(0);
        MaterialDataTableTest.assertEquals((int)2, (int)table.getColumns().size());
        MaterialDataTableTest.assertEquals((int)0, (int)table.getColumnOffset());
        Column insertedCol = new TextColumn<Person>(){

            public String getValue(Person object) {
                return object.getFirstName();
            }
        }.sortable(true).sortComparator((o1, o2) -> ((Person)o1.getData()).getFirstName().compareToIgnoreCase(((Person)o2.getData()).getFirstName()));
        table.insertColumn("insertedCol", 0, insertedCol);
        MaterialDataTableTest.assertEquals((Object)insertedCol, table.getColumns().get(0));
        MaterialDataTableTest.assertEquals((int)3, (int)table.getColumns().size());
    }

    public void testPager() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithOnLoad();
        ListDataSource dataSource = new ListDataSource();
        ArrayList<Person> people = new ArrayList<Person>();
        for (int k = 1; k <= 5; ++k) {
            for (int i = 1; i <= 3; ++i) {
                people.add(new Person(i, "First Name", "Last Name ", "Field " + i, "Category " + k));
            }
        }
        dataSource.add(0, people);
        table.setDataSource((DataSource)dataSource);
        MaterialDataPager pager = new MaterialDataPager(table, (DataSource)dataSource);
        pager.setLimitOptions(new int[]{5, 10, 15});
        RootPanel.get().add((Widget)pager);
        MaterialDataTableTest.assertEquals((int)pager.getLimitOptions()[0], (int)pager.getLimit());
        MaterialDataTableTest.assertEquals((int)5, (int)pager.getLimit());
        MaterialDataTableTest.assertFalse((boolean)pager.isExcess());
        MaterialDataTableTest.assertEquals((int)1, (int)pager.getCurrentPage());
        MaterialDataTableTest.assertEquals((int)15, (int)pager.getTotalRows());
        pager.setLimit(10);
        MaterialDataTableTest.assertEquals((int)10, (int)pager.getLimit());
        MaterialDataTableTest.assertTrue((boolean)pager.isExcess());
        MaterialDataTableTest.assertEquals((int)1, (int)pager.getCurrentPage());
        MaterialDataTableTest.assertFalse((boolean)pager.isPrevious());
        pager.next();
        MaterialDataTableTest.assertFalse((boolean)pager.isNext());
        MaterialDataTableTest.assertTrue((boolean)pager.isLastPage());
        MaterialDataTableTest.assertEquals((int)2, (int)pager.getCurrentPage());
        pager.previous();
        MaterialDataTableTest.assertEquals((int)1, (int)pager.getCurrentPage());
        MaterialDataTableTest.assertTrue((boolean)(pager.getPageSelection() instanceof PageNumberBox));
        MaterialDataTableTest.assertNotNull((Object)((PageNumberBox)pager.getPageSelection()).getComponent());
        pager.setPageSelection((PageSelection)new PageListBox());
        MaterialDataTableTest.assertTrue((boolean)(pager.getPageSelection() instanceof PageListBox));
        MaterialDataTableTest.assertNotNull((Object)((PageListBox)pager.getPageSelection()).getComponent());
    }

    public void testMenu() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithOnLoad();
        MaterialDataTableTest.assertTrue((table.getMenu().getWidgetCount() > 0 ? 1 : 0) != 0);
    }

    public void testDensity() throws Exception {
        MaterialDataTable table = (MaterialDataTable)this.attachTableWithOnLoad();
        MaterialDataTableTest.assertEquals((Object)DisplayDensity.DEFAULT, (Object)table.getDensity());
        table.setDensity((Density)DisplayDensity.COMPACT);
        MaterialDataTableTest.assertEquals((Object)DisplayDensity.COMPACT, (Object)table.getDensity());
        MaterialDataTableTest.assertTrue((boolean)table.getScaffolding().getTable().getElement().hasClassName(DisplayDensity.COMPACT.getCssName()));
        table.setDensity((Density)DisplayDensity.COMFORTABLE);
        MaterialDataTableTest.assertEquals((Object)DisplayDensity.COMFORTABLE, (Object)table.getDensity());
        MaterialDataTableTest.assertTrue((boolean)table.getScaffolding().getTable().getElement().hasClassName(DisplayDensity.COMFORTABLE.getCssName()));
    }
}

