/*
 * Decompiled with CFR 0.152.
 */
package com.github.harbby.spark.sql.kafka.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.github.harbby.spark.sql.kafka.model.KafkaPartitionOffset;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kafka.common.TopicAndPartition;
import org.apache.spark.sql.sources.v2.reader.streaming.Offset;

public class KafkaSourceOffset
extends Offset {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Map<TopicAndPartition, Long> partitionToOffsets;

    public KafkaSourceOffset(Map<TopicAndPartition, Long> partitionToOffsets) {
        this.partitionToOffsets = partitionToOffsets;
    }

    public Map<TopicAndPartition, Long> getPartitionToOffsets() {
        return this.partitionToOffsets;
    }

    public static Map<TopicAndPartition, Long> getPartitionOffsets(Offset offset) {
        if (offset instanceof KafkaSourceOffset) {
            return ((KafkaSourceOffset)offset).getPartitionToOffsets();
        }
        throw new IllegalArgumentException("Invalid conversion from offset of " + offset.getClass() + " to KafkaSourceOffset");
    }

    public static KafkaSourceOffset format(String json) {
        MapType mapType = MapType.construct(HashMap.class, (JavaType)SimpleType.construct(Integer.class), (JavaType)SimpleType.construct(Long.class));
        try {
            Map result = (Map)MAPPER.readValue(json, (JavaType)MapType.construct(HashMap.class, (JavaType)SimpleType.construct(String.class), (JavaType)mapType));
            Map<TopicAndPartition, Long> partitionToOffsets = result.entrySet().stream().flatMap(x -> ((Map)x.getValue()).entrySet().stream().map(y -> new KafkaPartitionOffset(TopicAndPartition.apply((String)((String)x.getKey()), (int)((Integer)y.getKey())), (Long)y.getValue()))).collect(Collectors.toMap(k -> k.getTopicPartition(), v -> v.getOffset()));
            return new KafkaSourceOffset(partitionToOffsets);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String json() {
        HashMap result = new HashMap();
        this.partitionToOffsets.forEach((topicAndPartition, offset) -> {
            String topic = topicAndPartition.topic();
            result.computeIfAbsent(topic, key -> new HashMap()).put(topicAndPartition.partition(), offset);
        });
        try {
            return MAPPER.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

