/*
 * Decompiled with CFR 0.152.
 */
package com.github.harbby.spark.sql.kafka.util;

import com.github.harbby.spark.sql.kafka.model.TopicPartitionLeader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.cluster.Broker;
import kafka.common.ErrorMapping;
import kafka.common.TopicAndPartition;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.consumer.SimpleConsumer;
import org.apache.spark.streaming.kafka.KafkaCluster;
import org.apache.spark.streaming.kafka.KafkaUtils$;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.util.Either;

public class KafkaUtil {
    private KafkaUtil() {
    }

    public static java.util.Map<TopicAndPartition, Long> getFromOffset(KafkaCluster kafkaCluster, String topics, String groupId) {
        Set<String> topicSets = Arrays.stream(topics.split(",")).collect(Collectors.toSet());
        return KafkaUtil.getFromOffset(kafkaCluster, topicSets, groupId);
    }

    public static java.util.Map<TopicAndPartition, Long> getFromOffset(KafkaCluster kafkaCluster, Set<String> topics, String groupId) {
        scala.collection.immutable.Set scalaTopicSets = ((scala.collection.mutable.Set)JavaConverters.asScalaSetConverter(topics).asScala()).toSet();
        Either groupOffsets = kafkaCluster.getConsumerOffsets(groupId, (scala.collection.immutable.Set)kafkaCluster.getPartitions(scalaTopicSets).right().get());
        scala.collection.immutable.Map fromOffsets = groupOffsets.isRight() ? (scala.collection.immutable.Map)groupOffsets.right().get() : KafkaUtils$.MODULE$.getFromOffsets(kafkaCluster, kafkaCluster.kafkaParams(), scalaTopicSets);
        return ((java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)fromOffsets).asJava()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> (long)((Long)v.getValue())));
    }

    public static List<TopicPartitionLeader> getBrokers(SimpleConsumer consumer, List<String> topics, String[] brokers) {
        ArrayList<TopicPartitionLeader> partitionLeaders = new ArrayList<TopicPartitionLeader>();
        for (TopicMetadata item : consumer.send(new TopicMetadataRequest(topics)).topicsMetadata()) {
            if (item.errorCode() != ErrorMapping.NoError()) {
                throw new IllegalArgumentException("Error while getting metadata from broker " + brokers + " to find partitions for " + topics.toString() + ". Error: {}" + ErrorMapping.exceptionFor((short)item.errorCode()).getMessage());
            }
            if (!topics.contains(item.topic())) {
                throw new IllegalArgumentException("Received metadata from topic " + item.topic() + " even though it was not requested. Skipping ...");
            }
            for (PartitionMetadata part : item.partitionsMetadata()) {
                Broker leader = new Broker(part.leader().id(), part.leader().host(), part.leader().port());
                TopicAndPartition ktp = new TopicAndPartition(item.topic(), part.partitionId());
                TopicPartitionLeader pInfo = new TopicPartitionLeader(ktp, leader);
                partitionLeaders.add(pInfo);
            }
        }
        return partitionLeaders;
    }
}

