/*
 * Decompiled with CFR 0.152.
 */
package com.github.harbby.spark.sql.kafka.util;

import java.util.Properties;
import org.slf4j.Logger;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static int getInt(Properties config, String key, int defaultValue) {
        String val = config.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Value for configuration key='" + key + "' is not set correctly. Entered value='" + val + "'. Default value='" + defaultValue + "'");
        }
    }

    public static long getLong(Properties config, String key, long defaultValue) {
        String val = config.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Value for configuration key='" + key + "' is not set correctly. Entered value='" + val + "'. Default value='" + defaultValue + "'");
        }
    }

    public static long getLong(Properties config, String key, long defaultValue, Logger logger) {
        try {
            return PropertiesUtil.getLong(config, key, defaultValue);
        }
        catch (IllegalArgumentException iae) {
            logger.warn(iae.getMessage());
            return defaultValue;
        }
    }

    public static boolean getBoolean(Properties config, String key, boolean defaultValue) {
        String val = config.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(val);
    }
}

