/*
 * Decompiled with CFR 0.152.
 */
package com.github.hekonsek.rxjava.connector.http;

import com.github.hekonsek.rxjava.connector.http.HttpSource;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.core.http.HttpServerRequest;

public class HttpSourceFactory {
    private final HttpServer server;
    private final Observable<HttpServerRequest> requests;

    public HttpSourceFactory(Vertx vertx) {
        this.server = vertx.createHttpServer();
        this.requests = this.server.requestStream().toObservable().publish().autoConnect();
    }

    public HttpSource build(String uri) {
        return new HttpSource((Observable<HttpServerRequest>)this.requests.filter(request -> request.uri().equals(uri)));
    }

    public Single<HttpServer> listen(int port) {
        return this.server.rxListen(port);
    }

    public Single<HttpServer> listen() {
        return this.server.rxListen(8080);
    }
}

