package com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin;

import com.github.hetianyi.plugins.generator.pojo.generator.ClassGenerator;
import com.github.hetianyi.plugins.generator.common.Slot;
import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.Feature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.SlotHelper;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.CodeSlot;
import com.google.common.collect.ImmutableList;
import lombok.extern.slf4j.Slf4j;

/**
 * 特性：生成本插件项目的传播注释
 *
 * @author Jason He
 */
@Slf4j
public class ProjectBroadcastCommentFeature implements Feature {

    @Override
    public void apply(ClassGenerator generator) {
        log.debug("应用Feature -> ProjectBroadcastCommentFeature");
        ImmutableList<CodeSlot> codeSlots = ImmutableList.of(
                CodeSlot.of("\n * \n * <br><br>\n * This class is automatically generated by\n",
                                    " * <a href=\"https://github.com/hetianyi/code-generator-plugin\">code-generator-plugin</a>.")
        );
        SlotHelper.insertBefore(generator, SlotType.COMMENT_CONTENT_END, codeSlots.toArray(new Slot[0]));
    }
}
