/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.common;

import cn.hutool.db.Db;
import com.github.hetianyi.boot.ready.common.Const;
import com.github.hetianyi.boot.ready.common.util.CollectionUtil;
import com.github.hetianyi.plugins.generator.common.DbConfigurationProperties;
import com.github.hetianyi.plugins.generator.common.InstanceConfig;
import com.github.hetianyi.plugins.generator.common.ProfileProperties;
import com.mysql.cj.jdbc.MysqlDataSource;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(BaseMojo.class);
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    @Parameter
    private DbConfigurationProperties database;
    @Parameter
    private List<String> activeProfiles;
    @Parameter
    private List<ProfileProperties> profiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.configureDefaultValue();
        this.printConfig();
        if (CollectionUtil.isNullOrEmpty(this.profiles)) {
            log.info("\u6ca1\u6709\u8981\u6267\u884c\u7684profile");
        }
        InstanceConfig.setProfileProperties(this.profiles);
        InstanceConfig.setActiveProfiles(this.activeProfiles);
        InstanceConfig.setDbProperties(this.database);
        ClassLoader classLoader = this.getClassLoader(this.project);
        InstanceConfig.setClassLoader(classLoader);
        if ("mysql".equalsIgnoreCase(this.database.getType())) {
            this.connectMysqlDB();
        } else if ("postgresql".equalsIgnoreCase(this.database.getType())) {
            this.connectPostgresqlDB();
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b: " + this.database.getType());
        }
        try {
            for (ProfileProperties props : this.profiles) {
                if (!this.activeProfiles.stream().filter(v -> Objects.equals(v, props.getName())).findAny().isPresent()) continue;
                this.runProfile(props);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException((Throwable)e);
        }
    }

    private void printConfig() {
        log.info("\u5f00\u59cb\u6267\u884c\u63d2\u4ef6");
        log.debug("dbConfig=" + Const.GSON.toJson((Object)this.database));
        log.debug("activeProfiles=" + Const.GSON.toJson(this.activeProfiles));
        log.debug("profiles=" + Const.GSON.toJson(this.profiles));
        log.debug("\u5f53\u524d\u76ee\u5f55=" + this.project.getBasedir());
    }

    private void connectMysqlDB() throws MojoFailureException {
        try {
            MysqlDataSource ds = new MysqlDataSource();
            ds.setServerName(this.database.getHost());
            ds.setPort(this.database.getPort());
            ds.setUser(this.database.getUsername());
            ds.setPassword(this.database.getPassword());
            ds.setCharacterEncoding("utf8");
            ds.setServerTimezone("GMT+8");
            ds.setAutoReconnect(true);
            ds.setDatabaseName(this.database.getDbName());
            log.info("\u8fde\u63a5MySQL\u6570\u636e\u5e93: " + ds.getUrl());
            Db dbUtil = Db.use((DataSource)ds, (String)"com.mysql.cj.jdbc.Driver");
            InstanceConfig.setDb(dbUtil);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException((Throwable)e);
        }
    }

    private void connectPostgresqlDB() throws MojoFailureException {
        try {
            PGSimpleDataSource ds = new PGSimpleDataSource();
            ds.setServerName(this.database.getHost());
            ds.setDatabaseName(this.database.getDbName());
            ds.setUser(this.database.getUsername());
            ds.setPassword(this.database.getPassword());
            ds.setCurrentSchema(this.database.getSchema());
            log.info("\u8fde\u63a5PG\u6570\u636e\u5e93: " + ds.getUrl());
            Db dbUtil = Db.use((DataSource)ds, (String)"org.postgresql.Driver");
            InstanceConfig.setDb(dbUtil);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException((Throwable)e);
        }
    }

    protected void runProfile(ProfileProperties profile) throws Exception {
        this.getLog().info((CharSequence)("-----------------------------[ profile: " + profile.getName() + " ]----------------------------"));
    }

    private void configureDefaultValue() {
        if (null == this.database) {
            this.database = new DbConfigurationProperties();
        }
        if (null == this.activeProfiles) {
            this.activeProfiles = new LinkedList<String>();
        }
        if (null == this.profiles) {
            this.activeProfiles = new LinkedList<String>();
        }
    }

    private ClassLoader getClassLoader(MavenProject project) {
        try {
            List classpathElements = project.getCompileClasspathElements();
            classpathElements.add(project.getBuild().getOutputDirectory());
            classpathElements.add(project.getBuild().getTestOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            log.debug("Couldn't get the classloader.");
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
    }
}

