/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo.generator;

import com.github.hetianyi.boot.ready.common.Const;
import com.github.hetianyi.boot.ready.common.util.CollectionUtil;
import com.github.hetianyi.boot.ready.common.util.StringUtil;
import com.github.hetianyi.plugins.generator.common.InstanceConfig;
import com.github.hetianyi.plugins.generator.common.Pair;
import com.github.hetianyi.plugins.generator.common.ProfileProperties;
import com.github.hetianyi.plugins.generator.common.Slot;
import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.common.util.GenerateUtil;
import com.github.hetianyi.plugins.generator.pojo.entity.TableColumn;
import com.github.hetianyi.plugins.generator.pojo.entity.TableDefinition;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.Feature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.PreGenerateFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.SlotFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.TypeMappingFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin.ClassCommentFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin.CopyrightFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin.DefaultTypeMappingFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin.FieldCommentFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin.GetterSetterFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin.IdField2StringFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin.ImportFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin.ProjectBroadcastCommentFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.jackson.DateFormatAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.jackson.IgnoreNullFieldAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.jackson.JasonFormatAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.jpa.JpaClassAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.jpa.JpaFieldAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.lombok.LombokAllArgsConstructorAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.lombok.LombokBuilderAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.lombok.LombokDataAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.lombok.LombokNoArgsConstructorAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.mybatis.MyBatisPlusClassAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.mybatis.MyBatisPlusFieldAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.ready.ConvertibleFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.swagger.SwaggerApiModelAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.swagger.SwaggerApiModelPropertyAnnotationFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.CodeSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.EmptyLineSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.IndentSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.MarkupSlot;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassGenerator {
    private static final Logger log = LoggerFactory.getLogger(ClassGenerator.class);
    private TableDefinition tabDef;
    private ProfileProperties profile;
    private List<Slot> slots;
    private Set<String> imports;
    private Set<String> implementNames;
    private String className;
    private String lowerObjectName;
    private String upperObjectName;
    public static final String MUST_LAST_FEATURE = "ImportFeature";
    public static final List<String> staticFeatures = ImmutableList.of((Object)"ClassCommentFeature", (Object)"ProjectBroadcastCommentFeature", (Object)"CopyrightFeature", (Object)"FieldCommentFeature", (Object)"GetterSetterFeature", (Object)"ImportFeature");
    private List<Feature> features = new LinkedList<Feature>();
    private List<SlotFeature> runtimeFeatures = new LinkedList<SlotFeature>();
    private TypeMappingFeature typeFeature = new DefaultTypeMappingFeature();
    private static final Map<String, Feature> buildInFeatureMap = new HashMap<String, Feature>(){
        {
            this.put("ClassCommentFeature", new ClassCommentFeature());
            this.put("ProjectBroadcastCommentFeature", new ProjectBroadcastCommentFeature());
            this.put("CopyrightFeature", new CopyrightFeature());
            this.put("FieldCommentFeature", new FieldCommentFeature());
            this.put("GetterSetterFeature", new GetterSetterFeature());
            this.put(ClassGenerator.MUST_LAST_FEATURE, new ImportFeature());
            this.put("IdField2StringFeature", new IdField2StringFeature());
            this.put("JasonFormatAnnotationFeature", new JasonFormatAnnotationFeature());
            this.put("DateFormatAnnotationFeature", new DateFormatAnnotationFeature());
            this.put("IgnoreNullFieldAnnotationFeature", new IgnoreNullFieldAnnotationFeature());
            this.put("LombokAllArgsConstructorAnnotationFeature", new LombokAllArgsConstructorAnnotationFeature());
            this.put("LombokBuilderAnnotationFeature", new LombokBuilderAnnotationFeature());
            this.put("LombokDataAnnotationFeature", new LombokDataAnnotationFeature());
            this.put("LombokNoArgsConstructorAnnotationFeature", new LombokNoArgsConstructorAnnotationFeature());
            this.put("MyBatisPlusClassAnnotationFeature", new MyBatisPlusClassAnnotationFeature());
            this.put("MyBatisPlusFieldAnnotationFeature", new MyBatisPlusFieldAnnotationFeature());
            this.put("JpaClassAnnotationFeature", new JpaClassAnnotationFeature());
            this.put("JpaFieldAnnotationFeature", new JpaFieldAnnotationFeature());
            this.put("ConvertibleFeature", new ConvertibleFeature());
            this.put("SwaggerApiModelAnnotationFeature", new SwaggerApiModelAnnotationFeature());
            this.put("SwaggerApiModelPropertyAnnotationFeature", new SwaggerApiModelPropertyAnnotationFeature());
        }
    };

    private ClassGenerator(TableDefinition tabDef, ProfileProperties profile) {
        this.tabDef = tabDef;
        this.profile = profile;
        this.slots = new LinkedList<Slot>();
        this.imports = new HashSet<String>();
        this.checkFeatures(profile);
        log.debug("----- \u4f7f\u7528\u7684 features -----");
        log.debug(Const.GSON.toJson(this.features.stream().map(v -> v.getClass().getSimpleName()).collect(Collectors.toList())));
    }

    public static ClassGenerator from(TableDefinition tabDef, ProfileProperties profile) {
        return new ClassGenerator(tabDef, profile);
    }

    private void checkFeatures(ProfileProperties profile) {
        LinkedList<String> candidates = new LinkedList<String>(staticFeatures);
        List<String> providedFeatures = profile.getFeatures();
        if (CollectionUtil.isNullOrEmpty(providedFeatures)) {
            log.info("\u6ca1\u6709\u5e94\u7528\u7684\u7279\u6027");
            return;
        }
        LinkedList ignoreFeatures = new LinkedList();
        for (String f : providedFeatures) {
            if (StringUtil.isNullOrEmpty((String)f) || candidates.contains(f)) continue;
            if (f.startsWith("-")) {
                log.debug("\u6392\u9664feature: {}", (Object)f.substring(1));
                candidates.remove(f.substring(1));
                continue;
            }
            if (staticFeatures.contains(f)) continue;
            if (!buildInFeatureMap.containsKey(f)) {
                try {
                    Class<?> featureClass = InstanceConfig.getClassLoader().loadClass(f);
                    if (!Feature.class.isAssignableFrom(featureClass)) {
                        throw new RuntimeException("\u7c7b\"" + f + "\"\u4e0d\u662f\u6709\u6548\u7684feature, \u5fc5\u987b\u7ee7\u627fCustomFeature\u7c7b\u6216\u5b9e\u73b0Feature\u63a5\u53e3");
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("\u65e0\u6cd5\u52a0\u8f7dfeature: " + f);
                }
            }
            candidates.add(f);
        }
        candidates.remove(MUST_LAST_FEATURE);
        candidates.add(MUST_LAST_FEATURE);
        for (String candidate : candidates) {
            Feature feature = buildInFeatureMap.get(candidate);
            if (null != feature) {
                this.features.add(feature);
                continue;
            }
            try {
                Object o = InstanceConfig.getClassLoader().loadClass(candidate).newInstance();
                if (o instanceof SlotFeature) {
                    this.runtimeFeatures.add((SlotFeature)o);
                    continue;
                }
                if (o instanceof TypeMappingFeature) {
                    this.typeFeature = (TypeMappingFeature)o;
                    continue;
                }
                this.features.add((Feature)o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void handlerPreGenerateFeatures() {
        this.features.stream().filter(v -> v instanceof PreGenerateFeature).forEach(v -> v.apply(this));
    }

    private void applySlotFeatures(Slot s) {
        if (this.runtimeFeatures.isEmpty()) {
            this.slots.add(s);
            return;
        }
        this.runtimeFeatures.forEach(v -> {
            Slot r = v.resolve(s);
            if (r != null) {
                this.slots.add(r);
            }
        });
    }

    private Pair getTypeFeature(String dbTypeName) {
        Pair type = this.typeFeature.getType(dbTypeName);
        if (null == type) {
            throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u6570\u636e\u5e93\u5b57\u6bb5\u7c7b\u578b\u7684Java\u7c7b\u578b\u6620\u5c04\uff1a" + dbTypeName + " -> ?");
        }
        return type;
    }

    public ClassGenerator generateStructure() {
        this.handlerPreGenerateFeatures();
        this.upperObjectName = this.className = GenerateUtil.camel(GenerateUtil.removePrefixOrSuffix(this.tabDef.getName()), true);
        this.lowerObjectName = GenerateUtil.camel(GenerateUtil.removePrefixOrSuffix(this.tabDef.getName()), false);
        if (!StringUtil.isNullOrEmpty((String)this.profile.getAppendSuffix())) {
            this.className = StringUtil.trimSafe((String)this.profile.getAppendPrefix()) + this.className + StringUtil.trimSafe((String)this.profile.getAppendSuffix());
        }
        log.info("\u89e3\u6790Class: {}", (Object)this.className);
        this.applySlotFeatures(MarkupSlot.of(SlotType.COPYRIGHT_START));
        this.applySlotFeatures(MarkupSlot.of(SlotType.COPYRIGHT_END));
        this.applySlotFeatures(MarkupSlot.of(SlotType.PACKAGE_START));
        this.applySlotFeatures(CodeSlot.of("package ", this.profile.getPackageName(), ";"));
        this.applySlotFeatures(EmptyLineSlot.getInstance());
        this.applySlotFeatures(EmptyLineSlot.getInstance());
        this.applySlotFeatures(MarkupSlot.of(SlotType.PACKAGE_END));
        this.applySlotFeatures(MarkupSlot.of(SlotType.IMPORT_START));
        this.applySlotFeatures(MarkupSlot.of(SlotType.IMPORT_END));
        this.applySlotFeatures(EmptyLineSlot.getInstance());
        this.applySlotFeatures(CodeSlot.of("/**"));
        this.applySlotFeatures(EmptyLineSlot.getInstance());
        this.applySlotFeatures(CodeSlot.of(" * "));
        this.applySlotFeatures(MarkupSlot.of(SlotType.COMMENT_CONTENT_START));
        this.applySlotFeatures(MarkupSlot.of(SlotType.COMMENT_CONTENT_END));
        if (!StringUtil.isNullOrEmpty((String)this.profile.getAuthor())) {
            this.applySlotFeatures(EmptyLineSlot.getInstance());
            this.applySlotFeatures(CodeSlot.of(" * "));
            this.applySlotFeatures(EmptyLineSlot.getInstance());
            this.applySlotFeatures(CodeSlot.of(" * @author "));
            this.applySlotFeatures(MarkupSlot.of(SlotType.AUTHOR));
            this.applySlotFeatures(CodeSlot.of(this.profile.getAuthor()));
        }
        this.applySlotFeatures(EmptyLineSlot.getInstance());
        this.applySlotFeatures(CodeSlot.of(" */"));
        this.applySlotFeatures(EmptyLineSlot.getInstance());
        this.applySlotFeatures(MarkupSlot.of(SlotType.CLASS_START).addAttribute("table", this.tabDef));
        this.applySlotFeatures(CodeSlot.of("public class "));
        this.applySlotFeatures(MarkupSlot.of(SlotType.CLASS_NAME_START));
        this.applySlotFeatures(CodeSlot.of(this.className));
        this.applySlotFeatures(MarkupSlot.of(SlotType.CLASS_NAME_END));
        this.applySlotFeatures(CodeSlot.of(" "));
        this.applySlotFeatures(MarkupSlot.of(SlotType.EXTENDS_START));
        this.applySlotFeatures(MarkupSlot.of(SlotType.EXTENDS_END));
        this.applySlotFeatures(MarkupSlot.of(SlotType.IMPLEMENTS_START));
        this.applySlotFeatures(MarkupSlot.of(SlotType.IMPLEMENTS_END));
        this.applySlotFeatures(CodeSlot.of("{"));
        this.applySlotFeatures(MarkupSlot.of(SlotType.CLASS_FIRST_LINE));
        this.applySlotFeatures(EmptyLineSlot.getInstance());
        List<TableColumn> columns = this.tabDef.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            TableColumn column = columns.get(i);
            Pair pair = this.getTypeFeature(column.getType());
            String type = pair.getJavaTypeName();
            this.applySlotFeatures(MarkupSlot.of(SlotType.FIELD_START).addAttribute("column", column));
            this.applySlotFeatures(MarkupSlot.of(SlotType.FIELD_HEAD).addAttribute("column", column));
            this.applySlotFeatures(IndentSlot.getInstance());
            this.applySlotFeatures(CodeSlot.of("private "));
            this.applySlotFeatures(CodeSlot.of(type).addAttribute("column", column));
            this.applySlotFeatures(CodeSlot.of(" "));
            this.applySlotFeatures(MarkupSlot.of(SlotType.FIELD_NAME_START));
            column.setFieldName(GenerateUtil.camel(column.getName(), false));
            this.applySlotFeatures(CodeSlot.of(column.getFieldName()).addTag("fieldName"));
            this.applySlotFeatures(MarkupSlot.of(SlotType.FIELD_NAME_END));
            this.applySlotFeatures(CodeSlot.of(";"));
            this.applySlotFeatures(MarkupSlot.of(SlotType.FIELD_TAIL).addAttribute("column", column));
            if (i != columns.size() - 1) {
                this.applySlotFeatures(EmptyLineSlot.getInstance());
            }
            this.applySlotFeatures(MarkupSlot.of(SlotType.FIELD_END));
            if (StringUtil.isNullOrEmpty((String)pair.getImportClass())) continue;
            this.imports.add(pair.getImportClass());
        }
        this.applySlotFeatures(MarkupSlot.of(SlotType.ALL_FIELD_END));
        this.applySlotFeatures(MarkupSlot.of(SlotType.CLASS_LAST_LINE));
        this.applySlotFeatures(EmptyLineSlot.getInstance());
        this.applySlotFeatures(CodeSlot.of("}"));
        this.applySlotFeatures(MarkupSlot.of(SlotType.CLASS_END));
        return this;
    }

    public String generateContent() {
        StringBuilder sb = new StringBuilder();
        this.slots.forEach(v -> sb.append(v.getContent()));
        return sb.toString().replaceAll("\r\n", this.profile.getLineSeparator()).replaceAll("\n", this.profile.getLineSeparator());
    }

    public ClassGenerator applyFeatures() {
        if (CollectionUtil.isNullOrEmpty(this.slots)) {
            throw new IllegalStateException("\u8bf7\u5148\u8c03\u7528\u65b9\u6cd5: generateClass");
        }
        this.features.forEach(v -> v.apply(this));
        return this;
    }

    public String getTypeSimpleClassName(String type) {
        return type.substring(type.lastIndexOf(".") + 1);
    }

    public TableDefinition getTabDef() {
        return this.tabDef;
    }

    public ProfileProperties getProfile() {
        return this.profile;
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public Set<String> getImplementNames() {
        return this.implementNames;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLowerObjectName() {
        return this.lowerObjectName;
    }

    public String getUpperObjectName() {
        return this.upperObjectName;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<SlotFeature> getRuntimeFeatures() {
        return this.runtimeFeatures;
    }

    public TypeMappingFeature getTypeFeature() {
        return this.typeFeature;
    }

    public void setTabDef(TableDefinition tabDef) {
        this.tabDef = tabDef;
    }

    public void setProfile(ProfileProperties profile) {
        this.profile = profile;
    }

    public void setSlots(List<Slot> slots) {
        this.slots = slots;
    }

    public void setImports(Set<String> imports) {
        this.imports = imports;
    }

    public void setImplementNames(Set<String> implementNames) {
        this.implementNames = implementNames;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setLowerObjectName(String lowerObjectName) {
        this.lowerObjectName = lowerObjectName;
    }

    public void setUpperObjectName(String upperObjectName) {
        this.upperObjectName = upperObjectName;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public void setRuntimeFeatures(List<SlotFeature> runtimeFeatures) {
        this.runtimeFeatures = runtimeFeatures;
    }

    public void setTypeFeature(TypeMappingFeature typeFeature) {
        this.typeFeature = typeFeature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassGenerator)) {
            return false;
        }
        ClassGenerator other = (ClassGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TableDefinition this$tabDef = this.getTabDef();
        TableDefinition other$tabDef = other.getTabDef();
        if (this$tabDef == null ? other$tabDef != null : !((Object)this$tabDef).equals(other$tabDef)) {
            return false;
        }
        ProfileProperties this$profile = this.getProfile();
        ProfileProperties other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !((Object)this$profile).equals(other$profile)) {
            return false;
        }
        List<Slot> this$slots = this.getSlots();
        List<Slot> other$slots = other.getSlots();
        if (this$slots == null ? other$slots != null : !((Object)this$slots).equals(other$slots)) {
            return false;
        }
        Set<String> this$imports = this.getImports();
        Set<String> other$imports = other.getImports();
        if (this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports)) {
            return false;
        }
        Set<String> this$implementNames = this.getImplementNames();
        Set<String> other$implementNames = other.getImplementNames();
        if (this$implementNames == null ? other$implementNames != null : !((Object)this$implementNames).equals(other$implementNames)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$lowerObjectName = this.getLowerObjectName();
        String other$lowerObjectName = other.getLowerObjectName();
        if (this$lowerObjectName == null ? other$lowerObjectName != null : !this$lowerObjectName.equals(other$lowerObjectName)) {
            return false;
        }
        String this$upperObjectName = this.getUpperObjectName();
        String other$upperObjectName = other.getUpperObjectName();
        if (this$upperObjectName == null ? other$upperObjectName != null : !this$upperObjectName.equals(other$upperObjectName)) {
            return false;
        }
        List<Feature> this$features = this.getFeatures();
        List<Feature> other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        List<SlotFeature> this$runtimeFeatures = this.getRuntimeFeatures();
        List<SlotFeature> other$runtimeFeatures = other.getRuntimeFeatures();
        if (this$runtimeFeatures == null ? other$runtimeFeatures != null : !((Object)this$runtimeFeatures).equals(other$runtimeFeatures)) {
            return false;
        }
        TypeMappingFeature this$typeFeature = this.getTypeFeature();
        TypeMappingFeature other$typeFeature = other.getTypeFeature();
        return !(this$typeFeature == null ? other$typeFeature != null : !this$typeFeature.equals(other$typeFeature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TableDefinition $tabDef = this.getTabDef();
        result = result * 59 + ($tabDef == null ? 43 : ((Object)$tabDef).hashCode());
        ProfileProperties $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : ((Object)$profile).hashCode());
        List<Slot> $slots = this.getSlots();
        result = result * 59 + ($slots == null ? 43 : ((Object)$slots).hashCode());
        Set<String> $imports = this.getImports();
        result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
        Set<String> $implementNames = this.getImplementNames();
        result = result * 59 + ($implementNames == null ? 43 : ((Object)$implementNames).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $lowerObjectName = this.getLowerObjectName();
        result = result * 59 + ($lowerObjectName == null ? 43 : $lowerObjectName.hashCode());
        String $upperObjectName = this.getUpperObjectName();
        result = result * 59 + ($upperObjectName == null ? 43 : $upperObjectName.hashCode());
        List<Feature> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        List<SlotFeature> $runtimeFeatures = this.getRuntimeFeatures();
        result = result * 59 + ($runtimeFeatures == null ? 43 : ((Object)$runtimeFeatures).hashCode());
        TypeMappingFeature $typeFeature = this.getTypeFeature();
        result = result * 59 + ($typeFeature == null ? 43 : $typeFeature.hashCode());
        return result;
    }

    public String toString() {
        return "ClassGenerator(tabDef=" + this.getTabDef() + ", profile=" + this.getProfile() + ", slots=" + this.getSlots() + ", imports=" + this.getImports() + ", implementNames=" + this.getImplementNames() + ", className=" + this.getClassName() + ", lowerObjectName=" + this.getLowerObjectName() + ", upperObjectName=" + this.getUpperObjectName() + ", features=" + this.getFeatures() + ", runtimeFeatures=" + this.getRuntimeFeatures() + ", typeFeature=" + this.getTypeFeature() + ")";
    }
}

