/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.annotations.Opt;
import hs.ddif.annotations.Produces;
import hs.ddif.core.Injector;
import hs.ddif.core.config.ConfigurableAnnotationStrategy;
import hs.ddif.core.config.DirectTypeExtension;
import hs.ddif.core.config.ListTypeExtension;
import hs.ddif.core.config.ProducesInjectableExtension;
import hs.ddif.core.config.ProviderInjectableExtension;
import hs.ddif.core.config.ProviderTypeExtension;
import hs.ddif.core.config.SetTypeExtension;
import hs.ddif.core.config.discovery.DiscovererFactory;
import hs.ddif.core.config.scope.SingletonScopeResolver;
import hs.ddif.core.config.standard.AnnotationBasedLifeCycleCallbacksFactory;
import hs.ddif.core.config.standard.DefaultDiscovererFactory;
import hs.ddif.core.config.standard.DefaultInjectableFactory;
import hs.ddif.core.config.standard.InjectableExtension;
import hs.ddif.core.definition.ClassInjectableFactory;
import hs.ddif.core.definition.FieldInjectableFactory;
import hs.ddif.core.definition.InjectableFactory;
import hs.ddif.core.definition.InstanceInjectableFactory;
import hs.ddif.core.definition.LifeCycleCallbacksFactory;
import hs.ddif.core.definition.MethodInjectableFactory;
import hs.ddif.core.definition.bind.AnnotationStrategy;
import hs.ddif.core.definition.bind.BindingProvider;
import hs.ddif.core.instantiation.TypeExtension;
import hs.ddif.core.instantiation.TypeExtensionStore;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.scope.ScopeResolverManager;
import hs.ddif.core.util.Annotations;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class InjectorBuilder {
    private static final Singleton SINGLETON = (Singleton)Annotations.of(Singleton.class);
    private static final Method PROVIDER_METHOD;

    public static Builder builder() {
        return new Builder();
    }

    static {
        try {
            PROVIDER_METHOD = Provider.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Builder5 {
        private final Context5 context;

        Builder5(Context4 context, DiscovererFactory discovererFactory) {
            this.context = new Context5(context, discovererFactory);
        }

        public Injector build() {
            InstanceInjectableFactory instanceInjectableFactory = new InstanceInjectableFactory(this.context.injectableFactory, (Annotation)SINGLETON);
            HashMap<Class<Provider>, Object> typeExtensions = new HashMap<Class<Provider>, Object>();
            typeExtensions.put(List.class, new ListTypeExtension(this.context.annotationStrategy));
            typeExtensions.put(Set.class, new SetTypeExtension(this.context.annotationStrategy));
            typeExtensions.put(Provider.class, new ProviderTypeExtension(Provider.class, s -> ((Supplier)s)::get));
            TypeExtensionStore store = new TypeExtensionStore((TypeExtension)new DirectTypeExtension(this.context.annotationStrategy), typeExtensions);
            return new Injector(store, this.context.discovererFactory, instanceInjectableFactory);
        }
    }

    public static class Builder4 {
        private final Context4 context;

        Builder4(Context3 context, boolean autoDiscovery) {
            this.context = new Context4(context, autoDiscovery);
        }

        public Builder5 injectableExtensions(Function<Context4, List<InjectableExtension>> callback) {
            ArrayList<Object> injectableExtensions = new ArrayList<Object>();
            injectableExtensions.add(new ProviderInjectableExtension(this.context.methodInjectableFactory, PROVIDER_METHOD));
            injectableExtensions.add(new ProducesInjectableExtension(this.context.methodInjectableFactory, this.context.fieldInjectableFactory, Produces.class));
            injectableExtensions.addAll((Collection)callback.apply(this.context));
            return new Builder5(this.context, (DiscovererFactory)new DefaultDiscovererFactory(this.context.autoDiscovery, injectableExtensions, this.context.classInjectableFactory));
        }

        public Builder5 defaultInjectableExtensions() {
            return this.injectableExtensions(context -> List.of());
        }
    }

    public static class Builder3 {
        private final Context3 context;

        Builder3(Context2 context, LifeCycleCallbacksFactory lifeCycleCallbacksFactory, BindingProvider bindingProvider, ClassInjectableFactory classInjectableFactory, MethodInjectableFactory methodInjectableFactory, FieldInjectableFactory fieldInjectableFactory) {
            this.context = new Context3(context, lifeCycleCallbacksFactory, bindingProvider, classInjectableFactory, methodInjectableFactory, fieldInjectableFactory);
        }

        public Builder4 autoDiscovering() {
            return new Builder4(this.context, true);
        }

        public Builder4 manual() {
            return new Builder4(this.context, false);
        }
    }

    public static class Builder2 {
        private final Context2 context;

        Builder2(Context1 context, SingletonScopeResolver singletonScopeResolver, List<ScopeResolver> scopeResolvers) {
            this.context = new Context2(context, Builder2.createScopeResolverManager(singletonScopeResolver, scopeResolvers));
        }

        public Builder3 lifeCycleCallbacksFactory(Function<Context2, LifeCycleCallbacksFactory> callback) {
            LifeCycleCallbacksFactory lifeCycleCallbacksFactory = callback.apply(this.context);
            BindingProvider bindingProvider = new BindingProvider(this.context.annotationStrategy);
            ClassInjectableFactory classInjectableFactory = new ClassInjectableFactory(bindingProvider, this.context.injectableFactory, lifeCycleCallbacksFactory);
            MethodInjectableFactory methodInjectableFactory = new MethodInjectableFactory(bindingProvider, this.context.injectableFactory);
            FieldInjectableFactory fieldInjectableFactory = new FieldInjectableFactory(bindingProvider, this.context.injectableFactory);
            return new Builder3(this.context, lifeCycleCallbacksFactory, bindingProvider, classInjectableFactory, methodInjectableFactory, fieldInjectableFactory);
        }

        public Builder3 defaultLifeCycleCallbacksFactory() {
            return this.lifeCycleCallbacksFactory(context -> new AnnotationBasedLifeCycleCallbacksFactory(context.annotationStrategy, PostConstruct.class, PreDestroy.class));
        }

        private static ScopeResolverManager createScopeResolverManager(SingletonScopeResolver singletonScopeResolver, List<ScopeResolver> scopeResolvers) {
            List<SingletonScopeResolver> standardScopeResolvers = List.of(singletonScopeResolver);
            return new ScopeResolverManager((ScopeResolver[])Stream.of(scopeResolvers, standardScopeResolvers).flatMap(Collection::stream).toArray(ScopeResolver[]::new));
        }
    }

    public static class Builder1 {
        private final Context1 context;

        Builder1(AnnotationStrategy annotationStrategy) {
            this.context = new Context1(annotationStrategy);
        }

        public Builder2 scopeResolvers(Function<Context1, List<ScopeResolver>> callback) {
            return new Builder2(this.context, new SingletonScopeResolver((Annotation)SINGLETON), callback.apply(this.context));
        }

        public Builder2 defaultScopeResolvers() {
            return this.scopeResolvers(context -> List.of());
        }
    }

    public static class Context5
    extends Context4 {
        public final DiscovererFactory discovererFactory;

        Context5(Context4 context, DiscovererFactory discovererFactory) {
            super(context, context.autoDiscovery);
            this.discovererFactory = discovererFactory;
        }
    }

    public static class Context4
    extends Context3 {
        public final boolean autoDiscovery;

        Context4(Context3 context, boolean autoDiscovery) {
            super(context, context.lifeCycleCallbacksFactory, context.bindingProvider, context.classInjectableFactory, context.methodInjectableFactory, context.fieldInjectableFactory);
            this.autoDiscovery = autoDiscovery;
        }
    }

    public static class Context3
    extends Context2 {
        public final LifeCycleCallbacksFactory lifeCycleCallbacksFactory;
        public final BindingProvider bindingProvider;
        public final ClassInjectableFactory classInjectableFactory;
        public final MethodInjectableFactory methodInjectableFactory;
        public final FieldInjectableFactory fieldInjectableFactory;

        Context3(Context2 context, LifeCycleCallbacksFactory lifeCycleCallbacksFactory, BindingProvider bindingProvider, ClassInjectableFactory classInjectableFactory, MethodInjectableFactory methodInjectableFactory, FieldInjectableFactory fieldInjectableFactory) {
            super(context, context.scopeResolverManager);
            this.lifeCycleCallbacksFactory = lifeCycleCallbacksFactory;
            this.bindingProvider = bindingProvider;
            this.classInjectableFactory = classInjectableFactory;
            this.methodInjectableFactory = methodInjectableFactory;
            this.fieldInjectableFactory = fieldInjectableFactory;
        }
    }

    public static class Context2
    extends Context1 {
        public final ScopeResolverManager scopeResolverManager;
        public final InjectableFactory injectableFactory;

        Context2(Context1 context, ScopeResolverManager scopeResolverManager) {
            super(context.annotationStrategy);
            this.scopeResolverManager = scopeResolverManager;
            this.injectableFactory = new DefaultInjectableFactory(scopeResolverManager, this.annotationStrategy);
        }
    }

    public static class Context1 {
        public final AnnotationStrategy annotationStrategy;

        Context1(AnnotationStrategy annotationStrategy) {
            this.annotationStrategy = annotationStrategy;
        }
    }

    public static class Builder {
        public Builder1 annotationStrategy(AnnotationStrategy annotationStrategy) {
            return new Builder1(annotationStrategy);
        }

        public Builder1 defaultAnnotationStrategy() {
            return new Builder1((AnnotationStrategy)new ConfigurableAnnotationStrategy(Inject.class, Qualifier.class, Scope.class, Opt.class));
        }

        public Builder4 manual() {
            return this.defaultAnnotationStrategy().defaultScopeResolvers().defaultLifeCycleCallbacksFactory().manual();
        }
    }
}

