/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.core.Injector;
import hs.ddif.core.Injectors;
import hs.ddif.core.api.InstanceCreationException;
import hs.ddif.core.config.discovery.DiscoveryFailure;
import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.definition.bind.BindingException;
import hs.ddif.core.inject.store.UnresolvableDependencyException;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.test.injectables.BeanWithInjection;
import hs.ddif.core.test.injectables.BigRedBean;
import hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithEmptyAndAnnotatedConstructor;
import hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors;
import hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch;
import hs.ddif.core.test.injectables.SampleWithMultipleAnnotatedConstructors;
import hs.ddif.core.test.injectables.SampleWithoutConstructorMatch;
import hs.ddif.core.test.injectables.SimpleBean;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.junit.jupiter.api.Test;

public class InjectorDiscoveryTest {
    private Injector injector = Injectors.autoDiscovering(new ScopeResolver[0]);

    @Test
    public void shouldDiscoverNewTypes() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(BigRedBean.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(BigRedBean.class, new Object[0]));
    }

    @Test
    public void shouldDiscoverNewTypesAndDependentTypes() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(BeanWithInjection.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(BeanWithInjection.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(SimpleBean.class, new Object[0]));
    }

    @Test
    public void shouldNotDiscoverNewTypeWithoutAnyConstructorMatch() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(SampleWithDependencyOnSampleWithoutConstructorMatch.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch] instantiation failed because auto discovery was unable to resolve all dependencies; found: [Injectable[hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch]]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DiscoveryFailure.class)).hasMessage("[hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch] instantiation failed because auto discovery was unable to resolve all dependencies; found: [Injectable[hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch]]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(UnresolvableDependencyException.class)).hasMessage("Missing dependency [hs.ddif.core.test.injectables.SampleWithoutConstructorMatch] required for Field [public hs.ddif.core.test.injectables.SampleWithoutConstructorMatch hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithoutConstructorMatch.sampleWithoutConstructorMatch]").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(SampleWithDependencyOnSampleWithoutConstructorMatch.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(SampleWithoutConstructorMatch.class, new Object[0]));
    }

    @Test
    public void shouldNotDiscoverNewTypeWithMultipleConstructorMatch() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors] instantiation failed because auto discovery was unable to resolve all dependencies; found: [Injectable[hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors]]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DiscoveryFailure.class)).hasMessage("[hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors] instantiation failed because auto discovery was unable to resolve all dependencies; found: [Injectable[hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors]]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(UnresolvableDependencyException.class)).hasMessage("Missing dependency [hs.ddif.core.test.injectables.SampleWithMultipleAnnotatedConstructors] required for Field [public hs.ddif.core.test.injectables.SampleWithMultipleAnnotatedConstructors hs.ddif.core.test.injectables.SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors.sample]").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(SampleWithDependencyOnSampleWithMultipleAnnotatedConstructors.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(SampleWithMultipleAnnotatedConstructors.class, new Object[0]));
    }

    @Test
    public void shouldThrowBindingExceptionWhenAddingClassWithoutConstructorMatch() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(SampleWithoutConstructorMatch.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[hs.ddif.core.test.injectables.SampleWithoutConstructorMatch] instantiation failed because auto discovery was unable to resolve all dependencies; found: []").hasNoSuppressedExceptions().extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DiscoveryFailure.class)).hasMessage("[hs.ddif.core.test.injectables.SampleWithoutConstructorMatch] instantiation failed because auto discovery was unable to resolve all dependencies; found: []").hasNoSuppressedExceptions().extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Exception occurred during discovery via path: [hs.ddif.core.test.injectables.SampleWithoutConstructorMatch]").satisfies(throwable -> {
            Assertions.assertThat((Object[])throwable.getSuppressed()).hasSize(1);
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class hs.ddif.core.test.injectables.SampleWithoutConstructorMatch] could not be bound").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BindingException.class)).hasMessage("[class hs.ddif.core.test.injectables.SampleWithoutConstructorMatch] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoCause();
        })).hasNoCause();
    }

    @Test
    public void shouldDiscoverNewTypeWithEmptyUnannotatedConstructorAndAnnotatedConstructor() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(SampleWithDependencyOnSampleWithEmptyAndAnnotatedConstructor.class, new Object[0]));
    }

    @Test
    public void autoDiscoveryShouldNotLeaveStoreInModifiedState() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(D.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[hs.ddif.core.InjectorDiscoveryTest$D] instantiation failed because auto discovery was unable to resolve all dependencies; found: [Injectable[hs.ddif.core.InjectorDiscoveryTest$A], Injectable[hs.ddif.core.InjectorDiscoveryTest$B], Injectable[hs.ddif.core.InjectorDiscoveryTest$C], Injectable[hs.ddif.core.InjectorDiscoveryTest$D]]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DiscoveryFailure.class)).hasMessage("[hs.ddif.core.InjectorDiscoveryTest$D] instantiation failed because auto discovery was unable to resolve all dependencies; found: [Injectable[hs.ddif.core.InjectorDiscoveryTest$A], Injectable[hs.ddif.core.InjectorDiscoveryTest$B], Injectable[hs.ddif.core.InjectorDiscoveryTest$C], Injectable[hs.ddif.core.InjectorDiscoveryTest$D]]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(UnresolvableDependencyException.class)).hasMessage("Missing dependency [hs.ddif.core.InjectorDiscoveryTest$E] required for Field [hs.ddif.core.InjectorDiscoveryTest$E hs.ddif.core.InjectorDiscoveryTest$C.e]").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(A.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(B.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(C.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(D.class, new Object[0]));
    }

    @Test
    public void shouldThrowBindingExceptionWhenDiscoveredClassRequiresQualifiers() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(G.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[hs.ddif.core.InjectorDiscoveryTest$G] instantiation failed because auto discovery was unable to resolve all dependencies; found: [Injectable[hs.ddif.core.InjectorDiscoveryTest$G]]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DiscoveryFailure.class)).hasMessage("[hs.ddif.core.InjectorDiscoveryTest$G] instantiation failed because auto discovery was unable to resolve all dependencies; found: [Injectable[hs.ddif.core.InjectorDiscoveryTest$G]]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(UnresolvableDependencyException.class)).hasMessageMatching(Pattern.quote("Missing dependency [@jakarta.inject.Named(") + "(value=)?" + Pattern.quote("\"some-qualifier\") hs.ddif.core.InjectorDiscoveryTest$A] required for Field [@jakarta.inject.Named(") + "(value=)?" + Pattern.quote("\"some-qualifier\") hs.ddif.core.InjectorDiscoveryTest$A hs.ddif.core.InjectorDiscoveryTest$G.a]")).hasNoCause();
    }

    @Test
    public void shouldReturnEmptyListWhenNoInstancesOfInterfaceKnown() {
        Assertions.assertThat((List)this.injector.getInstances(E.class, new Object[0])).isEmpty();
    }

    @Test
    public void shouldReturnEmptyListWhenNoInstancesOfDiscoverableClassKnown() {
        Assertions.assertThat((List)this.injector.getInstances(A.class, new Object[0])).isEmpty();
    }

    @Test
    public void registerShouldDiscoverNewTypes() {
        this.injector.register(B.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.contains(A.class, new Object[0]));
    }

    public static class G {
        @Named(value="some-qualifier")
        @Inject
        A a;
    }

    static interface F {
    }

    static interface E {
    }

    public static class D {
        @Inject
        B b;
        @Inject
        C c;
    }

    public static class C {
        @Inject
        A a;
        @Inject
        E e;
        @Inject
        F f;
    }

    public static class B {
        @Inject
        A a;
    }

    public static class A {
    }
}

