/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.core.Injector;
import hs.ddif.core.Injectors;
import hs.ddif.core.inject.store.ViolatesSingularDependencyException;
import hs.ddif.core.scope.ScopeResolver;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InjectorGenericsTest {
    private Injector injector;

    @BeforeEach
    public void beforeEach() {
        this.injector = Injectors.manual(new ScopeResolver[0]);
    }

    @Test
    public void shouldInjectInstancesWithMatchingGenerics() {
        this.injector.register(StringToIntConverter.class);
        this.injector.register(IntToStringConverter.class);
        this.injector.register(StringToStringListConverter.class);
        this.injector.register(InjectableWithConverters.class);
        InjectableWithConverters instance = (InjectableWithConverters)this.injector.getInstance(InjectableWithConverters.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)12345, (int)instance.convertToInt("12345"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"12", (Object)instance.convertToString(12));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("a");
                this.add("b");
                this.add("c");
            }
        }, instance.convertToStringList("a,b,c"));
    }

    @Test
    public void shouldInjectProviderInstancesWithMatchingGenerics() {
        this.injector.register(StringToIntConverter.class);
        this.injector.register(IntToStringConverter.class);
        this.injector.register(StringToStringListConverter.class);
        this.injector.register(InjectableWithConverterProviders.class);
        InjectableWithConverterProviders instance = (InjectableWithConverterProviders)this.injector.getInstance(InjectableWithConverterProviders.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)12345, (int)instance.convertToInt("12345"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"12", (Object)instance.convertToString(12));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("a");
                this.add("b");
                this.add("c");
            }
        }, instance.convertToStringList("a,b,c"));
    }

    @Test
    public void shouldInjectListInstancesWithMatchingGenerics() {
        this.injector.register(StringToIntConverter.class);
        this.injector.register(IntToStringConverter.class);
        this.injector.register(StringToStringListConverter.class);
        this.injector.register(InjectableWithConverterLists.class);
        InjectableWithConverterLists instance = (InjectableWithConverterLists)this.injector.getInstance(InjectableWithConverterLists.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)12345, (int)instance.convertToInt("12345"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"12", (Object)instance.convertToString(12));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new ArrayList<String>(){
            {
                this.add("a");
                this.add("b");
                this.add("c");
            }
        }, instance.convertToStringList("a,b,c"));
    }

    @Test
    public void shouldNotViolateSingularDependencies() {
        this.injector.register(StringToIntConverter.class);
        this.injector.register(IntToStringConverter.class);
        this.injector.register(StringToStringListConverter.class);
        this.injector.register(InjectableWithConverters.class);
        Assertions.assertThatThrownBy(() -> this.injector.remove(StringToIntConverter.class)).isExactlyInstanceOf(ViolatesSingularDependencyException.class);
    }

    public static class IntToStringConverter
    implements Converter<Integer, String> {
        @Override
        public String convert(Integer from) {
            return "" + from;
        }
    }

    public static class StringToStringListConverter
    implements Converter<String, List<String>> {
        @Override
        public List<String> convert(String from) {
            return Arrays.asList(from.split(","));
        }
    }

    public static class StringToIntConverter
    implements Converter<String, Integer> {
        @Override
        public Integer convert(String from) {
            return Integer.parseInt(from);
        }
    }

    public static interface Converter<F, T> {
        public T convert(F var1);
    }

    public static class InjectableWithConverterLists {
        @Inject
        private List<Converter<String, Integer>> stringToIntConverter;
        @Inject
        private List<Converter<Integer, String>> intToStringConverter;
        @Inject
        private List<Converter<String, List<String>>> stringToStringListConverter;

        public Integer convertToInt(String s) {
            return this.stringToIntConverter.get(0).convert(s);
        }

        public String convertToString(int input) {
            return this.intToStringConverter.get(0).convert(input);
        }

        public List<String> convertToStringList(String s) {
            return this.stringToStringListConverter.get(0).convert(s);
        }
    }

    public static class InjectableWithConverterProviders {
        @Inject
        private Provider<Converter<String, Integer>> stringToIntConverter;
        @Inject
        private Provider<Converter<Integer, String>> intToStringConverter;
        @Inject
        private Provider<Converter<String, List<String>>> stringToStringListConverter;

        public Integer convertToInt(String s) {
            return (Integer)((Converter)this.stringToIntConverter.get()).convert(s);
        }

        public String convertToString(int input) {
            return (String)((Converter)this.intToStringConverter.get()).convert(input);
        }

        public List<String> convertToStringList(String s) {
            return (List)((Converter)this.stringToStringListConverter.get()).convert(s);
        }
    }

    public static class InjectableWithConverters {
        @Inject
        private Converter<String, Integer> stringToIntConverter;
        @Inject
        private Converter<Integer, String> intToStringConverter;
        @Inject
        private Converter<String, List<String>> stringToStringListConverter;

        public Integer convertToInt(String s) {
            return this.stringToIntConverter.convert(s);
        }

        public String convertToString(int input) {
            return this.intToStringConverter.convert(input);
        }

        public List<String> convertToStringList(String s) {
            return this.stringToStringListConverter.convert(s);
        }
    }
}

