/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.core.Injector;
import hs.ddif.core.Injectors;
import hs.ddif.core.scope.ScopeResolver;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class InjectorPrimitivesTest {
    private Injector injector = Injectors.manual(new ScopeResolver[0]);

    @Test
    void injectionsShouldWorkWithPrimitives() {
        this.injector.registerInstance((Object)7, new Annotation[0]);
        this.injector.registerInstance((Object)2.5, new Annotation[0]);
        this.injector.registerInstance((Object)true, new Annotation[0]);
        this.injector.registerInstance((Object)11, new Annotation[0]);
        this.injector.register(A.class);
        this.injector.register(B.class);
        Assertions.assertThat((double)((A)this.injector.getInstance(A.class, new Object[0])).calculate()).isEqualTo(23.0);
        Assertions.assertThat((double)((B)this.injector.getInstance(B.class, new Object[0])).calculate()).isEqualTo(23.0);
    }

    static class B {
        @Inject
        Integer i;
        @Inject
        Double d;
        private Byte b;
        private Boolean flag;

        @Inject
        B(Byte b, Boolean flag) {
            this.b = b;
            this.flag = flag;
        }

        double calculate() {
            return this.d * (double)this.i.intValue() + (double)this.b.byteValue() / (this.flag != false ? 2.0 : 1.5);
        }
    }

    static class A {
        @Inject
        int i;
        @Inject
        double d;
        private byte b;
        private boolean flag;

        @Inject
        A(byte b, boolean flag) {
            this.b = b;
            this.flag = flag;
        }

        double calculate() {
            return this.d * (double)this.i + (double)this.b / (this.flag ? 2.0 : 1.5);
        }
    }
}

