/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.annotations.Opt;
import hs.ddif.annotations.Produces;
import hs.ddif.core.Injector;
import hs.ddif.core.Injectors;
import hs.ddif.core.api.NoSuchInstanceException;
import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.inject.store.UnresolvableDependencyException;
import hs.ddif.core.inject.store.ViolatesSingularDependencyException;
import hs.ddif.core.instantiation.domain.NoSuchInstance;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.store.DuplicateKeyException;
import hs.ddif.core.store.FilteredKeyException;
import hs.ddif.core.util.Annotations;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class InjectorProviderTest {
    private Injector injector = Injectors.manual(new ScopeResolver[0]);

    @Test
    public void optionalSuppliersShouldBreakCircularDependenciesAndAllowDelayedRegistration() {
        this.injector.register(BeanWithOptionalSupplier.class);
        BeanWithOptionalSupplier instance = (BeanWithOptionalSupplier)this.injector.getInstance(BeanWithOptionalSupplier.class, new Object[0]);
        Assertions.assertThat((Object)instance.getSimpleBean()).isNull();
        this.injector.register(SimpleBean.class);
        org.junit.jupiter.api.Assertions.assertEquals(SimpleBean.class, instance.getSimpleBean().getClass());
    }

    @Test
    public void providersShouldBreakCircularDependenciesOnly() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(BeanWithSupplier.class)).isExactlyInstanceOf(UnresolvableDependencyException.class)).hasMessage("Missing dependency [hs.ddif.core.InjectorProviderTest$SimpleBean] required for Field [private jakarta.inject.Provider<hs.ddif.core.InjectorProviderTest$SimpleBean> hs.ddif.core.InjectorProviderTest$BeanWithSupplier.simpleBeanSupplier]").hasNoCause();
        this.injector.register(SimpleBean.class);
        this.injector.register(BeanWithSupplier.class);
        BeanWithSupplier instance = (BeanWithSupplier)this.injector.getInstance(BeanWithSupplier.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals(SimpleBean.class, instance.getSimpleBean().getClass());
    }

    @Test
    public void getInstanceShouldReturnInjectedSupplierClass() {
        Provider<Connection> anonymousSupplier = new Provider<Connection>(){

            public Connection get() {
                return null;
            }
        };
        this.injector.registerInstance((Object)anonymousSupplier, new Annotation[0]);
        this.injector.registerInstance((Object)true, new Annotation[]{Annotations.of(Named.class, Map.of("value", "db.readonly"))});
        for (int i = 0; i < 2; ++i) {
            this.injector.register(DatabaseSupplier.class);
            org.junit.jupiter.api.Assertions.assertEquals(DatabaseSupplier.class, ((DatabaseSupplier)this.injector.getInstance(DatabaseSupplier.class, new Object[0])).getClass());
            org.junit.jupiter.api.Assertions.assertEquals(Database.class, ((Database)this.injector.getInstance(Database.class, new Object[0])).getClass());
            Assertions.assertThat((List)this.injector.getInstances(Provider.class, new Object[0])).isEmpty();
            this.injector.remove(DatabaseSupplier.class);
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(DatabaseSupplier.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class)).extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasNoCause();
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(Database.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class)).extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasNoCause();
        }
    }

    @Test
    public void getInstanceShouldReturnInjectableFromSupplierInstance() {
        this.injector.registerInstance((Object)new SimpleDatabaseSupplier(), new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertEquals(Database.class, ((Database)this.injector.getInstance(Database.class, new Object[0])).getClass());
    }

    @Test
    public void classRegistrationShouldFailWhenImplicitSupplierWouldViolatesDependencies() {
        for (int i = 0; i < 2; ++i) {
            SimpleDatabaseSupplier provider = new SimpleDatabaseSupplier();
            this.injector.registerInstance((Object)provider, new Annotation[0]);
            this.injector.register(BeanWithDatabase.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(SimpleDatabaseSupplier.class)).isExactlyInstanceOf(DuplicateKeyException.class)).hasMessage("[hs.ddif.core.InjectorProviderTest$Database] is already present").hasNoCause();
            org.junit.jupiter.api.Assertions.assertEquals(BeanWithDatabase.class, ((BeanWithDatabase)this.injector.getInstance(BeanWithDatabase.class, new Object[0])).getClass());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.removeInstance((Object)provider)).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasMessage("[hs.ddif.core.InjectorProviderTest$Database] is only provided by: class hs.ddif.core.InjectorProviderTest$Database").hasNoCause();
            this.injector.remove(BeanWithDatabase.class);
            this.injector.removeInstance((Object)provider);
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(BeanWithDatabase.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class)).hasMessage("No such instance: [hs.ddif.core.InjectorProviderTest$BeanWithDatabase]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasMessage("No such instance: [hs.ddif.core.InjectorProviderTest$BeanWithDatabase]").hasNoCause();
        }
    }

    @Test
    public void classRemovalShouldFailWhenImplicitSupplierRemovalWouldViolatesDependencies() {
        for (int i = 0; i < 2; ++i) {
            this.injector.register(SimpleDatabaseSupplier.class);
            this.injector.register(BeanWithDatabase.class);
            org.junit.jupiter.api.Assertions.assertEquals(BeanWithDatabase.class, ((BeanWithDatabase)this.injector.getInstance(BeanWithDatabase.class, new Object[0])).getClass());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.remove(SimpleDatabaseSupplier.class)).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasMessage("[hs.ddif.core.InjectorProviderTest$Database] is only provided by: class hs.ddif.core.InjectorProviderTest$Database").hasNoCause();
            org.junit.jupiter.api.Assertions.assertEquals(BeanWithDatabase.class, ((BeanWithDatabase)this.injector.getInstance(BeanWithDatabase.class, new Object[0])).getClass());
            this.injector.remove(BeanWithDatabase.class);
            this.injector.remove(SimpleDatabaseSupplier.class);
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(BeanWithDatabase.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class)).hasMessage("No such instance: [hs.ddif.core.InjectorProviderTest$BeanWithDatabase]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasMessage("No such instance: [hs.ddif.core.InjectorProviderTest$BeanWithDatabase]").hasNoCause();
        }
    }

    @Test
    public void getInstanceShouldReturnInstanceInjectedWithSupplierOfList() {
        this.injector.register(BeanWithProvidedListOfString.class);
        this.injector.registerInstance((Object)"a", new Annotation[0]);
        this.injector.registerInstance((Object)"b", new Annotation[0]);
        BeanWithProvidedListOfString bean = (BeanWithProvidedListOfString)this.injector.getInstance(BeanWithProvidedListOfString.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)bean.getTexts().size());
        this.injector.registerInstance((Object)"c", new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)bean.getTexts().size());
    }

    @Test
    public void nestedSuppliersShouldNotBeAllowed() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new NestedDatabaseSupplier(), new Annotation[0])).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[Injectable[jakarta.inject.Provider<jakarta.inject.Provider<hs.ddif.core.InjectorProviderTest$Database>> <- public jakarta.inject.Provider hs.ddif.core.InjectorProviderTest$NestedDatabaseSupplier.get()]] cannot be registered as its type conflicts with a TypeExtension for interface jakarta.inject.Provider").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(FilteredKeyException.class)).hasMessage("[jakarta.inject.Provider<jakarta.inject.Provider<hs.ddif.core.InjectorProviderTest$Database>>] cannot be added to or removed from the store as it matched the class filter").hasNoCause();
    }

    @Test
    public void producerFieldProducingSupplierShouldNotBeAllowed() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(SupplierFieldProducer.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[Injectable[jakarta.inject.Provider<hs.ddif.core.InjectorProviderTest$Database> <- private static jakarta.inject.Provider hs.ddif.core.InjectorProviderTest$SupplierFieldProducer.product]] cannot be registered as its type conflicts with a TypeExtension for interface jakarta.inject.Provider").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(FilteredKeyException.class)).hasMessage("[jakarta.inject.Provider<hs.ddif.core.InjectorProviderTest$Database>] cannot be added to or removed from the store as it matched the class filter").hasNoCause();
    }

    @Test
    public void producerMethodProducingSupplierShouldNotBeAllowed() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(SupplierMethodProducer.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[Injectable[jakarta.inject.Provider<hs.ddif.core.InjectorProviderTest$Database> <- private static jakarta.inject.Provider hs.ddif.core.InjectorProviderTest$SupplierMethodProducer.product()]] cannot be registered as its type conflicts with a TypeExtension for interface jakarta.inject.Provider").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(FilteredKeyException.class)).hasMessage("[jakarta.inject.Provider<hs.ddif.core.InjectorProviderTest$Database>] cannot be added to or removed from the store as it matched the class filter").hasNoCause();
    }

    @Test
    public void registerShouldThrowExceptionWhenDatabaseIsCreatedAndProvided() {
        this.injector.registerInstance((Object)new Database("jdbc:localhost"), new Annotation[0]);
        this.injector.register(BeanWithDatabase.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(SimpleDatabaseSupplier.class)).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasMessage("[hs.ddif.core.InjectorProviderTest$Database] would be provided again by: class hs.ddif.core.InjectorProviderTest$Database").hasNoCause();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(SimpleDatabaseSupplier.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class)).hasMessage("No such instance: [hs.ddif.core.InjectorProviderTest$SimpleDatabaseSupplier]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasMessage("No such instance: [hs.ddif.core.InjectorProviderTest$SimpleDatabaseSupplier]").hasNoCause();
    }

    @Test
    public void registerShouldThrowExceptionWhenDatabaseIsCreatedAndProvided2() {
        this.injector.register(SimpleDatabaseSupplier.class);
        this.injector.register(BeanWithDatabase.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new Database("jdbc:localhost"), new Annotation[0])).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasMessage("[hs.ddif.core.InjectorProviderTest$Database] would be provided again by: class hs.ddif.core.InjectorProviderTest$Database").hasNoCause();
    }

    @Test
    public void registerShouldThrowExceptionWhenDatabaseIsInstancedAndProvided() {
        this.injector.registerInstance((Object)new Database("jdbc:localhost"), new Annotation[0]);
        this.injector.register(BeanWithDatabase.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new SimpleDatabaseSupplier(), new Annotation[0])).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasMessage("[hs.ddif.core.InjectorProviderTest$Database] would be provided again by: class hs.ddif.core.InjectorProviderTest$Database").hasNoCause();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(SimpleDatabaseSupplier.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class)).hasMessage("No such instance: [hs.ddif.core.InjectorProviderTest$SimpleDatabaseSupplier]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasMessage("No such instance: [hs.ddif.core.InjectorProviderTest$SimpleDatabaseSupplier]").hasNoCause();
    }

    @Test
    public void registerShouldThrowExceptionWhenDatabaseIsInstancedAndProvided2() {
        this.injector.registerInstance((Object)new SimpleDatabaseSupplier(), new Annotation[0]);
        this.injector.register(BeanWithDatabase.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new Database("jdbc:localhost"), new Annotation[0])).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasMessage("[hs.ddif.core.InjectorProviderTest$Database] would be provided again by: class hs.ddif.core.InjectorProviderTest$Database").hasNoCause();
    }

    @Test
    public void registrationAndUnregistrationOfInterfaceSupplierShouldWork() {
        for (int i = 0; i < 2; ++i) {
            this.injector.register(AppendableSupplier.class);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(AppendableSupplier.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(AppendableSupplier.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(Appendable.class, new Object[0]));
            this.injector.remove(AppendableSupplier.class);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(AppendableSupplier.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertThrows(NoSuchInstanceException.class, () -> this.injector.getInstance(AppendableSupplier.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertThrows(NoSuchInstanceException.class, () -> this.injector.getInstance(Appendable.class, new Object[0]));
        }
    }

    @Test
    public void providersShouldRespectQualifiers() {
        this.injector.register(A.class);
        this.injector.register(B.class);
        this.injector.register(C.class);
        Assertions.assertThat((List)this.injector.getInstances(Z.class, new Object[0])).hasSize(3);
        Assertions.assertThat((Object)((Z)this.injector.getInstance(Z.class, new Object[]{Red.class}))).isExactlyInstanceOf(Z.class);
        Assertions.assertThat((Object)((Z)this.injector.getInstance(Z.class, new Object[]{Green.class}))).isExactlyInstanceOf(Z.class);
        Assertions.assertThat((Object)((Z)this.injector.getInstance(Z.class, new Object[]{Big.class}))).isExactlyInstanceOf(Z.class);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(Z.class, new Object[]{Small.class})).isExactlyInstanceOf(NoSuchInstanceException.class)).extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasNoCause();
        this.injector.register(X.class);
        X x = (X)this.injector.getInstance(X.class, new Object[0]);
        Assertions.assertThat(x.red).isNotNull();
        Assertions.assertThat(x.green).isNotNull();
        Assertions.assertThat((String)((Z)x.red.get()).name).isEqualTo("red");
        Assertions.assertThat((String)((Z)x.green.get()).name).isEqualTo("green");
    }

    @Test
    public void multipleSuppliersOfSameTypeShouldReturnMultipleInstances() {
        this.injector.register(B.class);
        this.injector.register(E.class);
        Assertions.assertThat((List)this.injector.getInstances(Z.class, new Object[0])).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        this.injector.register(W.class);
        W w = (W)this.injector.getInstance(W.class, new Object[0]);
        Assertions.assertThat(w.zs).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.zList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat(w.reds).isEmpty();
        Assertions.assertThat(w.zReds).isEmpty();
        Assertions.assertThat((List)((List)w.redList.get())).isEmpty();
        Assertions.assertThat((List)((List)w.zRedList.get())).isEmpty();
        Assertions.assertThat(w.greens).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat(w.zGreens).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.greenList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.zGreenList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
    }

    @Test
    public void multipleProducersOfSameTypeShouldReturnMultipleInstances() {
        this.injector.register(V.class);
        Assertions.assertThat((List)this.injector.getInstances(Z.class, new Object[0])).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        this.injector.register(W.class);
        W w = (W)this.injector.getInstance(W.class, new Object[0]);
        Assertions.assertThat(w.zs).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.zList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat(w.reds).isEmpty();
        Assertions.assertThat(w.zReds).isEmpty();
        Assertions.assertThat((List)((List)w.redList.get())).isEmpty();
        Assertions.assertThat((List)((List)w.zRedList.get())).isEmpty();
        Assertions.assertThat(w.greens).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat(w.zGreens).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.greenList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.zGreenList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
    }

    @Test
    public void providerShouldRespectScope() {
        this.injector.register(B.class);
        this.injector.register(C.class);
        this.injector.register(D.class);
        this.injector.register(P.class);
        this.injector.register(Q.class);
        this.injector.register(R.class);
        P p1 = (P)this.injector.getInstance(P.class, new Object[0]);
        Q q1 = (Q)this.injector.getInstance(Q.class, new Object[0]);
        R r1 = (R)this.injector.getInstance(R.class, new Object[0]);
        P p2 = (P)this.injector.getInstance(P.class, new Object[0]);
        Q q2 = (Q)this.injector.getInstance(Q.class, new Object[0]);
        R r2 = (R)this.injector.getInstance(R.class, new Object[0]);
        Assertions.assertThat((Object)p1.y).isNotEqualTo((Object)q1.y);
        Assertions.assertThat((Object)p1.y).isNotEqualTo((Object)r1.y);
        Assertions.assertThat((Object)q1.y).isNotEqualTo((Object)r1.y);
        Assertions.assertThat((Object)p1.y).isNotEqualTo((Object)p2.y);
        Assertions.assertThat((Object)q1.y).isNotEqualTo((Object)q2.y);
        Assertions.assertThat((Object)r1.y).isNotEqualTo((Object)r2.y);
        Assertions.assertThat((Object)p1.z).isEqualTo((Object)q1.z);
        Assertions.assertThat((Object)p1.z).isNotEqualTo((Object)r1.z);
        Assertions.assertThat((Object)q1.z).isNotEqualTo((Object)r1.z);
        Assertions.assertThat((Object)p1.z).isEqualTo((Object)p2.z);
        Assertions.assertThat((Object)q1.z).isEqualTo((Object)q2.z);
        Assertions.assertThat((Object)r1.z).isNotEqualTo((Object)r2.z);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Small {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Big {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Green {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Red {
    }

    public static class BeanWithSupplier {
        @Inject
        private Provider<SimpleBean> simpleBeanSupplier;

        public SimpleBean getSimpleBean() {
            return (SimpleBean)this.simpleBeanSupplier.get();
        }
    }

    @Singleton
    public static class SimpleBean {
    }

    public static class BeanWithOptionalSupplier {
        @Inject
        @Opt
        private Provider<SimpleBean> simpleBeanSupplier;

        public SimpleBean getSimpleBean() {
            return (SimpleBean)this.simpleBeanSupplier.get();
        }
    }

    static class PrimitivesA {
        @Inject
        Provider<Integer> i;
        @Inject
        Provider<Double> d;
        private Provider<Byte> b;
        private Provider<Boolean> flag;

        @Inject
        PrimitivesA(Provider<Byte> b, Provider<Boolean> flag) {
            this.b = b;
            this.flag = flag;
        }

        double calculate() {
            return (Double)this.d.get() * (double)((Integer)this.i.get()).intValue() + (double)((Byte)this.b.get()).byteValue() / ((Boolean)this.flag.get() != false ? 2.0 : 1.5);
        }
    }

    @Nested
    class WhenInjectorContainsPrimitiveValues {
        WhenInjectorContainsPrimitiveValues() {
            InjectorProviderTest.this.injector.registerInstance((Object)7, new Annotation[0]);
            InjectorProviderTest.this.injector.registerInstance((Object)2.5, new Annotation[0]);
            InjectorProviderTest.this.injector.registerInstance((Object)true, new Annotation[0]);
            InjectorProviderTest.this.injector.registerInstance((Object)11, new Annotation[0]);
        }

        @Test
        void shouldInjectSuppliersWithCorrespondingPrimitives() {
            InjectorProviderTest.this.injector.register(PrimitivesA.class);
            Assertions.assertThat((double)((PrimitivesA)InjectorProviderTest.this.injector.getInstance(PrimitivesA.class, new Object[0])).calculate()).isEqualTo(23.0);
        }
    }

    public static class Z {
        public final String name;

        public Z(String name) {
            this.name = name;
        }
    }

    public static class Y {
    }

    public static class X {
        @Inject
        @Red
        Provider<Z> red;
        @Inject
        @Green
        Provider<Z> green;
    }

    public static class W {
        @Inject
        List<Z> zs;
        @Inject
        Provider<List<Z>> zList;
        @Inject
        @Green
        List<?> greens;
        @Inject
        @Green
        List<Z> zGreens;
        @Inject
        @Green
        Provider<List<?>> greenList;
        @Inject
        @Green
        Provider<List<Z>> zGreenList;
        @Inject
        @Red
        List<?> reds;
        @Inject
        @Red
        List<Z> zReds;
        @Inject
        @Red
        Provider<List<?>> redList;
        @Inject
        @Red
        Provider<List<Z>> zRedList;
    }

    public static class V {
        @Produces
        @Green
        Z z1 = new Z("green");
        @Produces
        @Green
        Z z2 = new Z("light green");
    }

    public static class R {
        @Inject
        Y y;
        @Inject
        @Green
        Z z;
    }

    public static class Q {
        @Inject
        Y y;
        @Inject
        @Big
        Z z;
    }

    public static class P {
        @Inject
        Y y;
        @Inject
        @Big
        Z z;
    }

    public static class E
    implements Provider<Z> {
        @Green
        public Z get() {
            return new Z("light green");
        }
    }

    public static class D
    implements Provider<Y> {
        public Y get() {
            return new Y();
        }
    }

    @Singleton
    public static class C
    implements Provider<Z> {
        @Big
        @Singleton
        public Z get() {
            return new Z("big");
        }
    }

    public static class B
    implements Provider<Z> {
        @Green
        public Z get() {
            return new Z("green");
        }
    }

    public static class A
    implements Provider<Z> {
        @Red
        public Z get() {
            return new Z("red");
        }
    }

    public static class AppendableSupplier
    implements Provider<Appendable> {
        public Appendable get() {
            return new Appendable(){

                @Override
                public Appendable append(CharSequence csq) {
                    return null;
                }

                @Override
                public Appendable append(CharSequence csq, int start, int end) {
                    return null;
                }

                @Override
                public Appendable append(char c) {
                    return null;
                }
            };
        }
    }

    public static class SupplierMethodProducer {
        @Produces
        private static Provider<Database> product() {
            return null;
        }
    }

    public static class SupplierFieldProducer {
        @Produces
        private static Provider<Database> product;
    }

    public static class DatabaseSupplier
    implements Provider<Database> {
        @Inject
        public DatabaseSupplier(Provider<Connection> cls, @Named(value="db.readonly") boolean readOnly) {
        }

        public Database get() {
            return new Database("jdbc:localhost");
        }
    }

    public static class SimpleDatabaseSupplier
    implements Provider<Database> {
        public Database get() {
            return new Database("jdbc:localhost");
        }
    }

    public static class NestedDatabaseSupplier
    implements Provider<Provider<Provider<Database>>> {
        public Provider<Provider<Database>> get() {
            return new Provider<Provider<Database>>(){

                public Provider<Database> get() {
                    return new SimpleDatabaseSupplier();
                }
            };
        }
    }

    public static class Database {
        public Database(String url) {
        }
    }

    public static class BeanWithProvidedDatabase {
        @Inject
        Provider<Database> database;
    }

    public static class BeanWithDatabase {
        @Inject
        Database database;
    }

    public static class BeanWithProvidedListOfString {
        @Inject
        private Provider<List<String>> texts;

        List<String> getTexts() {
            return (List)this.texts.get();
        }
    }
}

