/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.annotations.Produces;
import hs.ddif.core.Injector;
import hs.ddif.core.Injectors;
import hs.ddif.core.api.InstanceCreationException;
import hs.ddif.core.api.NoSuchInstanceException;
import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.inject.store.ScopeConflictException;
import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.scope.AbstractScopeResolver;
import hs.ddif.core.scope.OutOfScopeException;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.test.scope.TestScope;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class InjectorScopeTest {
    @Test
    public void shouldKeepSameTypesWithDifferentQualifiersSeparated() {
        TestScopeResolver scopeResolver = new TestScopeResolver();
        Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
        injector.register(Producers.class);
        Assertions.assertThat((List)injector.getInstances(String.class, new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{"a", "b"});
    }

    @Singleton
    @TestScope
    public static class IllegalMultiScopedBean {
        @Inject
        TestScopedBean testScopedBean;
    }

    @Singleton
    public static class IllegalSingletonBean {
        @Inject
        TestScopedBean testScopedBean;
    }

    @TestScope
    public static class SomeUserBeanWithTestScope2 {
        @Inject
        UnscopedBean unscopedBean;
    }

    @TestScope
    public static class SomeUserBeanWithTestScope {
        @Inject
        TestScopedBean testScopedBean;
    }

    public static class SomeUserBean {
        @Inject
        TestScopedBean testScopedBean;
    }

    public static class UnscopedBean {
    }

    @TestScope
    public static class TestScopedBean {
    }

    static class TestScopeResolver
    extends AbstractScopeResolver<String> {
        public String currentScope = "default";

        TestScopeResolver() {
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return TestScope.class;
        }

        public String getCurrentScope() {
            return this.currentScope;
        }
    }

    public static class Producers {
        @Produces
        @TestScope
        @Named(value="a")
        static String a = "a";
        @Produces
        @TestScope
        @Named(value="b")
        static String b = "b";
    }

    public static class XProvider
    implements Provider<X> {
        public X get() {
            return null;
        }
    }

    @Singleton
    public static class SingletonBeanDependentOnXProvider {
        @Inject
        Provider<X> xProvider;
    }

    public static class PrototypeBeanDependantOnXProvider {
        @Inject
        Provider<X> xProvider;
    }

    @Singleton
    public static class SingletonBeanDependentOnX {
        @Inject
        X x;
    }

    public static class PrototypeBeanDependantOnX {
        @Inject
        X x;
    }

    public static class X {
    }

    @Singleton
    public static class S {
    }

    @Nested
    class Providers {
        Providers() {
        }

        @Test
        public void shouldRegisterSingletonBeanDependentOnXWhenXIsProvidedAsSingleton() {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new X(), new Annotation[0]);
            injector.register(SingletonBeanDependentOnX.class);
        }

        @Test
        public void shouldRegisterPrototypeBeanDependentOnXWhenXIsProvidedAsPrototype() {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new XProvider(), new Annotation[0]);
            injector.register(PrototypeBeanDependantOnX.class);
        }

        @Test
        public void shouldRegisterPrototypeBeanDependentOnXWhenXIsProvidedAsSingleton() {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new X(), new Annotation[0]);
            injector.register(PrototypeBeanDependantOnX.class);
        }

        @Test
        public void shouldRegisterSingletonBeanDependentOnXWhenXIsProvidedAsPrototype() {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new XProvider(), new Annotation[0]);
            injector.register(SingletonBeanDependentOnX.class);
        }

        @Test
        public void shouldRegisterSingletonBeanDependentOnXProviderWhenXIsProvidedAsSingleton() {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new X(), new Annotation[0]);
            injector.register(SingletonBeanDependentOnXProvider.class);
        }

        @Test
        public void shouldRegisterPrototypeBeanDependentOnXProviderWhenXIsProvidedAsPrototype() {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new XProvider(), new Annotation[0]);
            injector.register(PrototypeBeanDependantOnXProvider.class);
        }

        @Test
        public void shouldRegisterPrototypeBeanDependentOnXProviderWhenXIsProvidedAsSingleton() {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new X(), new Annotation[0]);
            injector.register(PrototypeBeanDependantOnXProvider.class);
        }

        @Test
        public void shouldRegisterSingletonBeanDependentOnXProviderWhenXIsProvidedAsPrototype() {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.registerInstance((Object)new XProvider(), new Annotation[0]);
            injector.register(SingletonBeanDependentOnXProvider.class);
        }
    }

    @Nested
    class Classes {
        Classes() {
        }

        @Test
        public void shouldThrowOutOfScopeExceptionWhenNoScopeActive() {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            scopeResolver.currentScope = null;
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> injector.getInstance(TestScopedBean.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[class hs.ddif.core.InjectorScopeTest$TestScopedBean] could not be created").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(InstanceCreationFailure.class)).hasMessage("[class hs.ddif.core.InjectorScopeTest$TestScopedBean] could not be created").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(OutOfScopeException.class)).hasMessage("Scope not active: interface hs.ddif.core.test.scope.TestScope for: Injectable[hs.ddif.core.InjectorScopeTest$TestScopedBean]").hasNoCause();
        }

        @Test
        public void shouldRemoveInstancesFromScopeResolver() {
            Injector injector = Injectors.manual(new ScopeResolver[0]);
            injector.register(S.class);
            S instance1 = (S)injector.getInstance(S.class, new Object[0]);
            S instance2 = (S)injector.getInstance(S.class, new Object[0]);
            Assertions.assertThat((Object)instance1).isEqualTo((Object)instance2);
            injector.remove(S.class);
            Assertions.assertThatThrownBy(() -> injector.getInstance(S.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class);
            injector.register(S.class);
            S instance3 = (S)injector.getInstance(S.class, new Object[0]);
            S instance4 = (S)injector.getInstance(S.class, new Object[0]);
            Assertions.assertThat((Object)instance3).isEqualTo((Object)instance4);
            Assertions.assertThat((Object)instance3).isNotEqualTo((Object)instance1);
        }

        @Test
        public void shouldKeepScopesSeparated() {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            injector.register(SomeUserBeanWithTestScope.class);
            SomeUserBeanWithTestScope testScopedBean1 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            SomeUserBeanWithTestScope testScopedBean2 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            scopeResolver.currentScope = "a";
            SomeUserBeanWithTestScope testScopedBean3 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            scopeResolver.currentScope = "b";
            SomeUserBeanWithTestScope testScopedBean4 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            scopeResolver.currentScope = "a";
            SomeUserBeanWithTestScope testScopedBean5 = (SomeUserBeanWithTestScope)injector.getInstance(SomeUserBeanWithTestScope.class, new Object[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)testScopedBean1, (Object)testScopedBean2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)testScopedBean3, (Object)testScopedBean5);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean3);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean4);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean5);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean3, (Object)testScopedBean4);
        }

        @Test
        public void shouldKeepScopesSeparatedInReferences() {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            injector.register(SomeUserBean.class);
            TestScopedBean testScopedBean1 = ((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean;
            TestScopedBean testScopedBean2 = ((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean;
            scopeResolver.currentScope = "a";
            TestScopedBean testScopedBean3 = ((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean;
            scopeResolver.currentScope = "b";
            TestScopedBean testScopedBean4 = ((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean;
            scopeResolver.currentScope = "a";
            TestScopedBean testScopedBean5 = ((SomeUserBean)injector.getInstance(SomeUserBean.class, (Object[])new Object[0])).testScopedBean;
            org.junit.jupiter.api.Assertions.assertEquals((Object)testScopedBean1, (Object)testScopedBean2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)testScopedBean3, (Object)testScopedBean5);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean3);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean4);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean1, (Object)testScopedBean5);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)testScopedBean3, (Object)testScopedBean4);
        }

        @Test
        public void shouldThrowExceptionWhenNarrowScopedBeansAreInjectedIntoBroaderScopedBeans() {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            Assertions.assertThatThrownBy(() -> injector.register(IllegalSingletonBean.class)).isExactlyInstanceOf(ScopeConflictException.class);
        }

        @Test
        public void shouldAllowInjectingUnscopedInstancesAlways() {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(UnscopedBean.class);
            injector.register(SomeUserBeanWithTestScope2.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(SomeUserBeanWithTestScope2.class, new Object[0]));
        }

        @Test
        public void shouldThrowExceptionWhenMultipleScopesDefinedOnBean() {
            TestScopeResolver scopeResolver = new TestScopeResolver();
            Injector injector = Injectors.manual(new ScopeResolver[]{scopeResolver});
            injector.register(TestScopedBean.class);
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> injector.register(IllegalMultiScopedBean.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Exception occurred during discovery via path: [hs.ddif.core.InjectorScopeTest$IllegalMultiScopedBean]").satisfies(throwable -> {
                Assertions.assertThat((Object[])throwable.getSuppressed()).hasSize(1);
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class hs.ddif.core.InjectorScopeTest$IllegalMultiScopedBean] cannot have multiple scope annotations, but found: [@hs.ddif.core.test.scope.TestScope(), @jakarta.inject.Singleton()]").hasNoCause();
            })).hasNoCause();
        }
    }
}

