/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.annotations.Opt;
import hs.ddif.core.Injector;
import hs.ddif.core.Injectors;
import hs.ddif.core.inject.store.CyclicDependencyException;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.util.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InjectorStoreConsistencyPolicyStressTest {
    private final Random rnd = new Random(4L);

    @Test
    void shouldSurviveStressTest() {
        Injector injector = Injectors.manual(new ScopeResolver[0]);
        ArrayList actual = new ArrayList();
        ArrayList<Class> classes = new ArrayList<Class>(List.of(A.class, B.class, C.class, D.class, E.class, F.class, G.class, H.class, I.class, J.class, K.class));
        HashSet<Class> classesNeverRegistered = new HashSet<Class>(classes);
        int total = 20000;
        int cyclics = 0;
        int successes = 0;
        for (int i = 0; i < total; ++i) {
            try {
                double x = this.rnd.nextDouble();
                if (x < 0.02) {
                    Collections.shuffle(classes, this.rnd);
                    int count = this.rnd.nextInt(classes.size() - 1) + 1;
                    ArrayList list = new ArrayList(classes.subList(0, count));
                    if (x < 0.01) {
                        injector.getCandidateRegistry().register(list);
                        actual.addAll(list);
                        classesNeverRegistered.removeAll(list);
                    } else {
                        injector.getCandidateRegistry().remove(list);
                        actual.removeAll(list);
                    }
                } else if (x < 0.03) {
                    injector.getCandidateRegistry().remove(new ArrayList(actual));
                    actual.clear();
                } else if ((x < 0.55 || actual.size() == 0) && actual.size() < classes.size()) {
                    List<Class<Object>> toAdd = new ArrayList<Class>(classes);
                    toAdd.removeAll(actual);
                    Collections.shuffle(toAdd, this.rnd);
                    int amount = this.rnd.nextInt((toAdd.size() - 1) / 2) + 1;
                    toAdd = toAdd.subList(0, amount);
                    injector.getCandidateRegistry().register(toAdd);
                    actual.addAll(toAdd);
                    classesNeverRegistered.removeAll(toAdd);
                } else {
                    List toRemove = new ArrayList(actual);
                    Collections.shuffle(toRemove, this.rnd);
                    int amount = toRemove.size() > 2 ? this.rnd.nextInt((toRemove.size() - 1) / 2) + 1 : 1;
                    toRemove = toRemove.subList(0, amount);
                    injector.getCandidateRegistry().remove(toRemove);
                    actual.removeAll(toRemove);
                }
                ++successes;
            }
            catch (AssertionError | IllegalArgumentException | IllegalStateException e) {
                throw e;
            }
            catch (CyclicDependencyException e) {
                ++cyclics;
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Type type : classes) {
                boolean contains = injector.contains(type, new Object[0]);
                if (contains) {
                    contains = injector.getInstances(type, new Object[0]).stream().map(Object::getClass).anyMatch(type::equals);
                }
                if (actual.contains(type)) {
                    Assertions.assertTrue((boolean)contains, (String)("Expected " + type));
                    continue;
                }
                Assertions.assertFalse((boolean)contains, (String)("Did not expect " + type));
            }
        }
        Assertions.assertTrue((successes > total / 5 ? 1 : 0) != 0, (String)"Expected 20%+ succesful calls");
        Assertions.assertTrue((cyclics > 10 ? 1 : 0) != 0, (String)"Expected 10+ cyclic exceptions (attempts to register D)");
        Assertions.assertEquals(Set.of(D.class), classesNeverRegistered, (String)("All classes except D must be registered at some point, but weren't: " + classesNeverRegistered));
    }

    public static class K
    implements Z {
        @Inject
        A a;
    }

    public static class J {
        @Inject
        Provider<Z> h;
    }

    public static class I {
        @Inject
        Z z;
        @Inject
        E e;
    }

    public static class H
    implements Z {
    }

    public static class G {
        @Inject
        K k;
    }

    public static class F {
        @Inject
        B b;
        @Inject
        C c;
        @Inject
        @Nullable
        Z z;
    }

    public static class D
    implements Z {
        @Inject
        C c;
    }

    public static class C {
        @Inject
        B b;
        @Inject
        @Opt
        Provider<D> d;
    }

    public static class B {
        @Inject
        Z z;
    }

    public static class E
    extends A {
    }

    public static class A {
    }

    static interface Z {
    }
}

