/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.annotations.Opt;
import hs.ddif.annotations.Produces;
import hs.ddif.core.Injector;
import hs.ddif.core.config.ConfigurableAnnotationStrategy;
import hs.ddif.core.config.ProducesInjectableExtension;
import hs.ddif.core.config.ProviderInjectableExtension;
import hs.ddif.core.config.discovery.DiscovererFactory;
import hs.ddif.core.config.scope.SingletonScopeResolver;
import hs.ddif.core.config.standard.AnnotationBasedLifeCycleCallbacksFactory;
import hs.ddif.core.config.standard.DefaultDiscovererFactory;
import hs.ddif.core.config.standard.DefaultInjectableFactory;
import hs.ddif.core.definition.ClassInjectableFactory;
import hs.ddif.core.definition.FieldInjectableFactory;
import hs.ddif.core.definition.InjectableFactory;
import hs.ddif.core.definition.InstanceInjectableFactory;
import hs.ddif.core.definition.LifeCycleCallbacksFactory;
import hs.ddif.core.definition.MethodInjectableFactory;
import hs.ddif.core.definition.bind.AnnotationStrategy;
import hs.ddif.core.definition.bind.BindingProvider;
import hs.ddif.core.instantiation.TypeExtensionStores;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.scope.ScopeResolverManager;
import hs.ddif.core.util.Annotations;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.stream.Stream;

public class Injectors {
    private static final Singleton SINGLETON = (Singleton)Annotations.of(Singleton.class);
    private static final AnnotationStrategy ANNOTATION_STRATEGY = new ConfigurableAnnotationStrategy(Inject.class, Qualifier.class, Scope.class, Opt.class);
    private static final Method PROVIDER_METHOD;

    public static Injector autoDiscovering(ScopeResolver ... scopeResolvers) {
        SingletonScopeResolver singletonScopeResolver = new SingletonScopeResolver((Annotation)SINGLETON);
        ScopeResolverManager scopeResolverManager = Injectors.createScopeResolverManager(singletonScopeResolver, scopeResolvers);
        DefaultInjectableFactory injectableFactory = new DefaultInjectableFactory(scopeResolverManager, ANNOTATION_STRATEGY);
        InstanceInjectableFactory instanceInjectableFactory = new InstanceInjectableFactory((InjectableFactory)injectableFactory, (Annotation)SINGLETON);
        return new Injector(TypeExtensionStores.create(ANNOTATION_STRATEGY), Injectors.createDiscoveryFactory((InjectableFactory)injectableFactory, true), instanceInjectableFactory);
    }

    public static Injector manual(ScopeResolver ... scopeResolvers) {
        SingletonScopeResolver singletonScopeResolver = new SingletonScopeResolver((Annotation)SINGLETON);
        ScopeResolverManager scopeResolverManager = Injectors.createScopeResolverManager(singletonScopeResolver, scopeResolvers);
        DefaultInjectableFactory injectableFactory = new DefaultInjectableFactory(scopeResolverManager, ANNOTATION_STRATEGY);
        InstanceInjectableFactory instanceInjectableFactory = new InstanceInjectableFactory((InjectableFactory)injectableFactory, (Annotation)SINGLETON);
        return new Injector(TypeExtensionStores.create(ANNOTATION_STRATEGY), Injectors.createDiscoveryFactory((InjectableFactory)injectableFactory, false), instanceInjectableFactory);
    }

    private static ScopeResolverManager createScopeResolverManager(SingletonScopeResolver singletonScopeResolver, ScopeResolver ... scopeResolvers) {
        ScopeResolver[] standardScopeResolvers = new ScopeResolver[]{singletonScopeResolver};
        ScopeResolver[] extendedScopeResolvers = (ScopeResolver[])Stream.of(scopeResolvers, standardScopeResolvers).flatMap(Stream::of).toArray(ScopeResolver[]::new);
        return new ScopeResolverManager(extendedScopeResolvers);
    }

    private static DiscovererFactory createDiscoveryFactory(InjectableFactory injectableFactory, boolean autoDiscovery) {
        BindingProvider bindingProvider = new BindingProvider(ANNOTATION_STRATEGY);
        AnnotationBasedLifeCycleCallbacksFactory lifeCycleCallbacksFactory = new AnnotationBasedLifeCycleCallbacksFactory(ANNOTATION_STRATEGY, PostConstruct.class, PreDestroy.class);
        ClassInjectableFactory classInjectableFactory = new ClassInjectableFactory(bindingProvider, injectableFactory, (LifeCycleCallbacksFactory)lifeCycleCallbacksFactory);
        MethodInjectableFactory methodInjectableFactory = new MethodInjectableFactory(bindingProvider, injectableFactory);
        FieldInjectableFactory fieldInjectableFactory = new FieldInjectableFactory(bindingProvider, injectableFactory);
        ArrayList<Object> injectableExtensions = new ArrayList<Object>();
        injectableExtensions.add(new ProviderInjectableExtension(methodInjectableFactory, PROVIDER_METHOD));
        injectableExtensions.add(new ProducesInjectableExtension(methodInjectableFactory, fieldInjectableFactory, Produces.class));
        return new DefaultDiscovererFactory(autoDiscovery, injectableExtensions, classInjectableFactory);
    }

    static {
        try {
            PROVIDER_METHOD = Provider.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

