/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.annotations.Produces;
import hs.ddif.core.Injector;
import hs.ddif.core.Injectors;
import hs.ddif.core.api.MultipleInstancesException;
import hs.ddif.core.api.NoSuchInstanceException;
import hs.ddif.core.definition.BadQualifiedTypeException;
import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.inject.store.CyclicDependencyException;
import hs.ddif.core.inject.store.UnresolvableDependencyException;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.store.DuplicateKeyException;
import hs.ddif.core.store.FilteredKeyException;
import hs.ddif.core.test.qualifiers.Big;
import hs.ddif.core.test.qualifiers.Green;
import hs.ddif.core.test.qualifiers.Red;
import hs.ddif.core.test.qualifiers.Small;
import hs.ddif.core.util.TypeReference;
import hs.ddif.test.util.ReplaceCamelCaseDisplayNameGenerator;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

@DisplayNameGeneration(value=ReplaceCamelCaseDisplayNameGenerator.class)
public class ProducesAnnotationTest {
    private Injector injector = Injectors.manual(new ScopeResolver[0]);
    private Injector autoDiscoveryInjector = Injectors.autoDiscovering(new ScopeResolver[0]);

    @Test
    void registerShouldRejectFactoryWithUnresolvableProducerDependencies() {
        UnresolvableDependencyException e = (UnresolvableDependencyException)org.junit.jupiter.api.Assertions.assertThrows(UnresolvableDependencyException.class, () -> this.injector.register(SimpleFactory1.class));
        Assertions.assertThat((Throwable)e).hasMessageStartingWith("Missing dependency [java.lang.Integer] required for Parameter 0 [class java.lang.Integer] of [");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    void registerShouldRejectFactoryWithUnresolvableDependencies() {
        UnresolvableDependencyException e = (UnresolvableDependencyException)org.junit.jupiter.api.Assertions.assertThrows(UnresolvableDependencyException.class, () -> this.injector.register(SimpleFactory2.class));
        Assertions.assertThat((Throwable)e).hasMessageStartingWith("Missing dependency [java.lang.Integer] required for Field [");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    void registerShouldRejectCyclicalFactories() {
        CyclicDependencyException e = (CyclicDependencyException)org.junit.jupiter.api.Assertions.assertThrows(CyclicDependencyException.class, () -> this.injector.register(CyclicalFactory1.class));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)e.getCycle().size());
        e = (CyclicDependencyException)org.junit.jupiter.api.Assertions.assertThrows(CyclicDependencyException.class, () -> this.injector.register(CyclicalFactory2.class));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)e.getCycle().size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    void registerShouldRejectBadlyAnnotatedProducesField() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(BadFactory1.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [java.lang.Integer hs.ddif.core.ProducesAnnotationTest$BadFactory1.size] should not have an inject annotation, but found: [@jakarta.inject.Inject()]").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    void registerShouldRejectBadlyAnnotatedProducesMethod() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(BadFactory2.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [java.lang.Integer hs.ddif.core.ProducesAnnotationTest$BadFactory2.create(java.lang.Double)] should not have an inject annotation, but found: [@jakarta.inject.Inject()]").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    void registerShouldRejectVoidProducesMethod() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(BadFactory3.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [void hs.ddif.core.ProducesAnnotationTest$BadFactory3.create()] has unsuitable type").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[java.lang.Void] cannot be void or Void").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    void registerShouldRejectProducesMethodWithUnresolvedTypeVariables() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(GenericProduces.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [public java.util.ArrayList hs.ddif.core.ProducesAnnotationTest$GenericProduces.create()] has unsuitable type").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[java.util.ArrayList<T>] cannot have unresolvable type variables or wild cards").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    void registerShouldRejectClassWithUnresolvedTypeVariables() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(GenericFactory1.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [public java.util.ArrayList hs.ddif.core.ProducesAnnotationTest$GenericFactory1.create()] has unsuitable type").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[java.util.ArrayList<T>] cannot have unresolvable type variables or wild cards").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    void shouldSupportGenericProducerMethod() {
        this.injector.register(StringMethodFactory.class);
        this.injector.register((Type)TypeUtils.parameterize(GenericFactory1.class, (Type[])new Type[]{Long.class}));
        org.junit.jupiter.api.Assertions.assertThrows(DuplicateKeyException.class, () -> this.injector.register((Type)TypeUtils.parameterize(GenericFactory1.class, (Type[])new Type[]{Long.class})));
        List x1 = (List)this.injector.getInstance(new TypeReference<ArrayList<String>>(){}.getType(), new Object[0]);
        List y1 = (List)this.injector.getInstance(new TypeReference<ArrayList<Long>>(){}.getType(), new Object[0]);
        List x2 = (List)this.injector.getInstance(new TypeReference<ArrayList<String>>(){}.getType(), new Object[0]);
        List y2 = (List)this.injector.getInstance(new TypeReference<ArrayList<Long>>(){}.getType(), new Object[0]);
        org.junit.jupiter.api.Assertions.assertTrue((x1 == x2 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((y1 == y2 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertFalse((x1 == y1 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertFalse((x1 == y2 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(Object.class, new Object[0]));
        this.injector.remove(StringMethodFactory.class);
        this.injector.remove((Type)TypeUtils.parameterize(GenericFactory1.class, (Type[])new Type[]{Long.class}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    void shouldSupportGenericProducerField() {
        StringFactory stringFactory = new StringFactory("hi");
        IntegerFactory integerFactory = new IntegerFactory(123);
        this.injector.registerInstance((Object)stringFactory, new Annotation[0]);
        this.injector.registerInstance((Object)integerFactory, new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hi", (Object)this.injector.getInstance(String.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertEquals((int)123, (Integer)((Integer)this.injector.getInstance(Integer.class, new Object[0])));
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchInstanceException.class, () -> this.injector.getInstance(new TypeReference<GenericFactory2<Long>>(){}.getType(), new Object[0]));
        GenericFactory2 x1 = (GenericFactory2)this.injector.getInstance(new TypeReference<GenericFactory2<String>>(){}.getType(), new Object[0]);
        GenericFactory2 x2 = (GenericFactory2)this.injector.getInstance(StringFactory.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertTrue((x1 == x2 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(Object.class, new Object[0]));
        this.injector.removeInstance((Object)stringFactory);
        this.injector.removeInstance((Object)integerFactory);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    public void shouldRegisterSelfDependentFactory() {
        this.injector.register(SelfDependentFactory.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(Phone.class, new Object[0]));
        this.injector.remove(SelfDependentFactory.class);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    public void shouldNotRegisterAutoDiscoveryDependentFactoryWithoutUsingAutoDiscovery() {
        org.junit.jupiter.api.Assertions.assertThrows(UnresolvableDependencyException.class, () -> this.injector.register(AutoDiscoveryDependentFactory.class));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    public void shouldRegisterAutoDiscoveryDependentFactory() {
        this.autoDiscoveryInjector.register(AutoDiscoveryDependentFactory.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.autoDiscoveryInjector.getInstance(Phone.class, new Object[0]));
        this.autoDiscoveryInjector.remove(AutoDiscoveryDependentFactory.class);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.autoDiscoveryInjector.contains(AutoDiscoveryDependentFactory.class, new Object[0]));
    }

    @Test
    public void shouldRegisterFactoryWithProducesWhichRequiresProvidedClassInSameFactory() {
        this.injector.register(CrossDependentFactory.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(Phone.class, new Object[0]));
        this.injector.remove(CrossDependentFactory.class);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    public void shouldAutoDiscoverProducesAnnotations() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.autoDiscoveryInjector.getInstance(AnotherFactory.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.autoDiscoveryInjector.getInstance(Truck.class, new Object[0]));
    }

    @Test
    public void shouldAutoDiscoverNestedProducesAnnotations() {
        Thing instance = (Thing)this.autoDiscoveryInjector.getInstance(Thing.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance.anotherFactory);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance.truck);
        org.junit.jupiter.api.Assertions.assertEquals((int)2000, (int)instance.truck.size);
    }

    @Test
    public void shouldAutoDiscoverComplicatedNestedProducesAnnotations() {
        ComplicatedThing instance = (ComplicatedThing)this.autoDiscoveryInjector.getInstance(ComplicatedThing.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance.part2.part3);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance.part1.truck);
        org.junit.jupiter.api.Assertions.assertEquals((int)3001, (int)instance.part1.truck.size);
    }

    @Test
    public void shouldNotRegisterClassWhichDependsOnUnregisteredClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(StaticFieldBasedPhoneProducer.class)).isExactlyInstanceOf(UnresolvableDependencyException.class)).hasMessage("Missing dependency [hs.ddif.core.ProducesAnnotationTest$Thing3] required for Field [hs.ddif.core.ProducesAnnotationTest$Thing3 hs.ddif.core.ProducesAnnotationTest$StaticFieldBasedPhoneProducer.thing]").hasNoCause();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    public void shouldRegisterClassWhichProducesInstances() {
        this.injector.register(Thing4.class);
        Phone phone = (Phone)this.injector.getInstance(Phone.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)phone);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hi", (Object)phone.type);
        this.injector.remove(Thing4.class);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(Object.class, new Object[0]));
    }

    @Test
    public void requiredDependencySuppliedIndirectlyByStaticFieldShouldNotCauseCycle() {
        this.autoDiscoveryInjector.getInstance(StaticFieldBasedPhoneProducer.class, new Object[0]);
    }

    @Test
    public void requiredDependencySuppliedIndirectlyByStaticMethodShouldNotCauseCycle() {
        this.autoDiscoveryInjector.getInstance(StaticMethodBasedPhoneProducer.class, new Object[0]);
    }

    @Test
    public void shouldDiscoverClassWhichProducesInstances() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.autoDiscoveryInjector.getInstance(Thing4.class, new Object[0]));
        Phone phone = (Phone)this.autoDiscoveryInjector.getInstance(Phone.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)phone);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hi", (Object)phone.type);
    }

    @Test
    public void shouldRejectRegisteringClassWithProducerProducingExactTypeProvidedByATypeExtension() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(P.class)).isExactlyInstanceOf(DefinitionException.class)).extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(FilteredKeyException.class)).hasNoCause();
    }

    @Test
    public void shouldAllowRegisteringClassWithProducerProducingSubtypeProvidedByATypeExtension() {
        this.injector.register(R.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(R.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(S.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(Q.class, new Object[0]));
    }

    static class S
    implements Provider<Q> {
        S() {
        }

        public Q get() {
            return new Q();
        }
    }

    public static class R {
        @Produces
        S create() {
            return new S();
        }
    }

    static class Q {
        Q() {
        }
    }

    public static class P {
        @Produces
        Provider<Q> create() {
            return () -> new Q();
        }
    }

    public static class Thing4 {
        @Produces
        String text = "Hi";

        @Produces
        Phone createPhone(String text) {
            return new Phone(text);
        }
    }

    public static class StaticMethodBasedPhoneProducer {
        @Inject
        Thing3 thing;

        @Produces
        static Phone createPhone() {
            return new Phone("Hi");
        }
    }

    public static class StaticFieldBasedPhoneProducer {
        @Produces
        static Phone phone = new Phone("Hi");
        @Inject
        Thing3 thing;
    }

    public static class Thing3 {
        @Inject
        Phone text;
    }

    public static class ComplicatedThing {
        @Inject
        Part1 part1;
        @Inject
        Part2 part2;
        @Inject
        Part5 part5;

        public static class Part5 {
            int part;

            Part5(int part) {
                this.part = part;
            }
        }

        public static class Part4 {
        }

        public static class Part3 {
            @Produces
            Truck createTruck(Part4 part4) {
                return new Truck(3001);
            }
        }

        public static class Part2 {
            @Inject
            private Part3 part3;
        }

        public static class Part1 {
            @Inject
            Truck truck;
            @Produces
            Part5 part5 = new Part5(5);
        }
    }

    public static class Thing {
        @Inject
        private AnotherFactory anotherFactory;
        @Inject
        private Truck truck;
    }

    public static class BusProvider {
        @Produces
        public Bus get() {
            return new Bus();
        }
    }

    public static class Garage<T> {
        T content;

        public Garage(T content) {
            this.content = content;
        }
    }

    public static class Truck {
        int size;

        public Truck(int size) {
            this.size = size;
        }
    }

    public static class Phone {
        String type;

        public Phone(String type) {
            this.type = type;
        }
    }

    public static class Bus {
    }

    public static class Car
    implements Vehicle {
        String name;

        public Car(String name) {
            this.name = name;
        }
    }

    static interface Vehicle {
    }

    public static class GenericFactory2<T> {
        @Produces
        private T obj;

        public GenericFactory2(T obj) {
            this.obj = obj;
        }
    }

    public static class IntegerFactory
    extends GenericFactory2<Integer> {
        public IntegerFactory(Integer obj) {
            super(obj);
        }
    }

    public static class StringFactory
    extends GenericFactory2<String> {
        public StringFactory(String obj) {
            super(obj);
        }
    }

    @Singleton
    public static class StringMethodFactory
    extends GenericFactory1<String> {
    }

    public static class GenericProduces {
        @Produces
        public <T> ArrayList<T> create() {
            return new ArrayList();
        }
    }

    @Singleton
    public static class GenericFactory1<T> {
        @Produces
        @Singleton
        public ArrayList<T> create() {
            return new ArrayList();
        }
    }

    public static class BadFactory3 {
        @Produces
        void create() {
        }
    }

    public static class BadFactory2 {
        @Inject
        @Produces
        Integer create(Double size) {
            return size.intValue();
        }
    }

    public static class BadFactory1 {
        @Inject
        @Produces
        Integer size = 5;
    }

    public static class SimpleFactory2 {
        @Inject
        Integer size;

        @Produces
        public Truck create() {
            return new Truck(this.size);
        }
    }

    public static class SimpleFactory1 {
        @Produces
        public static Truck create(Integer size) {
            return new Truck(size);
        }
    }

    public static class CyclicalFactory2 {
        @Produces
        public Truck create(Vehicle vehicle) {
            return new Truck(vehicle.toString().length());
        }

        @Produces
        public Car create(Bus bus) {
            return new Car("bmw-of-size-" + bus.hashCode());
        }

        @Produces
        public Bus create(Truck truck) {
            return new Bus();
        }

        @Produces
        public Float create() {
            return Float.valueOf(2.0f);
        }
    }

    public static class CyclicalFactory1 {
        @Produces
        public Truck create(Car car) {
            return new Truck(car.name.length());
        }

        @Produces
        public Car create(Truck truck) {
            return new Car("bmw-of-size-" + truck.size);
        }
    }

    public static class UnscopedFactory {
        @Inject
        String prefix;

        @Produces
        @Big
        public Phone createBigPhone() {
            return new Phone("nokia");
        }
    }

    @Singleton
    public static class SingletonFactory
    extends PhoneFactory {
        @Inject
        private String prefix;
        @Produces
        @Small
        private Phone miniPhone = new Phone("mini");

        @Singleton
        @Produces
        private Car createCar(int size) {
            return new Car(this.prefix + "-toyota-" + size);
        }

        @Singleton
        @Produces
        public Garage<Car> createCarGarage(Car car) {
            return new Garage<Car>(car);
        }

        @Produces
        public Garage<Bus> createBusGarage(Bus bus) {
            return new Garage<Bus>(bus);
        }

        @Produces
        public Garage<Truck> createTruckGarage(Truck truck) {
            return new Garage<Truck>(truck);
        }

        @Produces
        public BusProvider createBusProvider() {
            return new BusProvider();
        }

        @Override
        @Produces
        @Red
        public Phone createRedPhone() {
            return new Phone("emergency");
        }
    }

    public static class AutoDiscoveryDependentFactory {
        @Produces
        public Phone createPhone(Bus bus) {
            return new Phone("truck-phone: " + bus);
        }
    }

    public static class CrossDependentFactory {
        @Produces
        public Phone createPhone(Truck truck) {
            return new Phone("truck-phone: " + truck);
        }

        @Produces
        public Truck get() {
            return new Truck(2525);
        }
    }

    public static class SelfDependentFactory {
        @Produces
        public Phone createPhone(Truck truck) {
            return new Phone("truck-phone: " + truck);
        }

        @Produces
        public Truck createTruck() {
            return new Truck(2500);
        }
    }

    public static class AnotherFactory {
        @Produces
        public Truck createTruck() {
            return new Truck(2000);
        }
    }

    public static abstract class PhoneFactory {
        @Red
        public abstract Phone createRedPhone();

        @Singleton
        @Green
        @Produces
        public Phone createGreenPhone() {
            return new Phone("motorola");
        }

        @Produces
        private static AnotherFactory createAnotherFactory() {
            return new AnotherFactory();
        }
    }

    @Nested
    class WithFactoriesRegistered {
        private Integer intValue = 15;
        private String prefix = "pre";

        WithFactoriesRegistered() {
        }

        @BeforeEach
        void beforeEach() {
            ProducesAnnotationTest.this.injector.registerInstance((Object)this.intValue, new Annotation[0]);
            ProducesAnnotationTest.this.injector.registerInstance((Object)this.prefix, new Annotation[0]);
            ProducesAnnotationTest.this.injector.register(SingletonFactory.class);
            ProducesAnnotationTest.this.injector.register(UnscopedFactory.class);
        }

        @AfterEach
        void afterEach() {
            ProducesAnnotationTest.this.injector.remove(UnscopedFactory.class);
            ProducesAnnotationTest.this.injector.remove(SingletonFactory.class);
            ProducesAnnotationTest.this.injector.removeInstance((Object)this.prefix);
            ProducesAnnotationTest.this.injector.removeInstance((Object)this.intValue);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ProducesAnnotationTest.this.injector.contains(Object.class, new Object[0]));
        }

        @Test
        void registeringAFactoryTwiceShouldThrowException() {
            org.junit.jupiter.api.Assertions.assertThrows(DuplicateKeyException.class, (Executable)new Executable(){

                public void execute() {
                    ProducesAnnotationTest.this.injector.register(UnscopedFactory.class);
                }
            });
        }

        @Test
        void factoryScopeShouldBeRespected() {
            SingletonFactory factory2;
            SingletonFactory factory1 = (SingletonFactory)ProducesAnnotationTest.this.injector.getInstance(SingletonFactory.class, new Object[0]);
            org.junit.jupiter.api.Assertions.assertTrue((factory1 == (factory2 = (SingletonFactory)ProducesAnnotationTest.this.injector.getInstance(SingletonFactory.class, new Object[0])) ? 1 : 0) != 0);
            UnscopedFactory unscopedFactory1 = (UnscopedFactory)ProducesAnnotationTest.this.injector.getInstance(UnscopedFactory.class, new Object[0]);
            UnscopedFactory unscopedFactory2 = (UnscopedFactory)ProducesAnnotationTest.this.injector.getInstance(UnscopedFactory.class, new Object[0]);
            org.junit.jupiter.api.Assertions.assertFalse((unscopedFactory1 == unscopedFactory2 ? 1 : 0) != 0);
        }

        @Test
        void factoryShouldHaveDependenciesInjected() {
            UnscopedFactory unscopedFactory = (UnscopedFactory)ProducesAnnotationTest.this.injector.getInstance(UnscopedFactory.class, new Object[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"pre", (Object)unscopedFactory.prefix);
        }

        @Test
        void productsShouldBeAvailableDirectly() {
            Car car = (Car)ProducesAnnotationTest.this.injector.getInstance(Car.class, new Object[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"pre-toyota-15", (Object)car.name);
            org.junit.jupiter.api.Assertions.assertThrows(MultipleInstancesException.class, (Executable)new Executable(){

                public void execute() {
                    ProducesAnnotationTest.this.injector.getInstance(Phone.class, new Object[0]);
                }
            });
            org.junit.jupiter.api.Assertions.assertEquals(Phone.class, ((Phone)ProducesAnnotationTest.this.injector.getInstance(Phone.class, new Object[]{Red.class})).getClass());
        }

        @Test
        void phoneScopeShouldBeRespected() {
            Phone redPhone1 = (Phone)ProducesAnnotationTest.this.injector.getInstance(Phone.class, new Object[]{Red.class});
            Phone redPhone2 = (Phone)ProducesAnnotationTest.this.injector.getInstance(Phone.class, new Object[]{Red.class});
            org.junit.jupiter.api.Assertions.assertFalse((redPhone1 == redPhone2 ? 1 : 0) != 0);
            Phone greenPhone1 = (Phone)ProducesAnnotationTest.this.injector.getInstance(Phone.class, new Object[]{Green.class});
            Phone greenPhone2 = (Phone)ProducesAnnotationTest.this.injector.getInstance(Phone.class, new Object[]{Green.class});
            org.junit.jupiter.api.Assertions.assertTrue((greenPhone1 == greenPhone2 ? 1 : 0) != 0);
        }

        @Test
        void allPhonesShouldBeReturnedWhenGettingInstancesOfPhone() {
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)ProducesAnnotationTest.this.injector.getInstances(Phone.class, new Object[0]).size());
        }

        @Test
        void injectorShouldReturnGenericTypes() {
            ProducesAnnotationTest.this.injector.getInstance(new TypeReference<Garage<Bus>>(){}.getType(), new Object[0]);
            Garage busGarage1 = (Garage)ProducesAnnotationTest.this.injector.getInstance(new TypeReference<Garage<Bus>>(){}.getType(), new Object[0]);
            Garage busGarage2 = (Garage)ProducesAnnotationTest.this.injector.getInstance(new TypeReference<Garage<Bus>>(){}.getType(), new Object[0]);
            Garage carGarage1 = (Garage)ProducesAnnotationTest.this.injector.getInstance(new TypeReference<Garage<Car>>(){}.getType(), new Object[0]);
            Garage carGarage2 = (Garage)ProducesAnnotationTest.this.injector.getInstance(new TypeReference<Garage<Car>>(){}.getType(), new Object[0]);
            Garage truckGarage1 = (Garage)ProducesAnnotationTest.this.injector.getInstance(new TypeReference<Garage<Truck>>(){}.getType(), new Object[0]);
            Garage truckGarage2 = (Garage)ProducesAnnotationTest.this.injector.getInstance(new TypeReference<Garage<Truck>>(){}.getType(), new Object[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)carGarage1, (Object)carGarage2);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)busGarage1, (Object)busGarage2);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)truckGarage1, (Object)truckGarage2);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)busGarage1, (Object)carGarage1);
        }

        @Test
        void providerCreatedViaFactoryShouldSupplyObjects() {
            org.junit.jupiter.api.Assertions.assertEquals(Bus.class, ((Bus)ProducesAnnotationTest.this.injector.getInstance(Bus.class, new Object[0])).getClass());
        }

        @Test
        void recursiveFactoryShouldWork() {
            org.junit.jupiter.api.Assertions.assertEquals(Truck.class, ((Truck)ProducesAnnotationTest.this.injector.getInstance(Truck.class, new Object[0])).getClass());
        }
    }
}

