/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config;

import hs.ddif.annotations.Produces;
import hs.ddif.core.config.ProducesInjectableExtension;
import hs.ddif.core.config.standard.DefaultDiscovererFactory;
import hs.ddif.core.definition.ClassInjectableFactory;
import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.definition.FieldInjectableFactory;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.InjectableFactories;
import hs.ddif.core.definition.MethodInjectableFactory;
import hs.ddif.core.definition.bind.BindingException;
import hs.ddif.core.store.Key;
import hs.ddif.core.store.QualifiedTypeStore;
import hs.ddif.core.test.qualifiers.Red;
import hs.ddif.core.util.Annotations;
import hs.ddif.test.util.ReplaceCamelCaseDisplayNameGenerator;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@DisplayNameGeneration(value=ReplaceCamelCaseDisplayNameGenerator.class)
public class DefaultDiscovererFactoryTest {
    private final QualifiedTypeStore<Injectable<?>> store = new QualifiedTypeStore(i -> new Key(i.getType(), (Collection)i.getQualifiers()), t -> true);
    private final InjectableFactories injectableFactories = new InjectableFactories();
    private final ClassInjectableFactory classInjectableFactory = this.injectableFactories.forClass();
    private final FieldInjectableFactory fieldInjectableFactory = this.injectableFactories.forField();
    private final MethodInjectableFactory methodInjectableFactory = this.injectableFactories.forMethod();

    public static class J {
    }

    static interface I {
        public void createJ();
    }

    public static class Bad_H {
        @Produces
        static Bad_H h = new Bad_H();
    }

    public static class Bad_D {
        @Inject
        Bad_A a;
    }

    public static class Bad_C {
        @Inject
        @Red
        J j;
    }

    public static class Bad_B {
        @Inject
        E e;
        @Inject
        C c;
    }

    public static class Bad_A {
        @Inject
        C c;
    }

    public static class Z {
        public Z(String important) {
        }
    }

    public static class Y {
        @Inject
        W w;
    }

    public static class X {
        public X(String important) {
        }
    }

    public static class W {
        @Produces
        static W w = new W(2);
        @Produces
        X x = new X("hello");
        @Produces
        Z z = new Z("world");

        private W(int i) {
        }
    }

    public static class K {
        @Inject
        H h;
    }

    public static class H {
        @Produces
        static H h = new H(2);
        int i;

        private H(int i) {
            this.i = i;
        }
    }

    public static class G {
    }

    public static class F {
        @Produces
        G takes(B b, A a) {
            return null;
        }
    }

    public static class E {
        final String important;

        public E(String important) {
            this.important = important;
        }
    }

    public static class D {
    }

    public static class C {
        final D d;
        final E e;

        public C(D d, E e) {
            this.d = d;
            this.e = e;
        }
    }

    public static class B {
        @Produces
        static E e = new E("!");
    }

    public static class A {
        @Produces
        B b = new B();

        @Produces
        C createC(D d, E e) {
            return new C(d, e);
        }
    }

    @Nested
    class When_autoDiscovery_isEnabled {
        private final DefaultDiscovererFactory gatherer;

        When_autoDiscovery_isEnabled() {
            this.gatherer = new DefaultDiscovererFactory(true, List.of(new ProducesInjectableExtension(DefaultDiscovererFactoryTest.this.methodInjectableFactory, DefaultDiscovererFactoryTest.this.fieldInjectableFactory, Produces.class)), DefaultDiscovererFactoryTest.this.classInjectableFactory);
        }

        @Nested
        class And_gather_With_Types_IsCalled {
            And_gather_With_Types_IsCalled() {
            }

            @Test
            void shouldFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, List.of(Y.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Y.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(W.class.getDeclaredField("w"), W.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(W.class.getDeclaredField("x"), W.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(W.class.getDeclaredField("z"), W.class)});
            }

            @Test
            void shouldRejectTypesThatCannotBeCreatedWithoutBindingDiscovery() {
                ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, List.of(X.class, Y.class, Z.class)).discover()).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Exception occurred during discovery via path: [hs.ddif.core.config.DefaultDiscovererFactoryTest$X]").satisfies(throwable -> {
                    Assertions.assertThat((Object[])throwable.getSuppressed()).hasSize(2);
                    ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class hs.ddif.core.config.DefaultDiscovererFactoryTest$X] could not be bound").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BindingException.class)).hasMessage("[class hs.ddif.core.config.DefaultDiscovererFactoryTest$X] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoCause();
                    ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[1]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class hs.ddif.core.config.DefaultDiscovererFactoryTest$Z] could not be bound").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BindingException.class)).hasMessage("[class hs.ddif.core.config.DefaultDiscovererFactoryTest$Z] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoCause();
                })).hasNoCause();
                ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, List.of(X.class, Y.class)).discover()).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Exception occurred during discovery via path: [hs.ddif.core.config.DefaultDiscovererFactoryTest$X]").satisfies(throwable -> {
                    Assertions.assertThat((Object[])throwable.getSuppressed()).hasSize(1);
                    ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class hs.ddif.core.config.DefaultDiscovererFactoryTest$X] could not be bound").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(BindingException.class)).hasMessage("[class hs.ddif.core.config.DefaultDiscovererFactoryTest$X] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoCause();
                })).hasNoCause();
            }
        }

        @Nested
        class And_gather_With_Key_IsCalled {
            And_gather_With_Key_IsCalled() {
            }

            @Test
            void shouldDiscoverTypesAndFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(A.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(D.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class)});
            }

            @Test
            void shouldDiscoverThroughBindingsOfProducerMethod() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(F.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(D.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(F.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(F.class.getDeclaredMethod("takes", B.class, A.class), F.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class)});
            }

            @Test
            void shouldDiscoverClassWhichProducesItself() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(H.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(H.class.getDeclaredField("h"), H.class)});
            }

            @Test
            void shouldDiscoverThroughBindingsClassesWhichProduceThemselves() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(K.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(K.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(H.class.getDeclaredField("h"), H.class)});
            }

            @Test
            void shouldReturnEmptySetWhenTypeAlreadyResolvable() {
                DefaultDiscovererFactoryTest.this.store.put((Object)DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class));
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(A.class)).discover()).isEmpty();
            }

            @Test
            void shouldRejectWhenDiscoveredTypeMissesRequiredQualifiers() {
                ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(A.class, Set.of(Annotations.of(Red.class)))).discover()).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Exception occurred during discovery via path: [@hs.ddif.core.test.qualifiers.Red() hs.ddif.core.config.DefaultDiscovererFactoryTest$A]").satisfies(throwable -> {
                    Assertions.assertThat((Object[])throwable.getSuppressed()).hasSize(1);
                    ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class hs.ddif.core.config.DefaultDiscovererFactoryTest$A] found during auto discovery is missing qualifiers required by: [@hs.ddif.core.test.qualifiers.Red() hs.ddif.core.config.DefaultDiscovererFactoryTest$A]").hasNoCause();
                })).hasNoCause();
            }

            @Test
            void shouldRejectTypeThatIsAbstract() {
                ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(I.class)).discover()).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Exception occurred during discovery via path: [hs.ddif.core.config.DefaultDiscovererFactoryTest$I]").satisfies(throwable -> {
                    Assertions.assertThat((Object[])throwable.getSuppressed()).hasSize(1);
                    ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[interface hs.ddif.core.config.DefaultDiscovererFactoryTest$I] cannot be abstract").hasNoCause();
                })).hasNoCause();
            }

            @Test
            void shouldNotIncludeTypeThatHasQualifiers() {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(Bad_C.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_C.class)});
            }

            @Test
            void shouldNotIncludeUndiscoverableDependency() {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(Bad_A.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_A.class)});
            }

            @Test
            void shouldNotIncludeUndiscoverableDependencyInDependency() {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(Bad_D.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_D.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_A.class)});
            }

            @Test
            void shouldNotIncludeUndiscoverableDependencies() {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(Bad_B.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(Bad_B.class)});
            }

            @Test
            void shouldRejectTypeWhichCanBeDerivedOrConstructedInMultipleWays() {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(Bad_H.class)).discover()).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Exception occurred during discovery via path: [hs.ddif.core.config.DefaultDiscovererFactoryTest$Bad_H]").hasSuppressedException((Throwable)new DefinitionException("[class hs.ddif.core.config.DefaultDiscovererFactoryTest$Bad_H] creation is ambiguous, there are multiple ways to create it", null)).hasNoCause();
            }
        }

        @Nested
        class And_gather_With_Injectable_IsCalled {
            And_gather_With_Injectable_IsCalled() {
            }

            @Test
            void shouldFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isEnabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(D.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class)});
            }
        }
    }

    @Nested
    class When_autoDiscovery_isDisabled {
        private final DefaultDiscovererFactory gatherer;

        When_autoDiscovery_isDisabled() {
            this.gatherer = new DefaultDiscovererFactory(false, List.of(new ProducesInjectableExtension(DefaultDiscovererFactoryTest.this.methodInjectableFactory, DefaultDiscovererFactoryTest.this.fieldInjectableFactory, Produces.class)), DefaultDiscovererFactoryTest.this.classInjectableFactory);
        }

        @Nested
        class And_gather_With_Types_IsCalled {
            And_gather_With_Types_IsCalled() {
            }

            @Test
            void shouldFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isDisabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, List.of(A.class, D.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class), DefaultDiscovererFactoryTest.this.classInjectableFactory.create(D.class)});
            }
        }

        @Nested
        class And_gather_With_Key_IsCalled {
            And_gather_With_Key_IsCalled() {
            }

            @Test
            void shouldAlwaysReturnEmptySet() {
                Assertions.assertThat((Iterable)When_autoDiscovery_isDisabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(A.class)).discover()).isEmpty();
                Assertions.assertThat((Iterable)When_autoDiscovery_isDisabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(A.class, Set.of(Annotations.of(Red.class)))).discover()).isEmpty();
                Assertions.assertThat((Iterable)When_autoDiscovery_isDisabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(I.class)).discover()).isEmpty();
                Assertions.assertThat((Iterable)When_autoDiscovery_isDisabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, new Key(Bad_C.class)).discover()).isEmpty();
            }
        }

        @Nested
        class And_gather_With_Injectable_IsCalled {
            And_gather_With_Injectable_IsCalled() {
            }

            @Test
            void shouldFindProducedTypes() throws Exception {
                Assertions.assertThat((Iterable)When_autoDiscovery_isDisabled.this.gatherer.create(DefaultDiscovererFactoryTest.this.store, DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class)).discover()).containsExactlyInAnyOrder((Object[])new Injectable[]{DefaultDiscovererFactoryTest.this.classInjectableFactory.create(A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(A.class.getDeclaredField("b"), A.class), DefaultDiscovererFactoryTest.this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", D.class, E.class), A.class), DefaultDiscovererFactoryTest.this.fieldInjectableFactory.create(B.class.getDeclaredField("e"), B.class)});
            }
        }
    }
}

