/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config;

import hs.ddif.annotations.Produces;
import hs.ddif.core.config.ProducesInjectableExtension;
import hs.ddif.core.definition.FieldInjectableFactory;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.InjectableFactories;
import hs.ddif.core.definition.MethodInjectableFactory;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProducesInjectableExtensionTest {
    private final InjectableFactories injectableFactories = new InjectableFactories();
    private final MethodInjectableFactory methodInjectableFactory = this.injectableFactories.forMethod();
    private final FieldInjectableFactory fieldInjectableFactory = this.injectableFactories.forField();
    private ProducesInjectableExtension extension = new ProducesInjectableExtension(this.methodInjectableFactory, this.fieldInjectableFactory, Produces.class);

    @Test
    void shouldFindProducesAnnotatedMethods() throws NoSuchMethodException, SecurityException, NoSuchFieldException {
        List injectables = this.extension.getDerived(A.class);
        Assertions.assertThat((List)injectables).containsExactlyInAnyOrder((Object[])new Injectable[]{this.methodInjectableFactory.create(A.class.getDeclaredMethod("createB", new Class[0]), A.class), this.methodInjectableFactory.create(A.class.getDeclaredMethod("createC", new Class[0]), A.class), this.fieldInjectableFactory.create(A.class.getDeclaredField("d"), A.class), this.fieldInjectableFactory.create(A.class.getDeclaredField("e"), A.class)});
    }

    public static class E {
    }

    public static class D {
    }

    public static class C {
    }

    public static class B {
    }

    public static class A {
        @Produces
        private static E e = new E();
        @Produces
        private D d = new D();

        @Produces
        public static C createC() {
            return new C();
        }

        @Produces
        public B createB() {
            return new B();
        }
    }
}

