/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config;

import hs.ddif.annotations.Opt;
import hs.ddif.core.Injector;
import hs.ddif.core.Injectors;
import hs.ddif.core.api.InstanceCreationException;
import hs.ddif.core.api.NoSuchInstanceException;
import hs.ddif.core.inject.store.ViolatesSingularDependencyException;
import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.domain.NoSuchInstance;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.store.NoSuchKeyException;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.junit.jupiter.api.Test;

public class ProviderInjectableExtensionInjectorTest {
    private Injector injector = Injectors.manual(new ScopeResolver[0]);

    @Test
    void shouldUseProviderFromCandidate() {
        this.injector.register(A.class);
        Assertions.assertThat((Object)((A)this.injector.getInstance(A.class, new Object[0]))).isInstanceOf(A.class);
        Assertions.assertThat((Object)((B)this.injector.getInstance(B.class, new Object[0]))).isInstanceOf(B.class);
        Assertions.assertThatThrownBy(() -> this.injector.remove(B.class)).isExactlyInstanceOf(NoSuchKeyException.class);
        this.injector.remove(A.class);
        Assertions.assertThatThrownBy(() -> this.injector.getInstance(A.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class);
        Assertions.assertThatThrownBy(() -> this.injector.getInstance(B.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class);
    }

    @Test
    void shouldAllowAddAndRemoveOfProviderWhenOnlyOptionalDependencyExists() {
        this.injector.register(F.class);
        Assertions.assertThat((Object)((F)this.injector.getInstance(F.class, (Object[])new Object[0])).b).isNull();
        this.injector.register(A.class);
        Assertions.assertThat((Object)((F)this.injector.getInstance(F.class, (Object[])new Object[0])).b).isNotNull();
        this.injector.remove(A.class);
        Assertions.assertThat((Object)((F)this.injector.getInstance(F.class, (Object[])new Object[0])).b).isNull();
    }

    @Test
    void shouldRejectDuplicateProviderWhenSingularDependencyExists() {
        this.injector.register(A.class);
        this.injector.register(C.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new B(), new Annotation[0])).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new D(), new Annotation[0])).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(D.class)).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasNoCause();
    }

    @Test
    void shouldRejectDuplicateProviderWhenLazySingularDependencyExists() {
        this.injector.register(A.class);
        this.injector.register(E.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new B(), new Annotation[0])).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new D(), new Annotation[0])).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(D.class)).isExactlyInstanceOf(ViolatesSingularDependencyException.class)).hasNoCause();
    }

    @Test
    void shouldRejectInjectingNullFromProvider() {
        Provider<B> providerInstance = new Provider<B>(){

            public B get() {
                return null;
            }
        };
        this.injector.registerInstance((Object)providerInstance, new Annotation[0]);
        this.injector.register(C.class);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(C.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[class hs.ddif.core.config.ProviderInjectableExtensionInjectorTest$C] could not be created").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(InstanceCreationFailure.class)).hasMessage("[class hs.ddif.core.config.ProviderInjectableExtensionInjectorTest$C] could not be created").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasMessage("No such instance: [hs.ddif.core.config.ProviderInjectableExtensionInjectorTest$B]").hasNoCause();
        Provider provider = (Provider)this.injector.getInstance((Type)TypeUtils.parameterize(Provider.class, (Type[])new Type[]{B.class}), new Object[0]);
        Assertions.assertThat((Object)provider).isNotEqualTo((Object)providerInstance);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> provider.get()).isExactlyInstanceOf(NoSuchInstanceException.class)).hasMessage("No such instance: [hs.ddif.core.config.ProviderInjectableExtensionInjectorTest$B]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasMessage("No such instance: [hs.ddif.core.config.ProviderInjectableExtensionInjectorTest$B]").hasNoCause();
        this.injector.register(E.class);
        E instance = (E)this.injector.getInstance(E.class, new Object[0]);
        Assertions.assertThat(instance.b).isNotNull();
        Assertions.assertThat(instance.b).isNotEqualTo((Object)providerInstance);
        Assertions.assertThat(instance.b).isNotEqualTo((Object)provider);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> instance.b.get()).isExactlyInstanceOf(NoSuchInstanceException.class)).hasMessage("No such instance: [hs.ddif.core.config.ProviderInjectableExtensionInjectorTest$B]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasMessage("No such instance: [hs.ddif.core.config.ProviderInjectableExtensionInjectorTest$B]").hasNoCause();
    }

    @Test
    void shouldAllowInjectingNullFromProviderIfOptional() {
        this.injector.registerInstance((Object)new Provider<B>(){

            public B get() {
                return null;
            }
        }, new Annotation[0]);
        this.injector.register(F.class);
        F instance = (F)this.injector.getInstance(F.class, new Object[0]);
        Assertions.assertThat((Object)instance).isInstanceOf(F.class);
        Assertions.assertThat((Object)instance.b).isNull();
    }

    public static class F {
        @Inject
        @Opt
        B b;
    }

    public static class E {
        @Inject
        Provider<B> b;
    }

    public static class D
    implements Provider<B> {
        public B get() {
            return new B();
        }
    }

    public static class C {
        @Inject
        B b;
    }

    public static class B {
    }

    public static class A
    implements Provider<B> {
        public B get() {
            return new B();
        }
    }
}

