/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config.standard;

import hs.ddif.core.config.scope.SingletonScopeResolver;
import hs.ddif.core.config.standard.DefaultInjectable;
import hs.ddif.core.definition.BadQualifiedTypeException;
import hs.ddif.core.definition.QualifiedType;
import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.injection.Constructable;
import hs.ddif.core.instantiation.injection.Injection;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.test.qualifiers.Green;
import hs.ddif.core.test.qualifiers.Red;
import hs.ddif.core.util.Annotations;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class DefaultInjectableTest {
    private static final ScopeResolver SCOPE_RESOLVER = new SingletonScopeResolver(Annotations.of(Singleton.class));
    private final Binding binding1 = (Binding)Mockito.mock(Binding.class);
    private final Binding binding2 = (Binding)Mockito.mock(Binding.class);
    private final Binding binding3 = (Binding)Mockito.mock(Binding.class);
    private final Constructable<String> constructable = new Constructable<String>(){

        public void destroy(String instance) {
        }

        public String create(List<Injection> injections) {
            return "5";
        }
    };

    @Test
    void constructorShouldAcceptValidParameters() throws InstanceCreationFailure, BadQualifiedTypeException {
        DefaultInjectable injectable = new DefaultInjectable(String.class, new QualifiedType(String.class), List.of(), SCOPE_RESOLVER, null, this.constructable);
        Assertions.assertThat((String)((String)injectable.create(List.of()))).isEqualTo("5");
        Assertions.assertThat((Object)injectable.getType()).isEqualTo(String.class);
        Assertions.assertThat((Object)injectable.getScopeResolver()).isEqualTo((Object)SCOPE_RESOLVER);
        Assertions.assertThat((Iterable)injectable.getQualifiers()).isEmpty();
        Assertions.assertThat((List)injectable.getBindings()).isEmpty();
        Assertions.assertThat((String)injectable.toString()).isEqualTo("Injectable[java.lang.String]");
        injectable = new DefaultInjectable(String.class, new QualifiedType((Type)TypeUtils.parameterize(Supplier.class, (Type[])new Type[]{String.class}), Set.of(Annotations.of(Red.class), Annotations.of(Green.class))), List.of(this.binding1, this.binding2, this.binding3), SCOPE_RESOLVER, null, this.constructable);
        Assertions.assertThat((String)((String)injectable.create(List.of()))).isEqualTo("5");
        Assertions.assertThat((Object)injectable.getType()).isEqualTo((Object)TypeUtils.parameterize(Supplier.class, (Type[])new Type[]{String.class}));
        Assertions.assertThat((Object)injectable.getScopeResolver()).isEqualTo((Object)SCOPE_RESOLVER);
        Assertions.assertThat((Iterable)injectable.getQualifiers()).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Red.class), Annotations.of(Green.class)});
        Assertions.assertThat((List)injectable.getBindings()).containsExactly((Object[])new Binding[]{this.binding1, this.binding2, this.binding3});
        Assertions.assertThat((String)injectable.toString()).isEqualTo("Injectable[@hs.ddif.core.test.qualifiers.Green() @hs.ddif.core.test.qualifiers.Red() java.util.function.Supplier<java.lang.String>]");
    }

    @Test
    void constructorShouldRejectBadParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(null, new QualifiedType(String.class), List.of(), SCOPE_RESOLVER, null, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ownerType cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, null, List.of(), SCOPE_RESOLVER, null, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("qualifiedType cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, new QualifiedType(String.class, Set.of(Annotations.of(Red.class))), null, SCOPE_RESOLVER, null, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("bindings cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, new QualifiedType(String.class, Set.of(Annotations.of(Red.class))), List.of(), null, null, this.constructable)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("scopeResolver cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultInjectable(String.class, new QualifiedType(String.class, Set.of(Annotations.of(Red.class))), List.of(), SCOPE_RESOLVER, null, null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("constructable cannot be null").hasNoCause();
    }

    @Test
    void equalsAndHashCodeShouldRespectContract() throws BadQualifiedTypeException {
        EqualsVerifier.forClass(DefaultInjectable.class).withNonnullFields(new String[]{"qualifiedType", "ownerType"}).withCachedHashCode("hashCode", "calculateHash", (Object)new DefaultInjectable(String.class, new QualifiedType(String.class, Set.of(Annotations.of(Red.class))), List.of(), SCOPE_RESOLVER, null, this.constructable)).withIgnoredFields(new String[]{"bindings", "scopeResolver", "constructable"}).verify();
    }
}

