/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config.standard;

import hs.ddif.annotations.Produces;
import hs.ddif.core.api.InstanceCreationException;
import hs.ddif.core.api.InstanceResolver;
import hs.ddif.core.api.MultipleInstancesException;
import hs.ddif.core.api.NoSuchInstanceException;
import hs.ddif.core.config.discovery.DiscovererFactory;
import hs.ddif.core.config.discovery.DiscoveryFailure;
import hs.ddif.core.config.standard.DefaultDiscovererFactory;
import hs.ddif.core.config.standard.DefaultInstanceResolver;
import hs.ddif.core.config.standard.DefaultInstantiationContext;
import hs.ddif.core.definition.ClassInjectableFactory;
import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.definition.InjectableFactories;
import hs.ddif.core.definition.InstanceInjectableFactory;
import hs.ddif.core.definition.MethodInjectableFactory;
import hs.ddif.core.inject.store.BindingManager;
import hs.ddif.core.inject.store.BoundInstantiatorProvider;
import hs.ddif.core.inject.store.InjectableStore;
import hs.ddif.core.inject.store.InstantiatorBindingMap;
import hs.ddif.core.instantiation.DefaultInstantiatorFactory;
import hs.ddif.core.instantiation.InstantiationContext;
import hs.ddif.core.instantiation.InstantiatorFactory;
import hs.ddif.core.instantiation.TypeExtensionStore;
import hs.ddif.core.instantiation.TypeExtensionStores;
import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.domain.MultipleInstances;
import hs.ddif.core.instantiation.domain.NoSuchInstance;
import hs.ddif.core.scope.AbstractScopeResolver;
import hs.ddif.core.scope.OutOfScopeException;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.scope.ScopeResolverManager;
import hs.ddif.core.scope.ScopeResolverManagers;
import hs.ddif.core.store.Resolver;
import hs.ddif.core.test.qualifiers.Red;
import hs.ddif.core.util.Annotations;
import jakarta.inject.Named;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class DefaultInstanceResolverTest {
    private final AbstractScopeResolver<String> scopeResolver = new AbstractScopeResolver<String>(){

        public Class<? extends Annotation> getAnnotationClass() {
            return TestScoped.class;
        }

        public String getCurrentScope() {
            return DefaultInstanceResolverTest.this.currentScope;
        }
    };
    private final TypeExtensionStore typeExtensionStore = TypeExtensionStores.create(InjectableFactories.ANNOTATION_STRATEGY);
    private final InstantiatorFactory instantiatorFactory = new DefaultInstantiatorFactory(this.typeExtensionStore);
    private final InstantiatorBindingMap instantiatorBindingMap = new InstantiatorBindingMap(this.instantiatorFactory);
    private final ScopeResolverManager scopeResolverManager = ScopeResolverManagers.create(new ScopeResolver[]{this.scopeResolver});
    private final InjectableStore store = new InjectableStore((BindingManager)this.instantiatorBindingMap, this.typeExtensionStore.getExtendedTypes());
    private final InstantiationContext instantiationContext = new DefaultInstantiationContext((Resolver)this.store, (BoundInstantiatorProvider)this.instantiatorBindingMap);
    private final InjectableFactories injectableFactories = new InjectableFactories(this.scopeResolverManager);
    private final ClassInjectableFactory classInjectableFactory = this.injectableFactories.forClass();
    private final MethodInjectableFactory methodInjectableFactory = this.injectableFactories.forMethod();
    private final InstanceInjectableFactory instanceInjectableFactory = this.injectableFactories.forInstance();
    private String currentScope;

    public static class K {
    }

    public static abstract class J {
    }

    public static class I {
    }

    public static class H {
    }

    public static class G
    extends E {
    }

    @TestScoped
    public static class F
    extends E {
    }

    public static class E {
    }

    @TestScoped
    public static class D {
    }

    @Singleton
    public static class C {
    }

    @Singleton
    public static class B {
        @Produces
        H createH() {
            throw new RuntimeException("can't create H");
        }

        @Produces
        I createI() {
            return null;
        }
    }

    public static class A {
    }

    @Scope
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface UnknownScoped {
    }

    @Scope
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestScoped {
    }

    @Nested
    class WhenStoreEmptyAndAutoDiscoveryIsActive {
        private final DefaultDiscovererFactory discovererFactory;
        private final InstanceResolver instanceResolver;

        WhenStoreEmptyAndAutoDiscoveryIsActive() {
            this.discovererFactory = new DefaultDiscovererFactory(true, List.of(), DefaultInstanceResolverTest.this.classInjectableFactory);
            this.instanceResolver = new DefaultInstanceResolver(DefaultInstanceResolverTest.this.store, (DiscovererFactory)this.discovererFactory, DefaultInstanceResolverTest.this.instantiationContext, DefaultInstanceResolverTest.this.instantiatorFactory);
        }

        @Test
        void getInstancesShouldNeverDiscoverTypes() {
            Assertions.assertThat((List)this.instanceResolver.getInstances(A.class, new Object[0])).isEmpty();
            Assertions.assertThat((List)this.instanceResolver.getInstances(B.class, new Object[0])).isEmpty();
            Assertions.assertThat((List)this.instanceResolver.getInstances(C.class, new Object[0])).isEmpty();
        }

        @Test
        void getInstanceShouldDiscoverNewTypes() {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.instanceResolver.getInstance(A.class, new Object[0]));
        }

        @Test
        void getInstanceShouldNotDiscoverTypesWithQualifiers() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(A.class, new Object[]{Red.class})).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[@hs.ddif.core.test.qualifiers.Red() hs.ddif.core.config.standard.DefaultInstanceResolverTest$A] instantiation failed because auto discovery was unable to resolve all dependencies; found: []").hasNoSuppressedExceptions().extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DiscoveryFailure.class)).hasMessage("[@hs.ddif.core.test.qualifiers.Red() hs.ddif.core.config.standard.DefaultInstanceResolverTest$A] instantiation failed because auto discovery was unable to resolve all dependencies; found: []").hasNoSuppressedExceptions().extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Exception occurred during discovery via path: [@hs.ddif.core.test.qualifiers.Red() hs.ddif.core.config.standard.DefaultInstanceResolverTest$A]").satisfies(throwable -> {
                Assertions.assertThat((Object[])throwable.getSuppressed()).hasSize(1);
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class hs.ddif.core.config.standard.DefaultInstanceResolverTest$A] found during auto discovery is missing qualifiers required by: [@hs.ddif.core.test.qualifiers.Red() hs.ddif.core.config.standard.DefaultInstanceResolverTest$A]").hasNoCause();
            })).hasNoCause();
        }

        @Test
        void getInstanceShouldThrowExceptionWhenDiscoveryFails() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(J.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[hs.ddif.core.config.standard.DefaultInstanceResolverTest$J] instantiation failed because auto discovery was unable to resolve all dependencies; found: []").hasNoSuppressedExceptions().extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DiscoveryFailure.class)).hasMessage("[hs.ddif.core.config.standard.DefaultInstanceResolverTest$J] instantiation failed because auto discovery was unable to resolve all dependencies; found: []").hasNoSuppressedExceptions().extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Exception occurred during discovery via path: [hs.ddif.core.config.standard.DefaultInstanceResolverTest$J]").satisfies(throwable -> {
                Assertions.assertThat((Object[])throwable.getSuppressed()).hasSize(1);
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isExactlyInstanceOf(DefinitionException.class)).hasMessage("[class hs.ddif.core.config.standard.DefaultInstanceResolverTest$J] cannot be abstract").hasNoCause();
            })).hasNoCause();
        }
    }

    @Nested
    class WhenStoreNotEmpty {
        private final DefaultDiscovererFactory discovererFactory;
        private final InstanceResolver instanceResolver;

        WhenStoreNotEmpty() {
            this.discovererFactory = new DefaultDiscovererFactory(false, List.of(), DefaultInstanceResolverTest.this.classInjectableFactory);
            this.instanceResolver = new DefaultInstanceResolver(DefaultInstanceResolverTest.this.store, (DiscovererFactory)this.discovererFactory, DefaultInstanceResolverTest.this.instantiationContext, DefaultInstanceResolverTest.this.instantiatorFactory);
            try {
                DefaultInstanceResolverTest.this.store.putAll(List.of(DefaultInstanceResolverTest.this.classInjectableFactory.create(A.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(B.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(C.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(D.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(F.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(G.class), DefaultInstanceResolverTest.this.instanceInjectableFactory.create((Object)"red", new Annotation[]{Annotations.of(Red.class)}), DefaultInstanceResolverTest.this.instanceInjectableFactory.create((Object)"green", new Annotation[]{Annotations.of(Named.class, Map.of("value", "green"))}), DefaultInstanceResolverTest.this.methodInjectableFactory.create(B.class.getDeclaredMethod("createH", new Class[0]), B.class), DefaultInstanceResolverTest.this.methodInjectableFactory.create(B.class.getDeclaredMethod("createI", new Class[0]), B.class), DefaultInstanceResolverTest.this.classInjectableFactory.create(K.class)));
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException();
            }
        }

        @Test
        void getInstanceShouldReturnInstancesOfKnownTypes() {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.instanceResolver.getInstance(A.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.instanceResolver.getInstance(String.class, new Object[]{Red.class}));
        }

        @Test
        void getInstancesShouldReturnInstancesOfKnownTypes() {
            Assertions.assertThat((List)this.instanceResolver.getInstances(String.class, new Object[0])).hasSize(2);
        }

        @Test
        void shouldFollowScopeRules() {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((A)this.instanceResolver.getInstance(A.class, new Object[0])).equals(this.instanceResolver.getInstance(A.class, new Object[0])));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((B)this.instanceResolver.getInstance(B.class, new Object[0])).equals(this.instanceResolver.getInstance(B.class, new Object[0])));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((C)this.instanceResolver.getInstance(C.class, new Object[0])).equals(this.instanceResolver.getInstance(C.class, new Object[0])));
        }

        @Test
        void shouldThrowOutOfScopeExceptionWhenScopeNotActive() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(D.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("[class hs.ddif.core.config.standard.DefaultInstanceResolverTest$D] could not be created").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(InstanceCreationFailure.class)).hasMessage("[class hs.ddif.core.config.standard.DefaultInstanceResolverTest$D] could not be created").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(OutOfScopeException.class)).hasMessage("Scope not active: interface hs.ddif.core.config.standard.DefaultInstanceResolverTest$TestScoped for: Injectable[hs.ddif.core.config.standard.DefaultInstanceResolverTest$D]").hasNoCause();
        }

        @Test
        void shouldThrowExceptionWhenNotSingular() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(String.class, new Object[0])).isExactlyInstanceOf(MultipleInstancesException.class)).extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(MultipleInstances.class)).hasNoCause();
        }

        @Test
        void getInstancesShouldRetrieveScopedInstancesOnlyWhenActive() {
            Assertions.assertThat((List)this.instanceResolver.getInstances(E.class, new Object[0])).hasSize(1);
            DefaultInstanceResolverTest.this.currentScope = "Active!";
            Assertions.assertThat((List)this.instanceResolver.getInstances(E.class, new Object[0])).hasSize(2);
        }

        @Test
        void getInstancesShouldThrowExceptionWhenInstantiationFails() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstances(H.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("Method [hs.ddif.core.config.standard.DefaultInstanceResolverTest$H hs.ddif.core.config.standard.DefaultInstanceResolverTest$B.createH()] call failed").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(InstanceCreationFailure.class)).hasMessage("Method [hs.ddif.core.config.standard.DefaultInstanceResolverTest$H hs.ddif.core.config.standard.DefaultInstanceResolverTest$B.createH()] call failed").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(InvocationTargetException.class)).extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(RuntimeException.class)).hasMessage("can't create H").hasNoCause();
        }

        @Test
        void getInstancesShouldRetrieveSingletons() {
            ((ListAssert)Assertions.assertThat((List)this.instanceResolver.getInstances(B.class, new Object[0])).hasSize(1)).containsExactlyInAnyOrderElementsOf((Iterable)this.instanceResolver.getInstances(B.class, new Object[0]));
        }

        @Test
        void getInstancesShouldIgnoreNullInstancesFromProducers() {
            Assertions.assertThat((List)this.instanceResolver.getInstances(I.class, new Object[0])).isEmpty();
        }

        @Test
        void getInstanceShouldRejectNullInstancesFromProducers() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(I.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class)).hasMessage("No such instance: [hs.ddif.core.config.standard.DefaultInstanceResolverTest$I]").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasMessage("No such instance: [hs.ddif.core.config.standard.DefaultInstanceResolverTest$I]").hasNoCause();
        }

        @Test
        void getInstanceShouldThrowExceptionWhenInstantiationFails() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(H.class, new Object[0])).isExactlyInstanceOf(InstanceCreationException.class)).hasMessage("Method [hs.ddif.core.config.standard.DefaultInstanceResolverTest$H hs.ddif.core.config.standard.DefaultInstanceResolverTest$B.createH()] call failed").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(InstanceCreationFailure.class)).hasMessage("Method [hs.ddif.core.config.standard.DefaultInstanceResolverTest$H hs.ddif.core.config.standard.DefaultInstanceResolverTest$B.createH()] call failed").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(InvocationTargetException.class)).extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(RuntimeException.class)).hasMessage("can't create H").hasNoCause();
        }
    }

    @Nested
    class WhenStoreIsEmpty {
        private final DefaultDiscovererFactory discovererFactory;
        private final InstanceResolver instanceResolver;

        WhenStoreIsEmpty() {
            this.discovererFactory = new DefaultDiscovererFactory(false, List.of(), DefaultInstanceResolverTest.this.classInjectableFactory);
            this.instanceResolver = new DefaultInstanceResolver(DefaultInstanceResolverTest.this.store, (DiscovererFactory)this.discovererFactory, DefaultInstanceResolverTest.this.instantiationContext, DefaultInstanceResolverTest.this.instantiatorFactory);
        }

        @Test
        void shouldThrowExceptionWhenGettingSingleInstance() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instanceResolver.getInstance(A.class, new Object[0])).isExactlyInstanceOf(NoSuchInstanceException.class)).extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchInstance.class)).hasNoCause();
        }

        @Test
        void shouldReturnEmptySetWhenGettingMultipleInstances() {
            Assertions.assertThat((List)this.instanceResolver.getInstances(A.class, new Object[0])).isEmpty();
        }
    }
}

