/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config.standard;

import hs.ddif.core.config.standard.KeyFactory;
import hs.ddif.core.test.qualifiers.Red;
import hs.ddif.core.util.Annotations;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyFactoryTest {
    @Test
    void shouldCreateValidKeys() {
        Assertions.assertThat((Object)KeyFactory.of(String.class, (Object[])new Object[0])).isNotNull();
        Assertions.assertThat((Object)KeyFactory.of(String.class, (Object[])new Object[]{Red.class})).isNotNull();
        Assertions.assertThat((Object)KeyFactory.of(String.class, (Object[])new Object[]{Annotations.of(Red.class)})).isNotNull();
    }

    @Test
    void shouldRejectBadInput() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KeyFactory.of(String.class, (Object[])new Object[]{Integer.class})).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported qualifier, must be Class<? extends Annotation> or Annotation: class java.lang.Integer").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KeyFactory.of(String.class, (Object[])new Object[]{5})).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported qualifier, must be Class<? extends Annotation> or Annotation: 5").hasNoCause();
    }
}

