/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.definition;

import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.InjectableFactories;
import hs.ddif.core.definition.InstanceInjectableFactory;
import hs.ddif.core.util.Annotations;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class InstanceInjectableFactoryTest {
    private final InjectableFactories injectableFactories = new InjectableFactories();
    private final InstanceInjectableFactory factory = this.injectableFactories.forInstance();

    @Test
    void createShouldRejectNullField() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(null, new Annotation[0])).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("instance cannot be null").hasNoCause();
    }

    @Test
    void createShouldReturnInjectable() throws Exception {
        Injectable injectable = this.factory.create((Object)"Hello World", new Annotation[0]);
        Assertions.assertThat((Object)injectable.getType()).isEqualTo(String.class);
        Assertions.assertThat((List)injectable.getBindings()).isEmpty();
        Assertions.assertThat((Object)injectable.getScopeResolver()).isEqualTo((Object)this.injectableFactories.getScopeResolver(Annotations.of(Singleton.class)));
        Assertions.assertThat((String)((String)injectable.create(List.of()))).isEqualTo("Hello World");
    }
}

