/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.definition;

import hs.ddif.core.definition.BadQualifiedTypeException;
import hs.ddif.core.definition.QualifiedType;
import hs.ddif.core.test.qualifiers.Green;
import hs.ddif.core.test.qualifiers.Red;
import hs.ddif.core.util.Annotations;
import hs.ddif.core.util.Types;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class QualifiedTypeTest {
    @Test
    void constructorShouldAcceptValidParameters() throws BadQualifiedTypeException {
        QualifiedType key = new QualifiedType(String.class);
        Assertions.assertThat((Object)key.getType()).isEqualTo(String.class);
        Assertions.assertThat((Iterable)key.getQualifiers()).isEmpty();
        Assertions.assertThat((String)key.toString()).isEqualTo("java.lang.String");
        key = new QualifiedType((Type)TypeUtils.parameterize(Supplier.class, (Type[])new Type[]{String.class}), Set.of(Annotations.of(Red.class), Annotations.of(Green.class)));
        Assertions.assertThat((Object)key.getType()).isEqualTo((Object)TypeUtils.parameterize(Supplier.class, (Type[])new Type[]{String.class}));
        Assertions.assertThat((Iterable)key.getQualifiers()).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Red.class), Annotations.of(Green.class)});
        Assertions.assertThat((String)key.toString()).isEqualTo("@hs.ddif.core.test.qualifiers.Green() @hs.ddif.core.test.qualifiers.Red() java.util.function.Supplier<java.lang.String>");
    }

    @Test
    void constructorShouldRejectBadParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType(null, Set.of(Annotations.of(Red.class)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("type cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType(String.class, null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("qualifiers cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType(Void.TYPE, Set.of(Annotations.of(Singleton.class)))).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[@jakarta.inject.Singleton() java.lang.Void] cannot be void or Void").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType(List.class)).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[java.util.List] cannot have unresolvable type variables or wild cards").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedType((Type)Types.wildcardExtends((Type[])new Type[]{String.class}))).isExactlyInstanceOf(BadQualifiedTypeException.class)).hasMessage("[? extends java.lang.String] cannot have unresolvable type variables or wild cards").hasNoCause();
    }

    @Test
    void equalsAndHashCodeShouldRespectContract() {
        EqualsVerifier.forClass(QualifiedType.class).withNonnullFields(new String[]{"type", "qualifiers"}).verify();
    }
}

