/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.definition.bind;

import hs.ddif.annotations.Opt;
import hs.ddif.core.config.ConfigurableAnnotationStrategy;
import hs.ddif.core.definition.bind.AnnotationStrategy;
import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.definition.bind.BindingException;
import hs.ddif.core.definition.bind.BindingProvider;
import hs.ddif.core.store.Key;
import hs.ddif.core.test.qualifiers.Big;
import hs.ddif.core.test.qualifiers.Green;
import hs.ddif.core.test.qualifiers.Red;
import hs.ddif.core.util.Annotations;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;

public class BindingProviderTest {
    private static final Annotation RED = Annotations.of(Red.class);
    private static final Annotation GREEN = Annotations.of(Green.class);
    private BindingProvider bindingProvider = new BindingProvider((AnnotationStrategy)new ConfigurableAnnotationStrategy(Inject.class, Qualifier.class, Scope.class, null));

    @Test
    public void ofMembersShouldBindToGenericFieldInSubclass() throws Exception {
        List bindings = this.bindingProvider.ofMembers(Subclass.class);
        Assertions.assertThat((List)bindings).extracting(new Function[]{Binding::getAccessibleObject, Binding::getKey}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{ClassWithGenericFields.class.getDeclaredField("fieldA"), new Key(String.class)}), Tuple.tuple((Object[])new Object[]{ClassWithGenericFields.class.getDeclaredMethod("setterB", Object.class), new Key(Integer.class)})});
    }

    @Test
    public void ofMethodShouldCreateCorrectBindings() throws Exception {
        List bindings = this.bindingProvider.ofMethod(Subclass.class.getDeclaredMethod("create", Integer.class, Double.class), Subclass.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)bindings.size());
        org.junit.jupiter.api.Assertions.assertEquals(Integer.class, (Object)((Binding)bindings.get(0)).getKey().getType());
        org.junit.jupiter.api.Assertions.assertEquals(Double.class, (Object)((Binding)bindings.get(1)).getKey().getType());
        org.junit.jupiter.api.Assertions.assertEquals(Subclass.class, (Object)((Binding)bindings.get(2)).getKey().getType());
        org.junit.jupiter.api.Assertions.assertEquals(Set.of((Big)Annotations.of(Big.class)), (Object)((Binding)bindings.get(0)).getKey().getQualifiers());
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(), (Object)((Binding)bindings.get(1)).getKey().getQualifiers());
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(), (Object)((Binding)bindings.get(2)).getKey().getQualifiers());
    }

    @Test
    public void ofMethodShouldTakeNonStaticIntoAccount() throws Exception {
        Assertions.assertThat((List)this.bindingProvider.ofMethod(MethodHolder.class.getDeclaredMethod("create", Double.class), MethodHolder.class)).extracting(Binding::getKey).containsExactly((Object[])new Key[]{new Key(Double.class), new Key(MethodHolder.class)});
    }

    @Test
    public void ofMethodShouldTakeStaticIntoAccount() throws Exception {
        Assertions.assertThat((List)this.bindingProvider.ofMethod(MethodHolder.class.getDeclaredMethod("createStatic", Double.class), MethodHolder.class)).extracting(Binding::getKey).containsExactly((Object[])new Key[]{new Key(Double.class)});
    }

    @Test
    public void ofFieldShouldTakeNonStaticIntoAccount() throws Exception {
        Assertions.assertThat((List)this.bindingProvider.ofField(FieldHolder.class.getDeclaredField("b"), FieldHolder.class)).extracting(Binding::getKey).containsExactly((Object[])new Key[]{new Key(FieldHolder.class)});
    }

    @Test
    public void ofFieldShouldTakeStaticIntoAccount() throws NoSuchFieldException, SecurityException {
        Assertions.assertThat((List)this.bindingProvider.ofField(FieldHolder.class.getDeclaredField("a"), FieldHolder.class)).isEmpty();
    }

    @Test
    public void getConstructorShouldFindInjectAnnotatedConstructor() throws Exception {
        Assertions.assertThat((Object)this.bindingProvider.getConstructor(ClassA.class)).isEqualTo(ClassA.class.getDeclaredConstructor(ClassB.class));
    }

    @Test
    public void getConstructorShouldFindDefaultConstructor() throws Exception {
        Assertions.assertThat((Object)this.bindingProvider.getConstructor(ClassB.class)).isEqualTo(ClassB.class.getConstructor(new Class[0]));
    }

    @Test
    public void getConstructorShouldRejectClassWithoutPublicDefaultConstructor() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bindingProvider.getConstructor(ClassC.class)).isExactlyInstanceOf(BindingException.class)).hasMessage("[class hs.ddif.core.definition.bind.BindingProviderTest$ClassC] should have at least one suitable constructor; annotate a constructor or provide an empty public constructor").hasNoCause();
    }

    @Test
    public void getConstructorShouldRejectClassWithMultipleAnnotatedConstructors() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bindingProvider.getConstructor(ClassD.class)).isExactlyInstanceOf(BindingException.class)).hasMessage("[class hs.ddif.core.definition.bind.BindingProviderTest$ClassD] cannot have multiple Inject annotated constructors").hasNoCause();
    }

    @Test
    public void ofMembersShouldRejectFinalField() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bindingProvider.ofMembers(ClassF.class)).isExactlyInstanceOf(BindingException.class)).hasMessage("Field [final java.lang.String hs.ddif.core.definition.bind.BindingProviderTest$ClassF.x] of [class hs.ddif.core.definition.bind.BindingProviderTest$ClassF] cannot be final").hasNoCause();
    }

    @Test
    public void ofConstructorAndMembersShouldFindAllBindings() throws Exception {
        List bindings = this.bindingProvider.ofConstructorAndMembers(ClassA.class.getDeclaredConstructor(ClassB.class), ClassA.class);
        Assertions.assertThat((List)bindings).extracting(Binding::getKey).containsExactly((Object[])new Key[]{new Key(ClassB.class), new Key(String.class), new Key((Type)TypeUtils.parameterize(Provider.class, (Type[])new Type[]{Integer.class})), new Key((Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{Double.class})), new Key((Type)TypeUtils.parameterize(Set.class, (Type[])new Type[]{String.class})), new Key((Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{Double.class}), List.of(RED)), new Key((Type)TypeUtils.parameterize(Set.class, (Type[])new Type[]{String.class}), List.of(RED)), new Key((Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{Double.class}), List.of(GREEN)), new Key((Type)TypeUtils.parameterize(Set.class, (Type[])new Type[]{String.class}), List.of(GREEN)), new Key(Long.class), new Key((Type)TypeUtils.parameterize(Provider.class, (Type[])new Type[]{Short.class})), new Key((Type)TypeUtils.parameterize(Provider.class, (Type[])new Type[]{Short.class}))});
    }

    @Test
    public void ofMembersShouldRejectScopeAnnotations() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bindingProvider.ofMembers(ClassG.class)).isExactlyInstanceOf(BindingException.class)).hasMessage("Method [void hs.ddif.core.definition.bind.BindingProviderTest$ClassG.setter(int)] of [class hs.ddif.core.definition.bind.BindingProviderTest$ClassG] should not be annotated with a scope annotation when it is annotated with an inject annotation: [@jakarta.inject.Singleton()]").hasNoCause();
    }

    public static class ClassG {
        int a;

        @Inject
        @Singleton
        void setter(int a) {
            this.a = a;
        }
    }

    public static class ClassF {
        @Inject
        final String x = "";
    }

    public static class ClassE {
        @Inject
        Provider<Provider<String>> x;

        @Inject
        ClassE(Provider<Provider<String>> provider) {
        }
    }

    public static class ClassD {
        @Inject
        ClassD() {
        }

        @Inject
        ClassD(int a, int b, int c) {
        }
    }

    public static class ClassC {
        ClassC() {
        }
    }

    public static class ClassB {
    }

    public static class ClassA {
        ClassB classB;
        @Inject
        String x;
        @Inject
        Provider<Integer> y;
        @Inject
        List<Double> doubles;
        @Inject
        Set<String> strings;
        @Inject
        @Opt
        @Red
        List<Double> optionalRedDoubles;
        @Inject
        @Opt
        @Red
        Set<String> optoinalRedStrings;
        @Inject
        @Green
        List<Double> emptyGreenDoubles;
        @Inject
        @Green
        Set<String> emptyGreenStrings;
        @Inject
        @Opt
        long z = 15L;
        @Inject
        Provider<Short> p;
        @Inject
        @Opt
        Provider<Short> q;

        @Inject
        ClassA(ClassB classB) {
            this.classB = classB;
        }

        ClassA(int a, int b, int c) {
        }
    }

    public static class FieldHolder {
        public static String a;
        public String b;
    }

    public static class MethodHolder {
        public static String createStatic(Double x) {
            return "" + x;
        }

        public String create(Double x) {
            return "" + x;
        }
    }

    private static class Subclass
    extends ClassWithGenericFields<String, Integer> {
        private Subclass() {
        }

        public String create(@Big Integer dep1, Double dep2) {
            return null;
        }
    }

    private static class ClassWithGenericFields<A, B> {
        @Inject
        private A fieldA;
        private B fieldB;

        private ClassWithGenericFields() {
        }

        @Inject
        void setterB(B b) {
            this.fieldB = b;
        }
    }
}

