/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.inject.store;

import hs.ddif.annotations.Opt;
import hs.ddif.core.definition.ClassInjectableFactory;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.InjectableFactories;
import hs.ddif.core.inject.store.BindingManager;
import hs.ddif.core.inject.store.CyclicDependencyException;
import hs.ddif.core.inject.store.InjectableStore;
import hs.ddif.core.inject.store.InstantiatorBindingMap;
import hs.ddif.core.inject.store.UnresolvableDependencyException;
import hs.ddif.core.inject.store.ViolatesSingularDependencyException;
import hs.ddif.core.instantiation.DefaultInstantiatorFactory;
import hs.ddif.core.instantiation.InstantiatorFactory;
import hs.ddif.core.instantiation.TypeExtensionStore;
import hs.ddif.core.instantiation.TypeExtensionStores;
import hs.ddif.core.scope.UnknownScopeException;
import hs.ddif.core.test.scope.TestScope;
import hs.ddif.core.util.Nullable;
import hs.ddif.test.util.ReplaceCamelCaseDisplayNameGenerator;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@DisplayNameGeneration(value=ReplaceCamelCaseDisplayNameGenerator.class)
public class InjectableStoreConsistencyTest {
    private final ClassInjectableFactory classInjectableFactory = new InjectableFactories().forClass();
    private TypeExtensionStore typeExtensionStore = TypeExtensionStores.create(InjectableFactories.ANNOTATION_STRATEGY);
    private InstantiatorFactory instantiatorFactory = new DefaultInstantiatorFactory(this.typeExtensionStore);
    private InstantiatorBindingMap instantiatorBindingMap = new InstantiatorBindingMap(this.instantiatorFactory);
    private Injectable<A> a = this.classInjectableFactory.create(A.class);
    private Injectable<B> b = this.classInjectableFactory.create(B.class);
    private Injectable<C> c = this.classInjectableFactory.create(C.class);
    private Injectable<D> d = this.classInjectableFactory.create(D.class);
    private Injectable<E> e = this.classInjectableFactory.create(E.class);
    private Injectable<F> f = this.classInjectableFactory.create(F.class);
    private Injectable<G> g = this.classInjectableFactory.create(G.class);
    private Injectable<H> h = this.classInjectableFactory.create(H.class);
    private Injectable<I> i = this.classInjectableFactory.create(I.class);
    private Injectable<J> j = this.classInjectableFactory.create(J.class);
    private Injectable<L> l = this.classInjectableFactory.create(L.class);
    private Injectable<M> m = this.classInjectableFactory.create(M.class);
    private Injectable<N> n = this.classInjectableFactory.create(N.class);
    private Injectable<O> o = this.classInjectableFactory.create(O.class);
    private InjectableStore store = new InjectableStore((BindingManager)this.instantiatorBindingMap, this.typeExtensionStore.getExtendedTypes());

    @Test
    void shouldThrowExceptionWhenClassInjectableAddedWithUnknownScope() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.store.putAll(Set.of(this.classInjectableFactory.create(K.class)))).isExactlyInstanceOf(UnknownScopeException.class)).hasNoCause();
    }

    @Test
    void addAllShouldRejectInjectablesWithCyclicDependency() {
        CyclicDependencyException ex = (CyclicDependencyException)org.junit.jupiter.api.Assertions.assertThrows(CyclicDependencyException.class, () -> this.store.putAll(List.of(this.e, this.b, this.c, this.d)));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)ex.getCycle().size());
    }

    @Test
    void addBShouldFailAsItHasUnresolvableDependency() {
        org.junit.jupiter.api.Assertions.assertThrows(UnresolvableDependencyException.class, () -> this.store.putAll(List.of(this.b)));
    }

    @Test
    void addAAndBAndHShouldFailsAsThereAreMultipleCandidatesOfZForB() {
        org.junit.jupiter.api.Assertions.assertThrows(UnresolvableDependencyException.class, () -> this.store.putAll(List.of(this.a, this.b, this.h)));
    }

    @Test
    void addAAndBAndHShouldFailsAsItThereAreMultipleCandidatesOfZForB2() {
        org.junit.jupiter.api.Assertions.assertThrows(UnresolvableDependencyException.class, () -> this.store.putAll(List.of(this.b, this.a, this.h)));
    }

    @Test
    void addAAndBAndHShouldFailsAsItThereAreMultipleCandidatesOfZForB3() {
        org.junit.jupiter.api.Assertions.assertThrows(UnresolvableDependencyException.class, () -> this.store.putAll(List.of(this.a, this.h, this.b)));
    }

    @Test
    void addIShouldFail() {
        org.junit.jupiter.api.Assertions.assertThrows(CyclicDependencyException.class, () -> this.store.putAll(List.of(this.i)));
    }

    @Test
    void addJShouldFail() {
        org.junit.jupiter.api.Assertions.assertThrows(CyclicDependencyException.class, () -> this.store.putAll(List.of(this.j)));
    }

    @Test
    void addLShouldWork() {
        this.store.putAll(List.of(this.l));
    }

    @Test
    void addLAndAShouldWork() {
        this.store.putAll(List.of(this.l, this.a));
    }

    public static class O {
        @Inject
        M m;
    }

    public static class N {
        @Inject
        M m;
    }

    public static class M {
        @Inject
        Provider<N> n;
        @Inject
        @Opt
        Provider<O> o;
    }

    public static class L {
        @Inject
        @Nullable
        Z z;
    }

    @TestScope
    public static class K {
    }

    public static class J
    implements Z {
        @Inject
        Z z;
    }

    public static class I {
        @Inject
        I i;
    }

    public static class H
    implements Z {
    }

    public static class G {
        @Inject
        F f;
    }

    public static class F {
        @Inject
        B b;
        @Inject
        C c;
    }

    public static class D {
        @Inject
        C c;
    }

    public static class C {
        @Inject
        B b;
        @Inject
        @Opt
        Provider<D> d;
    }

    public static class B {
        @Inject
        Z z;
    }

    public static class E
    extends A {
        @Inject
        D d;
    }

    public static class A
    implements Z {
    }

    static interface Z {
    }

    @Nested
    class WhenClassesMAndNAndOAreAdded {
        WhenClassesMAndNAndOAreAdded() {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.m, InjectableStoreConsistencyTest.this.n, InjectableStoreConsistencyTest.this.o));
        }

        @Test
        void removeMShouldFailAsRequiredByN() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.m)));
        }

        @Test
        void removeNShouldFailAsRequiredByM() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.n)));
        }

        @Test
        void removeOShouldWorkAsMOnlyDependsOnItOptionally() {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.o));
        }
    }

    @Nested
    class WhenClassesAAndBAndCAndDAreAdded {
        WhenClassesAAndBAndCAndDAreAdded() {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.b, InjectableStoreConsistencyTest.this.c, InjectableStoreConsistencyTest.this.d));
        }

        @Test
        void removeAllShouldWork() {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.b, InjectableStoreConsistencyTest.this.c, InjectableStoreConsistencyTest.this.d));
        }

        @Test
        void removeAShouldFail() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.a)));
        }

        @Test
        void removeBShouldFail() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.b)));
        }

        @Test
        void removeCShouldFail() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.c)));
        }

        @Test
        void removeAAndCAndDShouldFail() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.c, InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.d)));
        }

        @Test
        void removeDShouldWork() {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.d));
        }

        @Test
        void removeCAndDShouldWork() {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.c, InjectableStoreConsistencyTest.this.d));
        }

        @Test
        void addEShouldFailAsEWouldCreateCyclicDependency() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.e)));
        }

        @Test
        void addGAndFAndEShouldFailAsEWouldCreateCyclicDependency() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.g, InjectableStoreConsistencyTest.this.f, InjectableStoreConsistencyTest.this.e)));
        }

        @Test
        void addFShouldWork() {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.f));
        }

        @Test
        void addGAndFShouldWork() {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.g, InjectableStoreConsistencyTest.this.f));
        }

        @Test
        void addHShouldFailAsZWouldBeProvidedTwice() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.h)));
        }

        @Test
        void addGAndFAndHShouldFailAsZWouldBeProvidedTwice() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.g, InjectableStoreConsistencyTest.this.h, InjectableStoreConsistencyTest.this.f)));
        }

        @Test
        void addLShouldWork() {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.l));
        }
    }

    @Nested
    class When_L_IsAdded {
        When_L_IsAdded() {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.l));
        }

        @Test
        void remove_L_ShouldWork() {
            InjectableStoreConsistencyTest.this.store.removeAll(List.of(InjectableStoreConsistencyTest.this.l));
        }

        @Test
        void add_A_ShouldWork() {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.a));
        }

        @Test
        void add_A_and_H_ShouldFailBecause_Z_IsProvidedTwice() {
            org.junit.jupiter.api.Assertions.assertThrows(ViolatesSingularDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.h)));
        }
    }

    @Nested
    class WhenClasses_A_And_H_AreAdded {
        WhenClasses_A_And_H_AreAdded() {
            InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.a, InjectableStoreConsistencyTest.this.h));
        }

        @Test
        void add_L_ShouldFailBecause_Z_IsProvidedTwice() {
            org.junit.jupiter.api.Assertions.assertThrows(UnresolvableDependencyException.class, () -> InjectableStoreConsistencyTest.this.store.putAll(List.of(InjectableStoreConsistencyTest.this.l)));
        }
    }
}

