/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.inject.store;

import hs.ddif.annotations.Opt;
import hs.ddif.core.config.scope.SingletonScopeResolver;
import hs.ddif.core.definition.BadQualifiedTypeException;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.InjectableFactories;
import hs.ddif.core.definition.QualifiedType;
import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.inject.store.BindingManager;
import hs.ddif.core.inject.store.InjectableStore;
import hs.ddif.core.inject.store.InstantiatorBindingMap;
import hs.ddif.core.instantiation.DefaultInstantiatorFactory;
import hs.ddif.core.instantiation.InstantiatorFactory;
import hs.ddif.core.instantiation.TypeExtensionStore;
import hs.ddif.core.instantiation.TypeExtensionStores;
import hs.ddif.core.instantiation.injection.Injection;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.store.Key;
import hs.ddif.core.util.Annotations;
import hs.ddif.core.util.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class InjectorStoreConsistencyPolicyLargeGraphTest {
    private final Random rnd = new Random(4L);

    @Test
    void largeGraphTest() throws BadQualifiedTypeException {
        TypeExtensionStore typeExtensionStore = TypeExtensionStores.create(InjectableFactories.ANNOTATION_STRATEGY);
        DefaultInstantiatorFactory instantiatorFactory = new DefaultInstantiatorFactory(typeExtensionStore);
        InstantiatorBindingMap instantiatorBindingMap = new InstantiatorBindingMap((InstantiatorFactory)instantiatorFactory);
        InjectableStore store = new InjectableStore((BindingManager)instantiatorBindingMap, typeExtensionStore.getExtendedTypes());
        ArrayList<1> knownInjectables = new ArrayList<1>();
        List<Class> classes = List.of(String.class, Integer.class, A.class, B.class, C.class, D.class, E.class, F.class, G.class, H.class, I.class, J.class);
        SingletonScopeResolver scopeResolver = new SingletonScopeResolver(Annotations.of(Singleton.class));
        for (int i = 0; i < 10000; ++i) {
            store.checkInvariants();
            int randomBindings = Math.min(this.rnd.nextInt(4), knownInjectables.size());
            final ArrayList<SimpleBinding> bindings = new ArrayList<SimpleBinding>();
            for (int j = 0; j < randomBindings; ++j) {
                Injectable target = (Injectable)knownInjectables.get(this.rnd.nextInt(knownInjectables.size()));
                bindings.add(new SimpleBinding(new Key(target.getType(), (Collection)target.getQualifiers())));
            }
            final QualifiedType qualifiedType = new QualifiedType((Type)classes.get(this.rnd.nextInt(classes.size())), Set.of(Annotations.of(Named.class, Map.of("value", "instance-" + i))));
            Injectable<Object> injectable = new Injectable<Object>((ScopeResolver)scopeResolver){
                final /* synthetic */ ScopeResolver val$scopeResolver;
                {
                    this.val$scopeResolver = scopeResolver;
                }

                public Type getType() {
                    return qualifiedType.getType();
                }

                public Set<Annotation> getQualifiers() {
                    return qualifiedType.getQualifiers();
                }

                public List<Binding> getBindings() {
                    return bindings;
                }

                public ScopeResolver getScopeResolver() {
                    return this.val$scopeResolver;
                }

                public Object create(List<Injection> injections) {
                    return null;
                }

                public void destroy(Object instance) {
                }
            };
            store.putAll(List.of(injectable));
            knownInjectables.add(injectable);
        }
    }

    public static class K
    implements Z {
        @Inject
        A a;
    }

    public static class J {
        @Inject
        Provider<Z> h;
    }

    public static class I {
        @Inject
        Z z;
        @Inject
        E e;
    }

    public static class H
    implements Z {
    }

    public static class G {
        @Inject
        K k;
    }

    public static class F {
        @Inject
        B b;
        @Inject
        C c;
        @Inject
        @Nullable
        Z z;
    }

    public static class D
    implements Z {
        @Inject
        C c;
    }

    public static class C {
        @Inject
        B b;
        @Inject
        @Opt
        Provider<D> d;
    }

    public static class B {
        @Inject
        Z z;
    }

    public static class E
    extends A {
    }

    public static class A {
    }

    static interface Z {
    }

    private static class SimpleBinding
    implements Binding {
        private final Key key;

        public SimpleBinding(Key key) {
            this.key = key;
        }

        public Key getKey() {
            return this.key;
        }

        public AccessibleObject getAccessibleObject() {
            return null;
        }

        public Parameter getParameter() {
            return null;
        }
    }
}

