/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.store;

import hs.ddif.core.store.Key;
import hs.ddif.core.test.qualifiers.Green;
import hs.ddif.core.test.qualifiers.Red;
import hs.ddif.core.util.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyTest {
    @Test
    void constructorShouldAcceptValidParameters() {
        Key key = new Key(String.class);
        Assertions.assertThat((Object)key.getType()).isEqualTo(String.class);
        Assertions.assertThat((Iterable)key.getQualifiers()).isEmpty();
        Assertions.assertThat((String)key.toString()).isEqualTo("java.lang.String");
        key = new Key((Type)TypeUtils.parameterize(Supplier.class, (Type[])new Type[]{String.class}), Set.of(Annotations.of(Red.class), Annotations.of(Green.class)));
        Assertions.assertThat((Object)key.getType()).isEqualTo((Object)TypeUtils.parameterize(Supplier.class, (Type[])new Type[]{String.class}));
        Assertions.assertThat((Iterable)key.getQualifiers()).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Red.class), Annotations.of(Green.class)});
        Assertions.assertThat((String)key.toString()).isEqualTo("@hs.ddif.core.test.qualifiers.Green() @hs.ddif.core.test.qualifiers.Red() java.util.function.Supplier<java.lang.String>");
    }

    @Test
    void constructorShouldRejectBadParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Key(null, Set.of(Annotations.of(Red.class)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("type cannot be null").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Key(String.class, null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("qualifiers cannot be null").hasNoCause();
    }

    @Test
    void equalsAndHashCodeShouldRespectContract() {
        EqualsVerifier.forClass(Key.class).withNonnullFields(new String[]{"type", "qualifiers"}).verify();
    }
}

