/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.store;

import hs.ddif.core.definition.ClassInjectableFactory;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.InjectableFactories;
import hs.ddif.core.definition.InstanceInjectableFactory;
import hs.ddif.core.definition.MethodInjectableFactory;
import hs.ddif.core.store.Key;
import hs.ddif.core.store.QualifiedTypeStore;
import hs.ddif.core.util.TypeReference;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QualifiedTypeStoreGenericsTest {
    private final InjectableFactories injectableFactories = new InjectableFactories();
    private final ClassInjectableFactory classInjectableFactory = this.injectableFactories.forClass();
    private final MethodInjectableFactory methodInjectableFactory = this.injectableFactories.forMethod();
    private final InstanceInjectableFactory instanceInjectableFactory = this.injectableFactories.forInstance();
    private QualifiedTypeStore<Injectable<?>> store;

    @BeforeEach
    public void beforeEach() {
        this.store = new QualifiedTypeStore(i -> new Key(i.getType(), (Collection)i.getQualifiers()), cls -> true);
    }

    @Test
    public void shouldResolveToStringWhenUsingGenerics() {
        this.store.put((Object)this.classInjectableFactory.create(String.class));
        this.store.put((Object)this.instanceInjectableFactory.create((Object)Integer.MAX_VALUE, new Annotation[0]));
        Assertions.assertTrue((this.store.resolve(new Key(Object.class)).size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(String.class)).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(Serializable.class)).size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(CharSequence.class)).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<String>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<?>>(){}.getType())).size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<? extends String>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<? extends Object>>(){}.getType())).size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<? extends Serializable>>(){}.getType())).size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<? extends CharSequence>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<? extends Comparable<String>>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<? extends Comparable<? extends Comparable<String>>>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<? extends Comparable<? extends Comparable<? extends String>>>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<? extends Comparable<? extends Comparable<? super String>>>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Comparable<? super String>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.store.resolve(new Key(Long.class)).isEmpty());
        Assertions.assertTrue((boolean)this.store.resolve(new Key(new TypeReference<Comparable<Object>>(){}.getType())).isEmpty());
        Assertions.assertTrue((boolean)this.store.resolve(new Key(new TypeReference<Comparable<Long>>(){}.getType())).isEmpty());
        Assertions.assertTrue((boolean)this.store.resolve(new Key(new TypeReference<Comparable<? super Object>>(){}.getType())).isEmpty());
        Assertions.assertTrue((boolean)this.store.resolve(new Key(new TypeReference<Comparable<? extends Comparable<? extends Comparable<Object>>>>(){}.getType())).isEmpty());
        Assertions.assertTrue((boolean)this.store.resolve(new Key(new TypeReference<Comparable<? extends Comparable<? super Comparable<String>>>>(){}.getType())).isEmpty());
    }

    @Test
    public void shouldAcceptGenericTypesWithoutTypeVariables() {
        this.store.put((Object)this.classInjectableFactory.create((Type)TypeUtils.parameterize(ArrayList.class, (Type[])new Type[]{String.class})));
    }

    @Test
    public void shouldResolveInjectablesWithMultipleGenericParameters() {
        this.store.put((Object)this.classInjectableFactory.create(OrangeToOrangeJuiceConverter.class));
        this.store.put((Object)this.classInjectableFactory.create(AppleToSlicedAppleConverter.class));
        Assertions.assertTrue((this.store.resolve(new Key(OrangeToOrangeJuiceConverter.class)).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Converter<? extends Fruit, ? extends Juice<?>>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Converter<?, ?>>(){}.getType())).size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Converter<?, OrangeJuice>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Converter<?, ? extends Juice<Orange>>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Converter<? extends Fruit, ?>>(){}.getType())).size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((this.store.resolve(new Key(new TypeReference<Converter<Apple, ?>>(){}.getType())).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void shouldBeAbleToAddAndRemoveResolvedGenericInterface() throws NoSuchMethodException, SecurityException {
        Injectable injectable = this.methodInjectableFactory.create(SuppliesGenericResolvedInterface.class.getDeclaredMethod("supply", new Class[0]), SuppliesGenericResolvedInterface.class);
        this.store.put((Object)injectable);
        this.store.remove((Object)injectable);
    }

    class SlicedApple
    extends Sliced<Apple> {
        SlicedApple() {
        }
    }

    class OrangeJuice
    extends Juice<Orange> {
        OrangeJuice() {
        }
    }

    class Sliced<E> {
        E e;

        Sliced() {
        }
    }

    class Juice<E> {
        E e;

        Juice() {
        }
    }

    class Apple
    extends Fruit {
        Apple() {
        }
    }

    class Orange
    extends Fruit {
        Orange() {
        }
    }

    class Fruit {
        Fruit() {
        }
    }

    static interface Converter<I, O> {
        default public O convert(I input) {
            throw new UnsupportedOperationException(input.toString());
        }
    }

    public static class FruitToSlicedFruitConverter<T extends Fruit>
    implements Converter<T, Sliced<T>> {
    }

    public static class AppleToSlicedAppleConverter
    extends FruitToSlicedFruitConverter<Apple> {
    }

    public static class OrangeToOrangeJuiceConverter
    implements Converter<Orange, OrangeJuice> {
    }

    public static class SuppliesGenericResolvedInterface {
        public List<String> supply() {
            return null;
        }
    }
}

