/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.util;

import hs.ddif.core.util.Annotations;
import io.leangen.geantyref.AnnotationFormatException;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class AnnotationsTest {

    private static class A {
        @Deepest
        @Wet
        @Hot
        public String field1;
        @Deep
        public String field2;
        @Named(value="me")
        public String named;

        private A() {
        }
    }

    @Deeper
    @Level(value=3)
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    static @interface Deepest {
    }

    @Deep
    @Cold
    @Level(value=2)
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    static @interface Deeper {
    }

    @Cold
    @Level(value=1)
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    static @interface Deep {
    }

    @Cold
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    static @interface Wet {
    }

    @Hot
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    static @interface Hot {
    }

    @Wet
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    static @interface Cold {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface Level {
        public int value();
    }

    @Nested
    class When_findAnnotations2AnnotatedWith_IsCalled {
        When_findAnnotations2AnnotatedWith_IsCalled() {
        }

        @Test
        void shouldFindAllAnnotationsDirectlyAnnotatedWithCold() throws Exception {
            Assertions.assertThat((Iterable)Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), (Annotation)Annotations.of(Cold.class))).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Deeper.class), Annotations.of(Deep.class), Annotations.of(Wet.class)});
            Assertions.assertThat((Iterable)Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), Cold.class)).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Deeper.class), Annotations.of(Deep.class), Annotations.of(Wet.class)});
        }

        @Test
        void shouldFindOnlyOneAnnotationDirectlyAnnotatedWithLevel2() throws Exception {
            Assertions.assertThat((Iterable)Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), (Annotation)Annotations.of(Level.class, Map.of("value", 2)))).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Deeper.class)});
        }

        @Test
        void shouldNotFindItself() throws Exception {
            Assertions.assertThat((Iterable)Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), (Annotation)Annotations.of(Deepest.class))).isEmpty();
            Assertions.assertThat((Iterable)Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), Deepest.class)).isEmpty();
        }

        @Test
        void shouldFindItselfIfMetaAnnotatedWithItself() throws Exception {
            Assertions.assertThat((Iterable)Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), (Annotation)Annotations.of(Hot.class))).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Hot.class)});
            Assertions.assertThat((Iterable)Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), Hot.class)).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Hot.class)});
        }

        @Test
        void shouldNotFindAnnotationAnnotatedWithLevel2() throws Exception {
            Assertions.assertThat((Iterable)Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field2"), (Annotation)Annotations.of(Level.class, Map.of("value", 2)))).isEmpty();
        }
    }

    @Nested
    class When_findMetaAnnotatedAnnotations_IsCalled {
        When_findMetaAnnotatedAnnotations_IsCalled() {
        }

        @Test
        void shouldFindTwoAnnotationsMetaAnnotatedWithCold() throws Exception {
            Assertions.assertThat((List)Annotations.findMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), (Annotation)Annotations.of(Cold.class))).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Deepest.class), Annotations.of(Wet.class)});
        }

        @Test
        void shouldFindOnlyOneAnnotationAnnotatedWithLevel2() throws Exception {
            Assertions.assertThat((List)Annotations.findMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), (Annotation)Annotations.of(Level.class, Map.of("value", 2)))).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Deepest.class)});
        }

        @Test
        void shouldNotFindItself() throws Exception {
            Assertions.assertThat((List)Annotations.findMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), (Annotation)Annotations.of(Deepest.class))).isEmpty();
        }

        @Test
        void shouldFindItselfIfMetaAnnotatedWithItself() throws Exception {
            Assertions.assertThat((List)Annotations.findMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), (Annotation)Annotations.of(Hot.class))).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Hot.class)});
        }

        @Test
        void shouldNotFindAnnotationAnnotatedWithLevel2() throws Exception {
            Assertions.assertThat((List)Annotations.findMetaAnnotatedAnnotations((AnnotatedElement)A.class.getDeclaredField("field2"), (Annotation)Annotations.of(Level.class, Map.of("value", 2)))).isEmpty();
        }
    }

    @Nested
    class When_findAnnotations_IsCalled {
        When_findAnnotations_IsCalled() {
        }

        @Test
        void shouldFindDeeplyNestedAnnotation() throws Exception {
            Assertions.assertThat((Iterable)Annotations.findAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), Deepest.class)).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Deepest.class)});
        }

        @Test
        void shouldFindSingleCopyOfExactDuplicateAnnotations() throws Exception {
            Assertions.assertThat((Iterable)Annotations.findAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), Cold.class)).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Cold.class)});
        }

        @Test
        void shouldFindMultipleAnnotationsOfSameTypeIfValuesDiffer() throws Exception {
            Assertions.assertThat((Iterable)Annotations.findAnnotations((AnnotatedElement)A.class.getDeclaredField("field1"), Level.class)).containsExactlyInAnyOrder((Object[])new Annotation[]{Annotations.of(Level.class, Map.of("value", 1)), Annotations.of(Level.class, Map.of("value", 2)), Annotations.of(Level.class, Map.of("value", 3))});
        }
    }

    @Nested
    class When_of_IsCalled {
        When_of_IsCalled() {
        }

        @Test
        void shouldConstructAnnotation() throws NoSuchFieldException, SecurityException {
            Assertions.assertThat((Object)((Deepest)Annotations.of(Deepest.class))).isEqualTo((Object)A.class.getDeclaredField("field1").getAnnotation(Deepest.class));
            Assertions.assertThat((Object)((Level)Annotations.of(Level.class, Map.of("value", 2)))).isEqualTo((Object)Deeper.class.getDeclaredAnnotation(Level.class));
        }

        @Test
        void shouldRejectConstructingAnnotationsWithIncompatibleValues() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Annotations.of(Level.class, Map.of("value", "bar"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not convert to annotation: interface hs.ddif.core.util.AnnotationsTest$Level {value=bar}").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isInstanceOf(AnnotationFormatException.class)).hasMessage("Incompatible type(s) provided for value").hasNoCause();
        }

        @Test
        void shouldRejectConstructingAnnotationsWithMissingRequiredValues() {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Annotations.of(Level.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not convert to annotation: interface hs.ddif.core.util.AnnotationsTest$Level {}").extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isInstanceOf(AnnotationFormatException.class)).hasMessage("Missing value(s) for value").hasNoCause();
        }
    }
}

