/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core;

import hs.ddif.core.api.CandidateRegistry;
import hs.ddif.core.api.InstanceResolver;
import hs.ddif.core.config.discovery.DiscovererFactory;
import hs.ddif.core.config.standard.DefaultInstanceResolver;
import hs.ddif.core.config.standard.DefaultInstantiationContext;
import hs.ddif.core.config.standard.InjectableStoreCandidateRegistry;
import hs.ddif.core.definition.InstanceInjectableFactory;
import hs.ddif.core.inject.store.InjectableStore;
import hs.ddif.core.inject.store.InstantiatorBindingMap;
import hs.ddif.core.instantiation.DefaultInstantiatorFactory;
import hs.ddif.core.instantiation.TypeExtensionStore;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class Injector
implements InstanceResolver,
CandidateRegistry {
    private final InstanceResolver instanceResolver;
    private final CandidateRegistry registry;

    public Injector(TypeExtensionStore typeExtensionStore, DiscovererFactory discovererFactory, InstanceInjectableFactory instanceInjectableFactory) {
        DefaultInstantiatorFactory instantiatorFactory = new DefaultInstantiatorFactory(typeExtensionStore);
        InstantiatorBindingMap instantiatorBindingMap = new InstantiatorBindingMap(Objects.requireNonNull(instantiatorFactory, "instantiatorFactory cannot be null"));
        InjectableStore store = new InjectableStore(instantiatorBindingMap, typeExtensionStore.getExtendedTypes());
        DefaultInstantiationContext instantiationContext = new DefaultInstantiationContext(store, instantiatorBindingMap);
        this.registry = new InjectableStoreCandidateRegistry(store, discovererFactory, instanceInjectableFactory);
        this.instanceResolver = new DefaultInstanceResolver(store, discovererFactory, instantiationContext, instantiatorFactory);
    }

    public InstanceResolver getInstanceResolver() {
        return this.instanceResolver;
    }

    public CandidateRegistry getCandidateRegistry() {
        return this.registry;
    }

    @Override
    public <T> T getInstance(Type type, Object ... qualifiers) {
        return this.instanceResolver.getInstance(type, qualifiers);
    }

    @Override
    public <T> T getInstance(Class<T> cls, Object ... qualifiers) {
        return this.instanceResolver.getInstance(cls, qualifiers);
    }

    @Override
    public <T> List<T> getInstances(Type type, Predicate<Type> typePredicate, Object ... qualifiers) {
        return this.instanceResolver.getInstances(type, typePredicate, qualifiers);
    }

    @Override
    public <T> List<T> getInstances(Class<T> cls, Predicate<Type> typePredicate, Object ... qualifiers) {
        return this.instanceResolver.getInstances(cls, typePredicate, qualifiers);
    }

    @Override
    public <T> List<T> getInstances(Type type, Object ... qualifiers) {
        return this.instanceResolver.getInstances(type, qualifiers);
    }

    @Override
    public <T> List<T> getInstances(Class<T> cls, Object ... qualifiers) {
        return this.instanceResolver.getInstances(cls, qualifiers);
    }

    @Override
    public boolean contains(Type type, Object ... qualifiers) {
        return this.registry.contains(type, qualifiers);
    }

    @Override
    public void register(Type concreteType) {
        this.registry.register(concreteType);
    }

    @Override
    public void register(List<Type> concreteTypes) {
        this.registry.register(concreteTypes);
    }

    @Override
    public void registerInstance(Object instance, Annotation ... qualifiers) {
        this.registry.registerInstance(instance, qualifiers);
    }

    @Override
    public void remove(Type concreteType) {
        this.registry.remove(concreteType);
    }

    @Override
    public void remove(List<Type> concreteTypes) {
        this.registry.remove(concreteTypes);
    }

    @Override
    public void removeInstance(Object instance) {
        this.registry.removeInstance(instance);
    }
}

