/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config;

import hs.ddif.core.definition.bind.AnnotationStrategy;
import hs.ddif.core.util.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConfigurableAnnotationStrategy
implements AnnotationStrategy {
    private final List<Class<? extends Annotation>> injectAnnotations;
    private final List<Class<? extends Annotation>> qualifierAnnotations;
    private final List<Class<? extends Annotation>> scopeAnnotations;
    private final List<Class<? extends Annotation>> optionalAnnotations;

    public ConfigurableAnnotationStrategy(List<Class<? extends Annotation>> injectAnnotations, List<Class<? extends Annotation>> qualifierAnnotations, List<Class<? extends Annotation>> scopeAnnotations, List<Class<? extends Annotation>> optionalAnnotations) {
        if (injectAnnotations == null || injectAnnotations.isEmpty()) {
            throw new IllegalArgumentException("injectAnnotations cannot be null or empty: " + injectAnnotations);
        }
        if (qualifierAnnotations == null || qualifierAnnotations.isEmpty()) {
            throw new IllegalArgumentException("qualifierAnnotations cannot be null or empty: " + injectAnnotations);
        }
        if (scopeAnnotations == null || scopeAnnotations.isEmpty()) {
            throw new IllegalArgumentException("scopeAnnotations cannot be null or empty: " + injectAnnotations);
        }
        if (optionalAnnotations == null) {
            throw new IllegalArgumentException("optionalAnnotations cannot be null");
        }
        this.injectAnnotations = new ArrayList<Class<? extends Annotation>>(injectAnnotations);
        this.qualifierAnnotations = new ArrayList<Class<? extends Annotation>>(qualifierAnnotations);
        this.scopeAnnotations = new ArrayList<Class<? extends Annotation>>(scopeAnnotations);
        this.optionalAnnotations = new ArrayList<Class<? extends Annotation>>(optionalAnnotations);
    }

    public ConfigurableAnnotationStrategy(Class<? extends Annotation> inject, Class<? extends Annotation> qualifier, Class<? extends Annotation> scope, Class<? extends Annotation> optional) {
        this.injectAnnotations = List.of(Objects.requireNonNull(inject, "inject cannot be null"));
        this.qualifierAnnotations = List.of(Objects.requireNonNull(qualifier, "qualifier cannot be null"));
        this.scopeAnnotations = List.of(Objects.requireNonNull(scope, "scope cannot be null"));
        this.optionalAnnotations = optional == null ? List.of() : List.of(optional);
    }

    @Override
    public boolean isInjectAnnotated(AnnotatedElement element) {
        return ConfigurableAnnotationStrategy.isAnnotated(this.injectAnnotations, element);
    }

    @Override
    public boolean isOptional(AnnotatedElement element) {
        if (element != null) {
            for (Annotation annotation : element.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                String simpleName = annotationType.getName();
                if (!simpleName.endsWith(".Nullable") && !this.optionalAnnotations.contains(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Annotation> getInjectAnnotations(AnnotatedElement element) {
        return Stream.of(element.getAnnotations()).filter(a -> this.injectAnnotations.contains(a.annotationType())).collect(Collectors.toSet());
    }

    @Override
    public Set<Annotation> getQualifiers(AnnotatedElement element) {
        return ConfigurableAnnotationStrategy.getAnnotations(this.qualifierAnnotations, element);
    }

    @Override
    public Set<Annotation> getScopes(AnnotatedElement element) {
        return ConfigurableAnnotationStrategy.getAnnotations(this.scopeAnnotations, element);
    }

    @Override
    public boolean isQualifier(Annotation annotation) {
        return ConfigurableAnnotationStrategy.isAnnotated(this.qualifierAnnotations, annotation.annotationType());
    }

    private static boolean isAnnotated(List<Class<? extends Annotation>> annotations, AnnotatedElement element) {
        int size = annotations.size();
        for (int i = 0; i < size; ++i) {
            if (!element.isAnnotationPresent(annotations.get(i))) continue;
            return true;
        }
        return false;
    }

    private static Set<Annotation> getAnnotations(List<Class<? extends Annotation>> annotations, AnnotatedElement element) {
        HashSet<Annotation> matchingAnnotations = new HashSet<Annotation>();
        int size = annotations.size();
        for (int i = 0; i < size; ++i) {
            matchingAnnotations.addAll(Annotations.findDirectlyMetaAnnotatedAnnotations(element, annotations.get(i)));
        }
        return matchingAnnotations;
    }
}

