/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config;

import hs.ddif.core.definition.bind.AnnotationStrategy;
import hs.ddif.core.instantiation.InstantiationContext;
import hs.ddif.core.instantiation.Instantiator;
import hs.ddif.core.instantiation.InstantiatorFactory;
import hs.ddif.core.instantiation.TypeExtension;
import hs.ddif.core.instantiation.TypeTrait;
import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.domain.MultipleInstances;
import hs.ddif.core.instantiation.domain.NoSuchInstance;
import hs.ddif.core.store.Key;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class DirectTypeExtension<T>
implements TypeExtension<T> {
    private static final Set<TypeTrait> REQUIRES_AT_MOST_ONE = Collections.unmodifiableSet(EnumSet.of(TypeTrait.REQUIRES_AT_MOST_ONE));
    private static final Set<TypeTrait> REQUIRES_EXACTLY_ONE = Collections.unmodifiableSet(EnumSet.of(TypeTrait.REQUIRES_AT_MOST_ONE, TypeTrait.REQUIRES_AT_LEAST_ONE));
    private final AnnotationStrategy annotationStrategy;

    public DirectTypeExtension(AnnotationStrategy annotationStrategy) {
        this.annotationStrategy = annotationStrategy;
    }

    @Override
    public Instantiator<T> create(InstantiatorFactory factory, final Key key, AnnotatedElement element) {
        final Set<TypeTrait> typeTraits = this.annotationStrategy.isOptional(element) ? REQUIRES_AT_MOST_ONE : REQUIRES_EXACTLY_ONE;
        return new Instantiator<T>(){

            @Override
            public Key getKey() {
                return key;
            }

            @Override
            public T getInstance(InstantiationContext context) throws InstanceCreationFailure, MultipleInstances, NoSuchInstance {
                Object instance = context.create(key);
                if (instance == null) {
                    if (!typeTraits.contains((Object)TypeTrait.REQUIRES_AT_LEAST_ONE)) {
                        return null;
                    }
                    throw new NoSuchInstance(key);
                }
                return instance;
            }

            @Override
            public Set<TypeTrait> getTypeTraits() {
                return typeTraits;
            }
        };
    }
}

