/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config;

import hs.ddif.core.config.standard.InjectableExtension;
import hs.ddif.core.definition.FieldInjectableFactory;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.MethodInjectableFactory;
import hs.ddif.core.util.Fields;
import hs.ddif.core.util.Methods;
import hs.ddif.core.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ProducesInjectableExtension
implements InjectableExtension {
    private final MethodInjectableFactory methodInjectableFactory;
    private final FieldInjectableFactory fieldInjectableFactory;
    private final Class<? extends Annotation> produces;

    public ProducesInjectableExtension(MethodInjectableFactory methodInjectableFactory, FieldInjectableFactory fieldInjectableFactory, Class<? extends Annotation> produces) {
        this.methodInjectableFactory = methodInjectableFactory;
        this.fieldInjectableFactory = fieldInjectableFactory;
        this.produces = produces;
    }

    @Override
    public List<Injectable<?>> getDerived(Type type) {
        ArrayList injectables = new ArrayList();
        Class injectableClass = Types.raw(type);
        if (injectableClass != null) {
            for (Method method : Methods.findAnnotated(injectableClass, this.produces)) {
                injectables.add(this.methodInjectableFactory.create(method, type));
            }
            for (Field field : Fields.findAnnotated(injectableClass, this.produces)) {
                injectables.add(this.fieldInjectableFactory.create(field, type));
            }
        }
        return injectables;
    }
}

