/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config;

import hs.ddif.core.config.standard.InjectableExtension;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.MethodInjectableFactory;
import hs.ddif.core.util.Types;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public class ProviderInjectableExtension
implements InjectableExtension {
    private final MethodInjectableFactory methodInjectableFactory;
    private final Method providerMethod;

    public ProviderInjectableExtension(MethodInjectableFactory methodInjectableFactory, Method providerMethod) {
        this.methodInjectableFactory = methodInjectableFactory;
        this.providerMethod = providerMethod;
    }

    @Override
    public List<Injectable<?>> getDerived(Type type) {
        Class cls = Types.raw(type);
        if (cls != null && this.providerMethod.getDeclaringClass().isAssignableFrom(cls) && !cls.isInterface()) {
            try {
                Method implementingMethod = cls.getMethod(this.providerMethod.getName(), new Class[0]);
                return List.of(this.methodInjectableFactory.create(implementingMethod, type));
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException(e);
            }
        }
        return List.of();
    }
}

