/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config;

import hs.ddif.core.instantiation.InstantiationContext;
import hs.ddif.core.instantiation.Instantiator;
import hs.ddif.core.instantiation.InstantiatorFactory;
import hs.ddif.core.instantiation.TypeExtension;
import hs.ddif.core.instantiation.TypeTrait;
import hs.ddif.core.instantiation.domain.InstanceResolutionFailure;
import hs.ddif.core.store.Key;
import hs.ddif.core.util.Types;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProviderTypeExtension<P, T>
implements TypeExtension<P> {
    private final Class<P> providerClass;
    private final Function<Supplier<T>, P> providerFactory;
    private final TypeVariable<?> typeVariable;

    public ProviderTypeExtension(Class<P> providerClass, Function<Supplier<T>, P> providerFactory) {
        this.providerClass = Objects.requireNonNull(providerClass, "providerClass cannot be null");
        this.providerFactory = Objects.requireNonNull(providerFactory, "providerFactory cannot be null");
        this.typeVariable = providerClass.getTypeParameters()[0];
    }

    @Override
    public Instantiator<P> create(InstantiatorFactory instantiatorFactory, Key key, AnnotatedElement element) {
        Key elementKey = new Key(Types.getTypeParameter(key.getType(), this.providerClass, this.typeVariable), key.getQualifiers());
        final Instantiator instantiator = instantiatorFactory.getInstantiator(elementKey, element);
        final Set typeTraits = Stream.concat(instantiator.getTypeTraits().stream(), Stream.of(TypeTrait.LAZY)).collect(Collectors.toUnmodifiableSet());
        return new Instantiator<P>(){

            @Override
            public Key getKey() {
                return instantiator.getKey();
            }

            @Override
            public P getInstance(InstantiationContext context) {
                return ProviderTypeExtension.this.providerFactory.apply(() -> {
                    try {
                        return instantiator.getInstance(context);
                    }
                    catch (InstanceResolutionFailure f) {
                        throw f.toRuntimeException();
                    }
                });
            }

            @Override
            public Set<TypeTrait> getTypeTraits() {
                return typeTraits;
            }
        };
    }
}

