/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config.standard;

import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.definition.LifeCycleCallbacksFactory;
import hs.ddif.core.definition.bind.AnnotationStrategy;
import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.factory.LifeCycleCallbacks;
import hs.ddif.core.util.Methods;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class AnnotationBasedLifeCycleCallbacksFactory
implements LifeCycleCallbacksFactory {
    private static final Logger LOGGER = Logger.getLogger(AnnotationBasedLifeCycleCallbacksFactory.class.getName());
    private static final Comparator<Method> CLASS_HIERARCHY_COMPARATOR = (a, b) -> {
        if (a.getDeclaringClass().isAssignableFrom(b.getDeclaringClass())) {
            return -1;
        }
        if (b.getDeclaringClass().isAssignableFrom(a.getDeclaringClass())) {
            return 1;
        }
        return 0;
    };
    private final Class<? extends Annotation> postConstruct;
    private final Class<? extends Annotation> preDestroy;
    private final AnnotationStrategy annotationStrategy;

    public AnnotationBasedLifeCycleCallbacksFactory(AnnotationStrategy annotationStrategy, Class<? extends Annotation> postConstruct, Class<? extends Annotation> preDestroy) {
        this.annotationStrategy = Objects.requireNonNull(annotationStrategy, "annotationStrategy cannot be null");
        this.postConstruct = Objects.requireNonNull(postConstruct, "postConstruct cannot be null");
        this.preDestroy = Objects.requireNonNull(preDestroy, "preDestroy cannot be null");
    }

    @Override
    public LifeCycleCallbacks create(Class<?> cls) {
        List<Method> postConstructMethods = Methods.findAnnotated(cls, this.postConstruct);
        List<Method> preDestroyMethods = Methods.findAnnotated(cls, this.preDestroy);
        Collections.sort(postConstructMethods, CLASS_HIERARCHY_COMPARATOR);
        Collections.sort(preDestroyMethods, CLASS_HIERARCHY_COMPARATOR.reversed());
        Stream.concat(postConstructMethods.stream(), preDestroyMethods.stream()).forEach(method -> {
            if (method.getParameterCount() > 0) {
                throw new DefinitionException((AnnotatedElement)method, "cannot have parameters when annotated as a lifecycle method (post construct or pre destroy)");
            }
            if (this.annotationStrategy.isInjectAnnotated((AnnotatedElement)method)) {
                throw new DefinitionException((AnnotatedElement)method, "cannot be inject annotated when annotated as a lifecycle method (post construct or pre destroy): " + this.annotationStrategy.getInjectAnnotations((AnnotatedElement)method));
            }
        });
        return new DefaultLifeCycleCallbacks(postConstructMethods, preDestroyMethods);
    }

    private class DefaultLifeCycleCallbacks
    implements LifeCycleCallbacks {
        private final List<Method> postConstructMethods;
        private final List<Method> preDestroyMethods;

        DefaultLifeCycleCallbacks(List<Method> postConstructMethods, List<Method> preDestroyMethods) {
            this.postConstructMethods = postConstructMethods;
            this.preDestroyMethods = preDestroyMethods;
        }

        @Override
        public void postConstruct(Object instance) throws InstanceCreationFailure {
            for (Method method : this.postConstructMethods) {
                try {
                    method.setAccessible(true);
                    method.invoke(instance, new Object[0]);
                }
                catch (Exception e) {
                    throw new InstanceCreationFailure(method, "call failed for PostConstruct", (Throwable)e);
                }
            }
        }

        @Override
        public void preDestroy(Object instance) {
            for (Method method : this.preDestroyMethods) {
                try {
                    method.setAccessible(true);
                    method.invoke(instance, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    LOGGER.log(Level.WARNING, "Exception thrown by pre-destroy method: " + method, e.getCause());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Exception while calling pre-destroy method: " + method, e);
                }
            }
        }
    }
}

