/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config.standard;

import hs.ddif.core.config.discovery.Discoverer;
import hs.ddif.core.config.discovery.DiscovererFactory;
import hs.ddif.core.config.standard.InjectableExtension;
import hs.ddif.core.definition.ClassInjectableFactory;
import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.store.Key;
import hs.ddif.core.store.QualifiedTypeStore;
import hs.ddif.core.store.Resolver;
import hs.ddif.core.util.Types;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultDiscovererFactory
implements DiscovererFactory {
    private static final Discoverer EMPTY = new Discoverer(){

        @Override
        public Set<Injectable<?>> discover() {
            return Set.of();
        }

        @Override
        public List<String> getProblems() {
            return List.of();
        }
    };
    private final boolean autoDiscovery;
    private final List<InjectableExtension> injectableExtensions;
    private final ClassInjectableFactory classInjectableFactory;

    public DefaultDiscovererFactory(boolean autoDiscovery, List<InjectableExtension> injectableExtensions, ClassInjectableFactory classInjectableFactory) {
        this.autoDiscovery = autoDiscovery;
        this.injectableExtensions = injectableExtensions;
        this.classInjectableFactory = classInjectableFactory;
    }

    @Override
    public Discoverer create(Resolver<Injectable<?>> resolver, List<Type> types) {
        return new SimpleDiscoverer(resolver, types.stream().map(Key::new).collect(Collectors.toList()));
    }

    @Override
    public Discoverer create(Resolver<Injectable<?>> resolver, Injectable<?> injectable) {
        return new SimpleDiscoverer(resolver, injectable);
    }

    @Override
    public Discoverer create(Resolver<Injectable<?>> resolver, Key key) {
        if (!this.autoDiscovery || !resolver.resolve(key).isEmpty()) {
            return EMPTY;
        }
        return new SimpleDiscoverer(resolver, List.of(key));
    }

    private static class IncludingResolver
    implements Resolver<Injectable<?>> {
        final Resolver<Injectable<?>> base;
        final Resolver<Injectable<?>> include;

        IncludingResolver(Resolver<Injectable<?>> base, Resolver<Injectable<?>> include) {
            this.base = base;
            this.include = include;
        }

        @Override
        public Set<Injectable<?>> resolve(Key key) {
            HashSet set = new HashSet(this.base.resolve(key));
            set.addAll(this.include.resolve(key));
            return set;
        }
    }

    private class SimpleDiscoverer
    implements Discoverer {
        private final QualifiedTypeStore<Injectable<?>> tempStore = new QualifiedTypeStore<Injectable>(i -> new Key(i.getType(), i.getQualifiers()), t -> true);
        private final Set<Binding> unresolvedBindings = new LinkedHashSet<Binding>();
        private final List<Key> requiredKeys = new ArrayList<Key>();
        private final Map<Key, Key> via = new HashMap<Key, Key>();
        private final Set<Type> visitedTypes = new HashSet<Type>();
        private final Set<Type> visitTypes = new HashSet<Type>();
        private final List<String> encounteredProblems = new ArrayList<String>();
        private final IncludingResolver includingResolver = new IncludingResolver(resolver::resolve, this.tempStore);

        SimpleDiscoverer(Resolver<Injectable<?>> resolver, List<Key> keys) {
            for (Key key : keys) {
                this.visitTypes.add(key.getType());
                this.requiredKeys.add(key);
            }
        }

        SimpleDiscoverer(Resolver<Injectable<?>> resolver, Injectable<?> injectable) {
            this.tempStore.put(injectable);
            this.visitTypes.add(injectable.getType());
        }

        @Override
        public List<String> getProblems() {
            return this.encounteredProblems;
        }

        @Override
        public Set<Injectable<?>> discover() {
            while (this.discoverViaExtensions() || this.discoverInputTypes() || this.discoverBindings()) {
            }
            return this.tempStore.toSet();
        }

        private boolean addInjectables(List<Injectable<?>> injectables) {
            if (injectables.isEmpty()) {
                return false;
            }
            this.tempStore.putAll(injectables);
            for (Injectable<?> injectable : injectables) {
                Key injectableKey = new Key(injectable.getType(), injectable.getQualifiers());
                this.visitTypes.add(injectable.getType());
                for (Binding binding : injectable.getBindings()) {
                    Key key = binding.getKey();
                    if (!this.includingResolver.resolve(key).isEmpty()) continue;
                    this.via.put(key, injectableKey);
                    this.visitTypes.add(key.getType());
                    if (!DefaultDiscovererFactory.this.autoDiscovery) continue;
                    this.unresolvedBindings.add(binding);
                }
            }
            return true;
        }

        private boolean discoverViaExtensions() {
            ArrayList extensionDiscoveries = new ArrayList();
            for (Type type : this.visitTypes) {
                if (!this.visitedTypes.add(type)) continue;
                for (InjectableExtension injectableExtension : DefaultDiscovererFactory.this.injectableExtensions) {
                    extensionDiscoveries.addAll(injectableExtension.getDerived(type));
                }
            }
            this.visitTypes.clear();
            return this.addInjectables(extensionDiscoveries);
        }

        private boolean discoverInputTypes() {
            ArrayList injectables = new ArrayList();
            Throwable throwable = null;
            for (Key key : this.requiredKeys) {
                boolean alreadyDerived = this.tempStore.contains(key);
                try {
                    injectables.add(this.attemptCreateInjectable(key));
                    if (!alreadyDerived) continue;
                    alreadyDerived = false;
                    throw new DefinitionException(Types.raw(key.getType()), "creation is ambiguous, there are multiple ways to create it");
                }
                catch (Exception e) {
                    if (alreadyDerived) continue;
                    if (throwable == null) {
                        throwable = new DefinitionException("Exception occurred during discovery via path: " + this.toChain(key), null);
                    }
                    throwable.addSuppressed(e);
                }
            }
            if (throwable == null) {
                this.requiredKeys.clear();
                return this.addInjectables(injectables);
            }
            throw throwable;
        }

        private boolean discoverBindings() {
            Iterator<Binding> iterator = this.unresolvedBindings.iterator();
            while (iterator.hasNext()) {
                Binding binding = iterator.next();
                Key key = binding.getKey();
                iterator.remove();
                if (!this.includingResolver.resolve(key).isEmpty()) continue;
                try {
                    return this.addInjectables(List.of(this.attemptCreateInjectable(binding)));
                }
                catch (Exception e) {
                    this.encounteredProblems.add("Auto discovery of binding unsuccessful: " + binding + ": " + e.getMessage());
                }
            }
            return false;
        }

        private Injectable<?> attemptCreateInjectable(Key key) {
            Type type = key.getType();
            Injectable injectable = DefaultDiscovererFactory.this.classInjectableFactory.create(type);
            if (!injectable.getQualifiers().containsAll(key.getQualifiers())) {
                throw new DefinitionException(Types.raw(type), "found during auto discovery is missing qualifiers required by: [" + key + "]");
            }
            return injectable;
        }

        private Injectable<?> attemptCreateInjectable(Binding binding) {
            Key key = binding.getKey();
            Type type = key.getType();
            Injectable injectable = DefaultDiscovererFactory.this.classInjectableFactory.create(type);
            if (!injectable.getQualifiers().containsAll(key.getQualifiers())) {
                throw new DefinitionException(Types.raw(binding.getType()), "found during auto discovery is missing qualifiers required by: " + binding);
            }
            return injectable;
        }

        private String toChain(Key key) {
            if (this.via.containsKey(key)) {
                return this.toChain(this.via.get(key)) + " -> [" + key + "]";
            }
            return "[" + key + "]";
        }
    }
}

