/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config.standard;

import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.QualifiedType;
import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.injection.Constructable;
import hs.ddif.core.instantiation.injection.Injection;
import hs.ddif.core.scope.ScopeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class DefaultInjectable<T>
implements Injectable<T> {
    private final Type ownerType;
    private final QualifiedType qualifiedType;
    private final List<Binding> bindings;
    private final ScopeResolver scopeResolver;
    private final Object discriminator;
    private final Constructable<T> constructable;
    private final int hashCode;

    DefaultInjectable(Type ownerType, QualifiedType qualifiedType, List<Binding> bindings, ScopeResolver scopeResolver, Object discriminator, Constructable<T> constructable) {
        if (ownerType == null) {
            throw new IllegalArgumentException("ownerType cannot be null");
        }
        if (qualifiedType == null) {
            throw new IllegalArgumentException("qualifiedType cannot be null");
        }
        if (bindings == null) {
            throw new IllegalArgumentException("bindings cannot be null");
        }
        if (scopeResolver == null) {
            throw new IllegalArgumentException("scopeResolver cannot be null");
        }
        if (constructable == null) {
            throw new IllegalArgumentException("constructable cannot be null");
        }
        this.ownerType = ownerType;
        this.qualifiedType = qualifiedType;
        this.bindings = Collections.unmodifiableList(new ArrayList<Binding>(bindings));
        this.scopeResolver = scopeResolver;
        this.discriminator = discriminator;
        this.constructable = constructable;
        this.hashCode = this.calculateHash();
    }

    private int calculateHash() {
        return Objects.hash(this.qualifiedType, this.ownerType, this.discriminator);
    }

    @Override
    public Type getType() {
        return this.qualifiedType.getType();
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiedType.getQualifiers();
    }

    @Override
    public List<Binding> getBindings() {
        return this.bindings;
    }

    @Override
    public ScopeResolver getScopeResolver() {
        return this.scopeResolver;
    }

    @Override
    public T create(List<Injection> injections) throws InstanceCreationFailure {
        return this.constructable.create(injections);
    }

    @Override
    public void destroy(T instance) {
        this.constructable.destroy(instance);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultInjectable other = (DefaultInjectable)obj;
        return this.qualifiedType.equals(other.qualifiedType) && this.ownerType.equals(other.ownerType) && Objects.equals(this.discriminator, other.discriminator);
    }

    public String toString() {
        return "Injectable[" + this.qualifiedType + (String)(this.discriminator instanceof AccessibleObject ? " <- " + this.discriminator : "") + "]";
    }
}

