/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config.standard;

import hs.ddif.core.api.InstanceResolver;
import hs.ddif.core.api.NoSuchInstanceException;
import hs.ddif.core.config.discovery.Discoverer;
import hs.ddif.core.config.discovery.DiscovererFactory;
import hs.ddif.core.config.discovery.DiscoveryFailure;
import hs.ddif.core.config.standard.DiscoveryException;
import hs.ddif.core.config.standard.KeyFactory;
import hs.ddif.core.inject.store.InjectableStore;
import hs.ddif.core.instantiation.InstantiationContext;
import hs.ddif.core.instantiation.Instantiator;
import hs.ddif.core.instantiation.InstantiatorFactory;
import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.domain.InstanceResolutionFailure;
import hs.ddif.core.instantiation.domain.MultipleInstances;
import hs.ddif.core.instantiation.domain.NoSuchInstance;
import hs.ddif.core.store.Key;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DefaultInstanceResolver
implements InstanceResolver {
    private final InjectableStore store;
    private final DiscovererFactory discovererFactory;
    private final InstantiationContext instantiationContext;
    private final InstantiatorFactory instantiatorFactory;

    public DefaultInstanceResolver(InjectableStore store, DiscovererFactory discovererFactory, InstantiationContext instantiationContext, InstantiatorFactory instantiatorFactory) {
        this.store = store;
        this.discovererFactory = discovererFactory;
        this.instantiationContext = instantiationContext;
        this.instantiatorFactory = instantiatorFactory;
    }

    @Override
    public synchronized <T> T getInstance(Type type, Object ... qualifiers) {
        try {
            Key key = KeyFactory.of(type, qualifiers);
            T instance = this.getInstance(key);
            if (instance == null) {
                throw new NoSuchInstanceException("No such instance: " + key, null);
            }
            return instance;
        }
        catch (InstanceResolutionFailure f) {
            throw f.toRuntimeException();
        }
    }

    @Override
    public synchronized <T> T getInstance(Class<T> cls, Object ... qualifiers) {
        return this.getInstance((Type)cls, qualifiers);
    }

    @Override
    public synchronized <T> List<T> getInstances(Type type, Predicate<Type> predicate, Object ... qualifiers) {
        try {
            return this.getInstances(KeyFactory.of(type, qualifiers), predicate);
        }
        catch (InstanceCreationFailure f) {
            throw f.toRuntimeException();
        }
    }

    @Override
    public synchronized <T> List<T> getInstances(Class<T> cls, Predicate<Type> predicate, Object ... qualifiers) {
        return (List)this.getInstance((Type)cls, predicate, qualifiers);
    }

    @Override
    public synchronized <T> List<T> getInstances(Type type, Object ... qualifiers) {
        return this.getInstances(type, null, qualifiers);
    }

    @Override
    public synchronized <T> List<T> getInstances(Class<T> cls, Object ... qualifiers) {
        return this.getInstances((Type)cls, qualifiers);
    }

    public InjectableStore getStore() {
        return this.store;
    }

    private <T> T getInstance(Key key) throws NoSuchInstance, MultipleInstances, InstanceCreationFailure {
        Instantiator instantiator = this.instantiatorFactory.getInstantiator(key, null);
        Discoverer discoverer = this.discovererFactory.create(this.store, instantiator.getKey());
        Set<Object> gatheredInjectables = Set.of();
        try {
            gatheredInjectables = discoverer.discover();
            if (!gatheredInjectables.isEmpty()) {
                this.store.putAll(gatheredInjectables);
            }
        }
        catch (Exception e) {
            DiscoveryFailure f = new DiscoveryFailure(key, "instantiation failed because auto discovery was unable to resolve all dependencies; found: " + gatheredInjectables.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList()), (Throwable)e);
            if (!discoverer.getProblems().isEmpty()) {
                f.addSuppressed(new DiscoveryException(discoverer.getProblems()));
            }
            throw f;
        }
        try {
            return instantiator.getInstance(this.instantiationContext);
        }
        catch (Exception e) {
            if (!gatheredInjectables.isEmpty()) {
                this.store.removeAll(gatheredInjectables);
            }
            throw e;
        }
    }

    private <T> List<T> getInstances(Key key, Predicate<Type> typePredicate) throws InstanceCreationFailure {
        return this.instantiationContext.createAll(key, typePredicate);
    }
}

