/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config.standard;

import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.inject.store.BoundInstantiatorProvider;
import hs.ddif.core.instantiation.InstantiationContext;
import hs.ddif.core.instantiation.Instantiator;
import hs.ddif.core.instantiation.domain.InstanceCreationFailure;
import hs.ddif.core.instantiation.domain.MultipleInstances;
import hs.ddif.core.instantiation.domain.NoSuchInstance;
import hs.ddif.core.instantiation.injection.Injection;
import hs.ddif.core.scope.InjectionContext;
import hs.ddif.core.scope.OutOfScopeException;
import hs.ddif.core.scope.ScopeResolver;
import hs.ddif.core.store.Key;
import hs.ddif.core.store.Resolver;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;

public class DefaultInstantiationContext
implements InstantiationContext {
    private static final Logger LOGGER = Logger.getLogger(DefaultInstantiationContext.class.getName());
    private final Deque<LazyInjectionContext> stack = new ArrayDeque<LazyInjectionContext>();
    private final Resolver<Injectable<?>> resolver;
    private final BoundInstantiatorProvider boundInstantiatorProvider;

    public DefaultInstantiationContext(Resolver<Injectable<?>> resolver, BoundInstantiatorProvider boundInstantiatorProvider) {
        this.resolver = resolver;
        this.boundInstantiatorProvider = boundInstantiatorProvider;
    }

    @Override
    public synchronized <T> T create(Key key) throws InstanceCreationFailure, MultipleInstances {
        Set<Injectable<?>> injectables = this.resolver.resolve(key);
        if (injectables.size() > 1) {
            throw new MultipleInstances(key, injectables);
        }
        if (injectables.size() == 0) {
            return null;
        }
        return (T)this.createInstance(injectables.iterator().next());
    }

    @Override
    public synchronized <T> List<T> createAll(Key key, Predicate<Type> typePredicate) throws InstanceCreationFailure {
        ArrayList instances = new ArrayList();
        Set<Injectable<?>> injectables = this.resolver.resolve(key);
        for (Injectable<?> injectable : injectables) {
            Object instance;
            if (typePredicate != null && !typePredicate.test(injectable.getType()) || (instance = this.createInstanceInScope(injectable)) == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    private <T> T createInstance(Injectable<T> injectable) throws InstanceCreationFailure {
        return this.createInstance(injectable, false);
    }

    private <T> T createInstanceInScope(Injectable<T> injectable) throws InstanceCreationFailure {
        return this.createInstance(injectable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T createInstance(Injectable<T> injectable, boolean allowOutOfScope) throws InstanceCreationFailure {
        ScopeResolver scopeResolver = injectable.getScopeResolver();
        try {
            if (allowOutOfScope) {
                if (!scopeResolver.isActive()) return null;
            }
            LazyInjectionContext lazyInjectionContext = new LazyInjectionContext(this.stack.isEmpty() ? null : this.stack.getLast(), injectable);
            this.stack.addLast(lazyInjectionContext);
            try {
                T instance = scopeResolver.get(injectable, lazyInjectionContext);
                lazyInjectionContext.add(injectable, instance);
                T t = instance;
                return t;
            }
            finally {
                this.stack.removeLast();
            }
        }
        catch (OutOfScopeException e) {
            if (!allowOutOfScope) {
                throw new InstanceCreationFailure(injectable.getType(), "could not be created", (Throwable)e);
            }
            LOGGER.warning("Scope " + scopeResolver.getAnnotationClass() + " should have been active: " + e.getMessage());
            return null;
        }
        catch (InstanceCreationFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstanceCreationFailure(injectable.getType(), "could not be created", (Throwable)e);
        }
    }

    private class LazyInjectionContext
    implements InjectionContext {
        private final Injectable<?> injectable;
        private final LazyInjectionContext parent;
        private final Deque<Runnable> dependents = new ArrayDeque<Runnable>();
        private List<Injection> injections;

        LazyInjectionContext(LazyInjectionContext parent, Injectable<?> injectable) {
            boolean dependent = injectable.getScopeResolver().getAnnotationClass() == null;
            this.parent = dependent ? parent : null;
            this.injectable = injectable;
        }

        @Override
        public List<Injection> getInjections() throws InstanceCreationFailure, MultipleInstances, NoSuchInstance {
            if (this.injections == null) {
                ArrayList<Injection> injections = new ArrayList<Injection>();
                for (Binding binding : this.injectable.getBindings()) {
                    Instantiator instantiator = DefaultInstantiationContext.this.boundInstantiatorProvider.getInstantiator(binding);
                    injections.add(new Injection(binding.getAccessibleObject(), instantiator.getInstance(DefaultInstantiationContext.this)));
                }
                this.injections = injections;
            }
            return this.injections;
        }

        @Override
        public void release() {
            this.dependents.forEach(Runnable::run);
        }

        <T> void add(Injectable<T> injectable, T instance) {
            if (this.parent == null) {
                this.dependents.addFirst(() -> injectable.destroy(instance));
            } else {
                this.parent.add(injectable, instance);
            }
        }
    }
}

