/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.config.standard;

import hs.ddif.core.api.CandidateRegistry;
import hs.ddif.core.config.discovery.Discoverer;
import hs.ddif.core.config.discovery.DiscovererFactory;
import hs.ddif.core.config.standard.DiscoveryException;
import hs.ddif.core.config.standard.KeyFactory;
import hs.ddif.core.definition.InstanceInjectableFactory;
import hs.ddif.core.inject.store.InjectableStore;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;

public class InjectableStoreCandidateRegistry
implements CandidateRegistry {
    private final InjectableStore store;
    private final DiscovererFactory discovererFactory;
    private final InstanceInjectableFactory instanceInjectableFactory;

    public InjectableStoreCandidateRegistry(InjectableStore store, DiscovererFactory discovererFactory, InstanceInjectableFactory instanceInjectableFactory) {
        this.store = store;
        this.discovererFactory = discovererFactory;
        this.instanceInjectableFactory = instanceInjectableFactory;
    }

    @Override
    public boolean contains(Type type, Object ... qualifiers) {
        return this.store.contains(KeyFactory.of(type, qualifiers));
    }

    @Override
    public void register(Type type) {
        this.registerInternal(List.of(type));
    }

    @Override
    public void register(List<Type> types) {
        this.registerInternal(types);
    }

    @Override
    public void registerInstance(Object instance, Annotation ... qualifiers) {
        this.store.putAll(this.discovererFactory.create(this.store, this.instanceInjectableFactory.create(instance, qualifiers)).discover());
    }

    @Override
    public void remove(Type type) {
        this.removeInternal(List.of(type));
    }

    @Override
    public void remove(List<Type> types) {
        this.removeInternal(types);
    }

    @Override
    public void removeInstance(Object instance) {
        this.store.removeAll(this.discovererFactory.create(this.store, this.instanceInjectableFactory.create(instance, new Annotation[0])).discover());
    }

    private void registerInternal(List<Type> types) {
        Discoverer discoverer = this.discovererFactory.create(this.store, types);
        try {
            this.store.putAll(discoverer.discover());
        }
        catch (Exception e) {
            if (!discoverer.getProblems().isEmpty()) {
                e.addSuppressed(new DiscoveryException(discoverer.getProblems()));
            }
            throw e;
        }
    }

    private void removeInternal(List<Type> types) {
        Discoverer discoverer = this.discovererFactory.create(this.store, types);
        try {
            this.store.removeAll(discoverer.discover());
        }
        catch (Exception e) {
            if (!discoverer.getProblems().isEmpty()) {
                e.addSuppressed(new DiscoveryException(discoverer.getProblems()));
            }
            throw e;
        }
    }
}

