/*
 * Decompiled with CFR 0.152.
 */
package hs.ddif.core.definition;

import hs.ddif.core.definition.DefinitionException;
import hs.ddif.core.definition.Injectable;
import hs.ddif.core.definition.InjectableFactory;
import hs.ddif.core.definition.LifeCycleCallbacksFactory;
import hs.ddif.core.definition.bind.Binding;
import hs.ddif.core.definition.bind.BindingException;
import hs.ddif.core.definition.bind.BindingProvider;
import hs.ddif.core.instantiation.factory.ClassObjectFactory;
import hs.ddif.core.util.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public class ClassInjectableFactory {
    private final BindingProvider bindingProvider;
    private final InjectableFactory injectableFactory;
    private final LifeCycleCallbacksFactory lifeCycleCallbacksFactory;

    public ClassInjectableFactory(BindingProvider bindingProvider, InjectableFactory injectableFactory, LifeCycleCallbacksFactory lifeCycleCallbacksFactory) {
        this.bindingProvider = bindingProvider;
        this.injectableFactory = injectableFactory;
        this.lifeCycleCallbacksFactory = lifeCycleCallbacksFactory;
    }

    public <T> Injectable<T> create(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Class cls = Types.raw(type);
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new DefinitionException(cls, "cannot be abstract");
        }
        if (Types.containsTypeVariables(type)) {
            throw new DefinitionException(cls, "cannot have unresolvable type variables: " + Arrays.toString(cls.getTypeParameters()));
        }
        try {
            Constructor constructor = this.bindingProvider.getConstructor(cls);
            List<Binding> bindings = this.bindingProvider.ofConstructorAndMembers(constructor, cls);
            return this.injectableFactory.create(type, null, cls, bindings, new ClassObjectFactory(constructor, this.lifeCycleCallbacksFactory.create(cls)));
        }
        catch (BindingException e) {
            throw new DefinitionException(cls, "could not be bound", e);
        }
    }
}

